/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;

public class CustomButton
extends JLabel
implements MouseListener {
    private Color old = new Color(100, 100, 100);
    private int alpha = 0;
    private boolean inside = false;
    private boolean insideClick = false;

    public CustomButton() {
        this.setOpaque(false);
        this.setBackground(this.old);
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(0);
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.setForeground(new Color(204, 204, 204));
        this.addMouseListener(this);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.old = c;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        int r = this.getBackground().getRed();
        int g = this.getBackground().getGreen();
        int b = this.getBackground().getBlue();
        gr.setColor(new Color(r, g, b, this.alpha));
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.inside) {
            this.insideClick = true;
        }
        this.old = this.getBackground();
        super.setBackground(new Color(70, 70, 70));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.inside && this.insideClick) {
            for (MouseListener ml : this.getMouseListeners()) {
                ml.mouseClicked(e);
            }
        }
        this.insideClick = false;
        super.setBackground(this.old);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.inside = true;
        if (this.insideClick) {
            this.old = this.getBackground();
            super.setBackground(new Color(70, 70, 70));
        }
        this.setOpaque(true);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.inside = false;
        this.setOpaque(false);
        super.setBackground(this.old);
        this.repaint();
    }
}

