/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.CustomPaintPanel3;
import net.modmaker.Gui.CustomPaintPanel4;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Utils.Textures;
import net.modmaker.backup.Backup;
import net.modmaker.backup.BackupManager;
import net.modmaker.events.Listeners.UpdateListener;
import net.modmaker.events.UpdateEvent;

public class Backups
extends JDialog {
    private ButtonGroup buttonGroup1;
    private CustomButton customButton1;
    private CustomButton customButton2;
    private CustomButton customButton3;
    private CustomButton customButton4;
    private CustomButton customButton5;
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel3 customPaintPanel31;
    private CustomPaintPanel4 customPaintPanel41;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JTable jTable1;

    public Backups(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(new Color(51, 51, 51));
        this.updateTable();
        BackupManager.addUpdateListener(new UpdateListener(){

            @Override
            public void onUpdate(UpdateEvent event) {
                Backups.this.updateTable();
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        if (BackupManager.getTimeToDeleteBackup() == 4) {
            this.jCheckBox1.setSelected(true);
        } else if (BackupManager.getTimeToDeleteBackup() == 3) {
            this.jCheckBox2.setSelected(true);
        } else if (BackupManager.getTimeToDeleteBackup() == 2) {
            this.jCheckBox3.setSelected(true);
        } else if (BackupManager.getTimeToDeleteBackup() == 1) {
            this.jCheckBox4.setSelected(true);
        } else if (BackupManager.getTimeToDeleteBackup() == 0) {
            this.jCheckBox5.setSelected(true);
        }
        this.jScrollPane1.getViewport().setOpaque(false);
        this.jScrollPane1.setBorder(null);
    }

    private void updateTable() {
        Object[][] obj = new Object[BackupManager.getBackups().size()][4];
        for (int i = 0; i < BackupManager.getBackups().size(); ++i) {
            obj[i][0] = i + 1;
            obj[i][1] = BackupManager.getBackups().get(i).getDate();
            obj[i][2] = BackupManager.getBackups().get(i).getTimeAgo();
            obj[i][3] = BackupManager.getBackups().get(i).getTypeAsString();
        }
        this.jTable1.setModel(new DefaultTableModel(obj, new String[]{"Id", "Date", "Time", "Type"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        CustomCellRenderer render = new CustomCellRenderer();
        this.jTable1.getColumn("Id").setCellRenderer(render);
        this.jTable1.getColumn("Date").setCellRenderer(render);
        this.jTable1.getColumn("Time").setCellRenderer(render);
        this.jTable1.getColumn("Type").setCellRenderer(render);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.customButton1 = new CustomButton();
        this.customButton2 = new CustomButton();
        this.customPaintPanel31 = new CustomPaintPanel3();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.customButton3 = new CustomButton();
        this.customButton4 = new CustomButton();
        this.customButton5 = new CustomButton();
        this.jSeparator2 = new JSeparator();
        this.customPaintPanel41 = new CustomPaintPanel4();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Backup Manager");
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.customButton1.setIcon(new ImageIcon(Textures.smallCancel));
        this.customButton1.setText("Cancel");
        this.customButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Backups.this.customButton1MouseClicked(evt);
            }
        });
        this.customButton2.setIcon(new ImageIcon(Textures.smallOk));
        this.customButton2.setText("Apply");
        this.customButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Backups.this.customButton2MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton2, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton1, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customButton1, -2, 30, -2).addComponent(this.customButton2, -2, 30, -2)).addContainerGap()));
        this.customPaintPanel31.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel31.setMaxColor(70);
        this.customPaintPanel31.setMinColor(100);
        this.buttonGroup1.add(this.jCheckBox1);
        this.jCheckBox1.setForeground(new Color(204, 204, 204));
        this.jCheckBox1.setText("Never delete a backup");
        this.jCheckBox1.setOpaque(false);
        this.buttonGroup1.add(this.jCheckBox2);
        this.jCheckBox2.setForeground(new Color(204, 204, 204));
        this.jCheckBox2.setText("1 Month");
        this.jCheckBox2.setOpaque(false);
        this.buttonGroup1.add(this.jCheckBox3);
        this.jCheckBox3.setForeground(new Color(204, 204, 204));
        this.jCheckBox3.setText("1 Week");
        this.jCheckBox3.setOpaque(false);
        this.buttonGroup1.add(this.jCheckBox4);
        this.jCheckBox4.setForeground(new Color(204, 204, 204));
        this.jCheckBox4.setText("1 Day");
        this.jCheckBox4.setOpaque(false);
        this.buttonGroup1.add(this.jCheckBox5);
        this.jCheckBox5.setForeground(new Color(204, 204, 204));
        this.jCheckBox5.setText("Don't Backup");
        this.jCheckBox5.setOpaque(false);
        this.jLabel2.setForeground(new Color(204, 204, 204));
        this.jLabel2.setText("How long to delete a backup");
        this.customButton3.setText("Restore Backup");
        this.customButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Backups.this.customButton3MouseClicked(evt);
            }
        });
        this.customButton4.setText("Delete Backup");
        this.customButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Backups.this.customButton4MouseClicked(evt);
            }
        });
        this.customButton5.setText("Backup Now");
        this.customButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Backups.this.customButton5MouseClicked(evt);
            }
        });
        this.jSeparator2.setBackground(new Color(51, 51, 51));
        this.jSeparator2.setForeground(new Color(100, 100, 100));
        this.customPaintPanel41.setBackground(new Color(51, 51, 51));
        this.customPaintPanel41.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel41.setAlpha(70);
        this.customPaintPanel41.setOpaque(false);
        this.jScrollPane1.setOpaque(false);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable1.setOpaque(false);
        this.jTable1.setRowHeight(20);
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout customPaintPanel41Layout = new GroupLayout(this.customPaintPanel41);
        this.customPaintPanel41.setLayout(customPaintPanel41Layout);
        customPaintPanel41Layout.setHorizontalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 577, Short.MAX_VALUE));
        customPaintPanel41Layout.setVerticalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        GroupLayout customPaintPanel31Layout = new GroupLayout(this.customPaintPanel31);
        this.customPaintPanel31.setLayout(customPaintPanel31Layout);
        customPaintPanel31Layout.setHorizontalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addComponent(this.customPaintPanel41, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox2, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.customButton3, -1, -1, Short.MAX_VALUE).addComponent(this.customButton4, -1, -1, Short.MAX_VALUE).addComponent(this.customButton5, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator2)).addContainerGap()));
        customPaintPanel31Layout.setVerticalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel41, -1, -1, Short.MAX_VALUE).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.customButton3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton4, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton5, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox3).addGap(3, 3, 3).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addGap(0, 98, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel1.setFont(new Font("Tahoma", 0, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Backups");
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 28, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel11, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel21, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2)));
        this.pack();
    }

    private void customButton1MouseClicked(MouseEvent evt) {
        this.dispose();
        this.setVisible(false);
    }

    private void customButton2MouseClicked(MouseEvent evt) {
        this.dispose();
        this.setVisible(false);
        if (this.jCheckBox1.isSelected()) {
            BackupManager.setTimeToDeleteBackup(4);
        } else if (this.jCheckBox2.isSelected()) {
            BackupManager.setTimeToDeleteBackup(3);
        } else if (this.jCheckBox3.isSelected()) {
            BackupManager.setTimeToDeleteBackup(2);
        } else if (this.jCheckBox4.isSelected()) {
            BackupManager.setTimeToDeleteBackup(1);
        } else if (this.jCheckBox5.isSelected()) {
            BackupManager.setTimeToDeleteBackup(0);
        }
        BackupManager.checkAllBackups();
        BackupManager.saveBackup();
    }

    private void customButton5MouseClicked(MouseEvent evt) {
        BackupManager.backup();
    }

    private void customButton4MouseClicked(MouseEvent evt) {
        try {
            int row = this.jTable1.getSelectedRow();
            if (row != -1) {
                int ret = OptionPane.showConfirmDialog(this, "Are you sure you want to delete this backup?", "Delete Backup", 0, 2);
                if (ret == 0) {
                    Backup backup = BackupManager.getBackups().get(row);
                    new File(backup.getBackupFile().getPath() + ".zip").delete();
                    BackupManager.getBackups().remove(row);
                    this.updateTable();
                }
            } else {
                OptionPane.showMessageDialog(this, "Nothing Selected", "Restore", 2);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void customButton3MouseClicked(MouseEvent evt) {
        try {
            int row = this.jTable1.getSelectedRow();
            if (row != -1) {
                int ret = OptionPane.showConfirmDialog(this, "Are you sure you want to restore this backup?", "Restore Backup", 0, 2);
                if (ret == 0) {
                    Backup backup = BackupManager.getBackups().get(row);
                    if (backup != null) {
                        BackupManager.restore(backup);
                        OptionPane.showMessageDialog(this, "Backup successfully restored", "Resotre", 1);
                    } else {
                        Console.Warning("Backup = null");
                        OptionPane.showMessageDialog(this, "Something went wrong: backup = null", "Restore", 0);
                    }
                }
            } else {
                OptionPane.showMessageDialog(this, "Nothing Selected", "Restore", 2);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Backups.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Backups.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Backups.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Backups.class.getName()).log(Level.SEVERE, null, ex);
        }
        Textures.Load();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Backups dialog = new Backups((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class CustomCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public CustomCellRenderer() {
            this.setForeground(new Color(204, 204, 204));
            this.setBackground(new Color(150, 150, 150));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(String.valueOf(value));
            this.setOpaque(isSelected);
            if (isSelected) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(new Color(204, 204, 204));
            }
            return this;
        }
    }
}

