/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.CustomPaintPanel3;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;
import net.modmaker.plugin.PluginManager;

public class DownloadDialog
extends JDialog
implements Runnable {
    public static final int STATE_WAITING = 0;
    public static final int STATE_DOWNLOADING = 1;
    public static final int STATE_PAUSE = 2;
    public static final int STATE_FINISHED = 3;
    public static final int STATE_FAILED = 4;
    private Throwable error;
    private Thread downloadThread;
    private int state = 0;
    private final String title;
    private final ArrayList<PluginManager.UpdateData> downloads;
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private CustomButton customButton1;
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel3 customPaintPanel31;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JProgressBar jProgressBar1;
    private JProgressBar jProgressBar2;

    public DownloadDialog(String title, ArrayList<PluginManager.UpdateData> downloads) {
        this.setModal(true);
        this.title = title;
        this.downloads = downloads;
        this.initComponents();
        this.setIconImage(Textures.LogoScalled);
    }

    private void initComponents() {
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.customButton1 = new CustomButton();
        this.customPaintPanel31 = new CustomPaintPanel3();
        this.jProgressBar2 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DownloadDialog.this.formWindowClosing(evt);
            }
        });
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.customButton1.setText("Cancel");
        this.customButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DownloadDialog.this.customButton1MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton1, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton1, -2, 30, -2).addContainerGap()));
        this.customPaintPanel31.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel31.setMaxColor(70);
        this.customPaintPanel31.setMinColor(100);
        this.jProgressBar2.setForeground(new Color(200, 100, 0));
        this.jProgressBar2.setStringPainted(true);
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Downloading: ");
        this.jProgressBar1.setForeground(new Color(200, 100, 0));
        this.jProgressBar1.setStringPainted(true);
        this.jLabel2.setFont(new Font("Tahoma", 1, 14));
        this.jLabel2.setForeground(new Color(204, 204, 204));
        this.jLabel2.setText("Total Progres:");
        GroupLayout customPaintPanel31Layout = new GroupLayout(this.customPaintPanel31);
        this.customPaintPanel31.setLayout(customPaintPanel31Layout);
        customPaintPanel31Layout.setHorizontalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -1, 610, Short.MAX_VALUE).addGroup(customPaintPanel31Layout.createSequentialGroup().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jProgressBar2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        customPaintPanel31Layout.setVerticalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel31Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar2, -2, -1, -2).addContainerGap(112, Short.MAX_VALUE)));
        this.jLabel4.setFont(new Font("Tahoma", 0, 18));
        this.jLabel4.setForeground(new Color(204, 204, 204));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(this.title);
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -1, 28, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel11, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel31, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            int r = OptionPane.showConfirmDialog(this, "Are you sure, you want to stop the download?", "Stop?", 0, 3);
            if (r == 0) {
                this.getDownloadThread().stop();
                this.setState(4);
                this.error = new Exception("Stopped by user");
                this.dispose();
                this.setVisible(false);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void customButton1MouseClicked(MouseEvent evt) {
        try {
            int r = OptionPane.showConfirmDialog(this, "Are you sure, you want to stop the download?", "Stop?", 0, 3);
            if (r == 0) {
                this.getDownloadThread().stop();
                this.setState(4);
                this.error = new Exception("Stopped by user");
                this.dispose();
                this.setVisible(false);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public void Download(boolean start) throws Exception {
        if (this.state == 3) {
            throw new RuntimeException("Already finished downloading");
        }
        if (this.state == 4) {
            throw new RuntimeException("Already failed downloading");
        }
        if (start) {
            if (this.state == 1) {
                throw new RuntimeException("Is already downloading");
            }
            if (this.state == 0) {
                this.getDownloadThread().start();
                this.setState(1);
            } else if (this.state == 2) {
                this.getDownloadThread().resume();
                this.setState(1);
            }
        } else {
            if (this.state == 0) {
                throw new RuntimeException("Download hasn't start");
            }
            if (this.state == 2) {
                throw new RuntimeException("Download is already pausing");
            }
            if (this.state == 1) {
                this.getDownloadThread().suspend();
                this.setState(1);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(ce);
        }
    }

    public void addStateChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void removeStateChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    private Thread getDownloadThread() {
        if (this.downloadThread == null) {
            this.downloadThread = new Thread(this);
            this.downloadThread.setName("Download Thread");
            return this.downloadThread;
        }
        return this.downloadThread;
    }

    public Throwable getError() {
        return this.error;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Settings.put("modmaker.uptodate.server", "dropbox");
                ArrayList<PluginManager.UpdateData> updates = new ArrayList<PluginManager.UpdateData>();
                try {
                    updates.add(new PluginManager.UpdateData(null, "Recipe", 1.05, new URL("https://dl.dropboxusercontent.com/u/18290052/ModMaker/plugins/2.05/Plugin_Recipes.jar"), new File(Settings.getRoot() + "/pluginsss/Recipe.jar")));
                    updates.add(new PluginManager.UpdateData(null, "Block", 1.05, new URL("https://dl.dropboxusercontent.com/u/18290052/ModMaker/plugins/2.05/Plugin_Block.jar"), new File(Settings.getRoot() + "/pluginsss/Block.jar")));
                    updates.add(new PluginManager.UpdateData(null, "Item", 1.05, new URL("https://dl.dropboxusercontent.com/u/18290052/ModMaker/plugins/2.05/Plugin_Item.jar"), new File(Settings.getRoot() + "/pluginsss/Item.jar")));
                    updates.add(new PluginManager.UpdateData(null, "Smelting", 1.05, new URL("https://dl.dropboxusercontent.com/u/18290052/ModMaker/plugins/2.05/Plugin_Smelting.jar"), new File(Settings.getRoot() + "/pluginsss/Smelting.jar")));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
                final DownloadDialog dd = new DownloadDialog("Repair plugins", updates);
                dd.setVisible(true);
                try {
                    System.out.println("Start");
                    dd.Download(true);
                    dd.addStateChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            if (dd.getState() == 3) {
                                System.exit(0);
                            } else if (dd.getState() == 4) {
                                System.exit(1);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    Logger.getLogger(DownloadDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    @Override
    public void run() {
        try {
            InputStream[] inStreams = new InputStream[this.downloads.size()];
            Integer[] sizes = new Integer[this.downloads.size()];
            this.jLabel1.setText("Connection to " + Settings.get("modmaker.uptodate.server") + " server ...");
            this.jProgressBar1.setValue(0);
            for (int i = 0; i < this.downloads.size(); ++i) {
                PluginManager.UpdateData ud = this.downloads.get(i);
                this.jProgressBar1.setValue(100 / this.downloads.size() * i);
                this.jLabel1.setText("Connection to " + Settings.get("modmaker.uptodate.server") + " server ... (" + (i + 1) + "/" + this.downloads.size() + ")");
                HttpURLConnection connection = (HttpURLConnection)ud.getLink().openConnection();
                connection.setRequestProperty("Range", "bytes=0-");
                connection.connect();
                if (connection.getResponseCode() / 100 != 2) {
                    throw new RuntimeException("gettings Wrong Responsecode: " + connection.getResponseCode());
                }
                int contentLength = connection.getContentLength();
                sizes[i] = contentLength;
                inStreams[i] = connection.getInputStream();
            }
            int totalDownload = 0;
            int totalSize = 0;
            Integer[] arr$ = sizes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int s = arr$[i$];
                totalSize += s;
            }
            this.jLabel2.setText("Total Progres: (" + totalDownload / 1024 + "kB/" + totalSize / 1024 + "kB)");
            for (int i = 0; i < this.downloads.size(); ++i) {
                PluginManager.UpdateData ud = this.downloads.get(i);
                long Starttime = System.currentTimeMillis();
                this.jLabel1.setText("Downloading: " + ud.getName() + " (" + (i + 1) + "/" + this.downloads.size() + ")");
                this.jProgressBar1.setValue(0);
                File outputFile = ud.getOutputFile();
                outputFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outputFile);
                InputStream in = inStreams[i];
                int downloaded = 0;
                int size = sizes[i];
                int tick = 0;
                while (true) {
                    ++tick;
                    byte[] buffer = size - downloaded > 512 || size < 1 ? new byte[512] : new byte[size - downloaded];
                    int read = in.read(buffer);
                    if (read == -1) break;
                    out.write(buffer, 0, read);
                    this.jLabel2.setText("Total Progres: (" + (totalDownload += read) / 1024 + "kB/" + totalSize / 1024 + "kB)");
                    this.jProgressBar1.setValue((int)((double)(downloaded += read) / (double)size * 100.0));
                    this.jProgressBar2.setValue((int)((double)totalDownload / (double)totalSize * 100.0));
                }
                Console.Info("Download: " + ud.getName() + ", " + (System.currentTimeMillis() - Starttime) + ", " + size / 1024);
                this.jProgressBar1.setValue(100);
            }
            this.setState(3);
            this.dispose();
            this.setVisible(false);
        }
        catch (ThreadDeath td) {
        }
        catch (Throwable e) {
            this.error = e;
            Console.Err(e);
            this.setState(4);
        }
    }
}

