/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.CustomPaintPanel3;
import net.modmaker.Gui.Dialogs.ItemChooser;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.Utils.DropData;
import net.modmaker.Utils.Textures;
import net.modmaker.plugin.SaveBase;

public class DropEditor
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final ArrayList<DropData> rareDrops;
    private final ArrayList<DropData> drops;
    private final Mod mod;
    private final SaveBase saveBase;
    private CustomButton customButton1;
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel3 customPaintPanel31;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jList1;
    private JList jList2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JSpinner jSpinner3;
    private JSpinner jSpinner4;
    private int returnStatus = 1;

    public DropEditor(SaveBase saveBase) {
        super((Frame)Settings.getFrame(), true);
        this.initComponents();
        this.drops = saveBase.getDrops();
        this.rareDrops = saveBase.getRareDrops();
        this.mod = saveBase.getMod();
        this.saveBase = saveBase;
        this.jCheckBox1.setSelected(saveBase.dropItself());
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DropEditor.this.doClose(1);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.getContentPane().setBackground(new Color(51, 51, 51));
        this.refreshLists();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.customButton1 = new CustomButton();
        this.customPaintPanel31 = new CustomPaintPanel3();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jSpinner3 = new JSpinner();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jLabel4 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jSpinner4 = new JSpinner();
        this.jButton4 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel6 = new JLabel();
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel7 = new JLabel();
        this.setTitle("Drop Editor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DropEditor.this.closeDialog(evt);
            }
        });
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.customButton1.setIcon(new ImageIcon(Textures.smallOk));
        this.customButton1.setText("Ok");
        this.customButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DropEditor.this.customButton1MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton1, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton1, -2, 30, -2).addContainerGap()));
        this.customPaintPanel31.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel31.setMaxColor(70);
        this.customPaintPanel31.setMinColor(100);
        this.jCheckBox1.setForeground(new Color(200, 200, 200));
        this.jCheckBox1.setText("Drop Itself");
        this.jCheckBox1.setOpaque(false);
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DropEditor.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.jLabel1.setForeground(new Color(200, 200, 200));
        this.jLabel1.setText("Normal Drops:");
        this.jList1.setBackground(new Color(100, 100, 100));
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DropEditor.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel2.setForeground(new Color(200, 200, 200));
        this.jLabel2.setText("Amount:");
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jSpinner1.setEnabled(false);
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DropEditor.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel5.setForeground(new Color(200, 200, 200));
        this.jLabel5.setText("Chance %:");
        this.jSpinner3.setModel(new SpinnerNumberModel(50, 0, 100, 1));
        this.jSpinner3.setEnabled(false);
        this.jSpinner3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DropEditor.this.jSpinner3StateChanged(evt);
            }
        });
        this.jButton1.setText("Add");
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Remove");
        this.jButton2.setEnabled(false);
        this.jButton2.setOpaque(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jSeparator2.setBackground(new Color(51, 51, 51));
        this.jSeparator2.setForeground(new Color(100, 100, 100));
        this.jSeparator2.setOrientation(1);
        this.jSeparator1.setBackground(new Color(51, 51, 51));
        this.jSeparator1.setForeground(new Color(100, 100, 100));
        this.jLabel3.setForeground(new Color(200, 200, 200));
        this.jLabel3.setText("Rare Drops:");
        this.jList2.setBackground(new Color(100, 100, 100));
        this.jList2.setSelectionMode(0);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DropEditor.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.jLabel4.setForeground(new Color(200, 200, 200));
        this.jLabel4.setText("Amount:");
        this.jSpinner2.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jSpinner2.setEnabled(false);
        this.jSpinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DropEditor.this.jSpinner2StateChanged(evt);
            }
        });
        this.jSpinner4.setModel(new SpinnerNumberModel(50, 0, 100, 1));
        this.jSpinner4.setEnabled(false);
        this.jSpinner4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DropEditor.this.jSpinner4StateChanged(evt);
            }
        });
        this.jButton4.setText("Remove");
        this.jButton4.setEnabled(false);
        this.jButton4.setOpaque(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropEditor.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Add");
        this.jButton3.setOpaque(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DropEditor.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel6.setForeground(new Color(200, 200, 200));
        this.jLabel6.setText("Chance %:");
        GroupLayout customPaintPanel31Layout = new GroupLayout(this.customPaintPanel31);
        this.customPaintPanel31.setLayout(customPaintPanel31Layout);
        customPaintPanel31Layout.setHorizontalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(customPaintPanel31Layout.createSequentialGroup().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jCheckBox1).addComponent(this.jLabel1)).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(customPaintPanel31Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jSpinner1, -2, 75, -2)).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel31Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSpinner3, -2, 75, -2)))).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.jButton1, -2, 72, -2).addGap(18, 18, 18).addComponent(this.jButton2)).addComponent(this.jScrollPane1, -2, 161, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, customPaintPanel31Layout.createSequentialGroup().addComponent(this.jButton3, -2, 72, -2).addGap(18, 18, 18).addComponent(this.jButton4)).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, customPaintPanel31Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSpinner4, -2, 71, -2)).addGroup(GroupLayout.Alignment.LEADING, customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSpinner2, -2, 71, -2).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -2, 161, -2).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        customPaintPanel31Layout.setVerticalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel31Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addGroup(customPaintPanel31Layout.createSequentialGroup().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2))).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jSpinner2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner4, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton3)))).addGap(0, 4, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel7.setFont(new Font("Tahoma", 0, 18));
        this.jLabel7.setForeground(new Color(204, 204, 204));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Drop Editor");
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -2, 18, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel11, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        try {
            int row = this.jList1.getSelectedIndex();
            if (row == -1) {
                this.jSpinner1.setValue(1);
                this.jSpinner3.setValue(50);
                this.jSpinner1.setEnabled(false);
                this.jSpinner3.setEnabled(false);
                this.jButton2.setEnabled(false);
            } else {
                this.jSpinner1.setEnabled(true);
                this.jSpinner3.setEnabled(true);
                this.jButton2.setEnabled(true);
                DropData dd = this.drops.get(row);
                this.jSpinner1.setValue(dd.getAmount());
                this.jSpinner3.setValue(dd.getChance());
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        try {
            int row = this.jList2.getSelectedIndex();
            if (row == -1) {
                this.jSpinner2.setValue(1);
                this.jSpinner4.setValue(50);
                this.jSpinner2.setEnabled(false);
                this.jSpinner4.setEnabled(false);
                this.jButton4.setEnabled(false);
            } else {
                this.jSpinner2.setEnabled(true);
                this.jSpinner4.setEnabled(true);
                this.jButton4.setEnabled(true);
                DropData dd = this.rareDrops.get(row);
                this.jSpinner2.setValue(dd.getAmount());
                this.jSpinner4.setValue(dd.getChance());
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        int row = this.jList1.getSelectedIndex();
        if (row != -1) {
            int data = this.jSpinner1.getValue().hashCode();
            DropData dd = this.drops.get(row);
            dd.setAmount(data);
        }
    }

    private void jSpinner3StateChanged(ChangeEvent evt) {
        int row = this.jList1.getSelectedIndex();
        if (row != -1) {
            int data = this.jSpinner3.getValue().hashCode();
            DropData dd = this.drops.get(row);
            dd.setChance(data);
        }
    }

    private void jSpinner2StateChanged(ChangeEvent evt) {
        int row = this.jList2.getSelectedIndex();
        if (row != -1) {
            int data = this.jSpinner2.getValue().hashCode();
            DropData dd = this.rareDrops.get(row);
            dd.setAmount(data);
        }
    }

    private void jSpinner4StateChanged(ChangeEvent evt) {
        int row = this.jList2.getSelectedIndex();
        if (row != -1) {
            int data = this.jSpinner4.getValue().hashCode();
            DropData dd = this.rareDrops.get(row);
            dd.setChance(data);
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int row = this.jList2.getSelectedIndex();
        if (row != -1) {
            this.rareDrops.remove(row);
            this.refreshLists();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int row = this.jList1.getSelectedIndex();
        if (row != -1) {
            this.drops.remove(row);
            this.refreshLists();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        BlockItemHolder bih;
        ItemChooser tc = ItemChooser.getItemChooser();
        tc.setVisible(this.mod);
        if (tc.getReturnState() == 1 && (bih = tc.getSelectedObject()) != null) {
            DropData dd = new DropData(bih);
            this.rareDrops.add(dd);
            this.refreshLists();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        BlockItemHolder bih;
        ItemChooser tc = ItemChooser.getItemChooser();
        tc.setVisible(this.mod);
        if (tc.getReturnState() == 1 && (bih = tc.getSelectedObject()) != null) {
            DropData dd = new DropData(bih);
            this.drops.add(dd);
            this.refreshLists();
        }
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.saveBase.setDropItself(this.jCheckBox1.isSelected());
    }

    private void customButton1MouseClicked(MouseEvent evt) {
        this.doClose(1);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
        this.saveBase.setDrops(this.drops);
        this.saveBase.setRareDrops(this.rareDrops);
    }

    private void refreshLists() {
        this.jList1.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return DropEditor.this.drops.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((DropData)DropEditor.this.drops.get(i)).toString();
            }
        });
        if (!this.drops.isEmpty()) {
            this.jList1.setSelectedIndex(0);
        }
        this.jList2.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return DropEditor.this.rareDrops.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((DropData)DropEditor.this.rareDrops.get(i)).toString();
            }
        });
        if (!this.rareDrops.isEmpty()) {
            this.jList2.setSelectedIndex(0);
        }
    }
}

