/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.SwingUtils;
import net.modmaker.Utils.Textures;

public class FileChooser
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public static final FileFilter pngFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "PNG (*.png)";
        }
    };
    public static final FileFilter BitmapFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".bmp") || f.getName().endsWith(".dip");
        }

        @Override
        public String getDescription() {
            return "Bitmapbestanden (*.bmp;*.dip)";
        }
    };
    public static final FileFilter jpegFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".jpe") || f.getName().endsWith(".jfif");
        }

        @Override
        public String getDescription() {
            return "JPEG (*.jpg;*.jpeg;*.jpe;*.jfif)";
        }
    };
    public static final FileFilter gifFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".gif");
        }

        @Override
        public String getDescription() {
            return "GIF (*.gif)";
        }
    };
    public static final FileFilter allImagesFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".jpe") || f.getName().endsWith(".jfif") || f.getName().endsWith(".png") || f.getName().endsWith(".bmp") || f.getName().endsWith(".dip") || f.getName().endsWith(".gif");
        }

        @Override
        public String getDescription() {
            return "All imagefiles";
        }
    };
    public static final FileFilter[] allFilters = new FileFilter[]{BitmapFilter, pngFilter, jpegFilter, gifFilter, allImagesFilter};
    public static final FileFilter jarFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jar");
        }

        @Override
        public String getDescription() {
            return "JAR (*.jar)";
        }
    };
    public static int OPEN_DIALOG = 0;
    public static int SAVE_DIALOG = 1;
    public static int CUSTOM_DIALOG = 2;
    private static int width;
    private static int height;
    private Thread resize;
    private CustomButton customButton1;
    private CustomButton customButton2;
    private CustomPaintPanel1 customPaintPanel11;
    private static JFileChooser fc;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextField jTextField1;
    private JTree jTree1;
    private static int returnStatus;

    public FileChooser(int state) {
        super((Frame)Settings.getFrame(), true);
        this.initComponents();
        this.setTree();
        this.jTree1.setCellRenderer(new CustomIconRenderer());
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser.this.doClose(0);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        BasicSplitPaneUI ui = (BasicSplitPaneUI)this.jSplitPane1.getUI();
        ui.getDivider().setBorder(null);
        AbstractButton button = SwingUtils.getDescendantOfType(AbstractButton.class, this, "Icon", UIManager.getIcon("FileChooser.detailsViewIcon"));
        if (button != null) {
            button.doClick();
        }
        if (width == 0 || height == 0) {
            this.jPanel4.setVisible(false);
        }
        fc.setDialogType(state);
        if (state == SAVE_DIALOG) {
            this.customButton2.setText("Save");
            this.customButton2.setIcon(new ImageIcon(Textures.smallSaveMod));
            this.setTitle("Save");
        } else if (state == CUSTOM_DIALOG) {
            this.customButton2.setText("Ok");
            this.customButton2.setIcon(new ImageIcon(Textures.smallOk));
            this.setTitle("");
        }
        this.setIconImage(Textures.Logo);
    }

    public static File showDialog(String dir, int state, int w, int h, FileFilter ff) {
        return FileChooser.showDialog(dir, state, w, h, new FileFilter[]{ff});
    }

    public static File showDialog(String dir, int state, int w, int h) {
        return FileChooser.showDialog(dir, state, w, h, new FileFilter[0]);
    }

    public static File showDialog(String dir, int state) {
        return FileChooser.showDialog(dir, state, 0, 0);
    }

    public static File showDialog(String dir, int state, int w, int h, FileFilter[] ff) {
        try {
            Object button = UIManager.get("Button.background");
            Object panel = UIManager.get("Panel.background");
            Object textfield = UIManager.get("TextField.background");
            Object toolBar = UIManager.get("ToolBar.background");
            Object comboBox = UIManager.get("ComboBox.background");
            Object listFG = UIManager.get("List.selectionForeground");
            Object listBG = UIManager.get("List.selectionBackground");
            UIManager.put("List.selectionForeground", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("List.selectionBackground", new ColorUIResource(184, 207, 229));
            UIManager.put("Button.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("Panel.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("TextField.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("ToolBar.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("ComboBox.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("ToggleButton.background", new ColorUIResource(new Color(100, 100, 100)));
            UIManager.put("FileChooser.noPlacesBar", Boolean.TRUE);
            UIManager.put("SplitPane.background", new ColorUIResource(51, 51, 51));
            width = w;
            height = h;
            FileChooser dialog = new FileChooser(state);
            for (Component comp : fc.getComponents()) {
                FileChooser.Tree(comp, "");
            }
            fc.setCurrentDirectory(new File(dir));
            fc.setFileSelectionMode(2);
            for (FileFilter filter : ff) {
                fc.setFileFilter(filter);
            }
            fc.setBackground(new Color(100, 100, 100));
            dialog.setSize(800, 500);
            dialog.setVisible(true);
            int value = dialog.getReturnStatus();
            if (value == 1 && new File(dir).getPath().equals(Settings.getCurrentDirectory().getPath())) {
                Settings.setCurrentDirectory(fc.getCurrentDirectory());
            }
            UIManager.put("Button.background", button);
            UIManager.put("Panel.background", panel);
            UIManager.put("TextField.background", textfield);
            UIManager.put("ToolBar.background", toolBar);
            UIManager.put("ComboBox.background", comboBox);
            UIManager.put("List.selectionForeground", listFG);
            UIManager.put("List.selectionBackground", listBG);
            UIManager.put("SplitPane.background", new ColorUIResource(111, 111, 111));
            if (value == 1) {
                return fc.getSelectedFile();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
        return null;
    }

    private static void Tree(Component comp, String prefix) {
        block3: {
            block4: {
                block2: {
                    if (!(comp instanceof JPanel)) break block2;
                    JPanel panel = (JPanel)comp;
                    prefix = prefix + "  ";
                    for (Component c : panel.getComponents()) {
                        FileChooser.Tree(c, prefix);
                    }
                    break block3;
                }
                if (!(comp instanceof JComboBox)) break block4;
                JComboBox cb = (JComboBox)comp;
                cb.setBorder(null);
                break block3;
            }
            if (!(comp instanceof JToolBar)) break block3;
            JToolBar tb = (JToolBar)comp;
            prefix = prefix + "  ";
            for (Component c : tb.getComponents()) {
                FileChooser.Tree(c, prefix);
            }
        }
    }

    public static int getReturnStatus() {
        return returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel2 = new JPanel();
        fc = new JFileChooser();
        this.jTextField1 = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.customButton1 = new CustomButton();
        this.customButton2 = new CustomButton();
        this.setTitle("Open");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileChooser.this.closeDialog(evt);
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jSplitPane1.setBackground(new Color(51, 51, 51));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jScrollPane2.setBackground(new Color(100, 100, 100));
        this.jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jTree1.setBackground(new Color(100, 100, 100));
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FileChooser.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jPanel2.setBackground(new Color(100, 100, 100));
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        fc.setBackground(new Color(100, 100, 100));
        fc.setControlButtonsAreShown(false);
        fc.setCurrentDirectory(new File("C:\\Users\\Administrator"));
        fc.setOpaque(true);
        fc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileChooser.this.fcPropertyChange(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 425, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fc, GroupLayout.Alignment.TRAILING, -1, 425, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 411, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(fc, GroupLayout.Alignment.TRAILING, -1, 411, Short.MAX_VALUE)));
        fc.getAccessibleContext().setAccessibleParent(this.jPanel2);
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jTextField1.setBackground(new Color(100, 100, 100));
        this.jTextField1.setForeground(new Color(240, 240, 240));
        this.jTextField1.setHorizontalAlignment(2);
        this.jTextField1.setText(fc.getCurrentDirectory().getPath());
        this.jTextField1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FileChooser.this.jTextField1KeyTyped(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jLabel1.setBackground(new Color(70, 70, 70));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setOpaque(true);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 128, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 128, -2).addGap(0, 0, 0).addComponent(this.jLabel1, -2, 20, -2)));
        this.jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jLabel2.setBackground(new Color(70, 70, 70));
        this.jLabel2.setForeground(new Color(204, 204, 204));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setOpaque(true);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 128, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 128, -2).addGap(0, 0, 0).addComponent(this.jLabel2, -2, 20, -2)));
        this.customPaintPanel11.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customButton1.setIcon(new ImageIcon(Textures.smallCancel));
        this.customButton1.setText("Cancel");
        this.customButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FileChooser.this.customButton1MouseClicked(evt);
            }
        });
        this.customButton2.setIcon(new ImageIcon(Textures.smallOpenMod));
        this.customButton2.setText("Open");
        this.customButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FileChooser.this.customButton2MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton2, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton1, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customButton1, -2, 30, -2).addComponent(this.customButton2, -2, 30, -2)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 618, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel4, -2, -1, -2)))).addContainerGap()).addComponent(this.customPaintPanel11, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)).addComponent(this.jSplitPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customPaintPanel11, -2, -1, -2).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void customButton2MouseClicked(MouseEvent evt) {
        this.doClose(1);
    }

    private void customButton1MouseClicked(MouseEvent evt) {
        this.doClose(0);
    }

    private void jTextField1KeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            File file = new File(this.jTextField1.getText());
            if (file.exists() && file.isDirectory()) {
                fc.setCurrentDirectory(file);
            } else if (!file.exists()) {
                OptionPane.showMessageDialog(this, file.getPath() + "\nDon't exists", "Don't exists", 2);
            } else if (!file.isDirectory()) {
                fc.setCurrentDirectory(file.getParentFile());
                fc.setSelectedFile(file);
            }
        }
    }

    private void fcPropertyChange(PropertyChangeEvent evt) {
        if (this.resize != null) {
            this.resize.stop();
        }
        this.resize = new Thread(new Runnable(){

            @Override
            public void run() {
                File f;
                FileChooser.this.jTextField1.setText(fc.getCurrentDirectory().getPath());
                if (FileChooser.this.jTextField1.getText().equals("::{031E4825-7B94-4DC3-B131-E946B44C8DD5}")) {
                    FileChooser.this.jTextField1.setText("Library");
                }
                if (FileChooser.this.jTextField1.getText().equals("::{20D04FE0-3AEA-1069-A2D8-08002B30309D}")) {
                    FileChooser.this.jTextField1.setText("Computer");
                }
                if ((f = fc.getSelectedFile()) != null) {
                    try {
                        BufferedImage image = ImageIO.read(f);
                        if (image.getWidth() > image.getHeight()) {
                            FileChooser.this.jLabel3.setIcon(new ImageIcon(image.getScaledInstance(128, image.getHeight() * 128 / image.getWidth(), RenderingHints.VALUE_ANTIALIAS_ON.hashCode())));
                        } else {
                            FileChooser.this.jLabel3.setIcon(new ImageIcon(image.getScaledInstance(image.getWidth() * 128 / image.getHeight(), 128, RenderingHints.VALUE_ANTIALIAS_ON.hashCode())));
                        }
                        FileChooser.this.jLabel1.setText("Original: " + image.getWidth() + " x " + image.getHeight());
                        try {
                            FileChooser.this.jLabel4.setIcon(new ImageIcon(image.getScaledInstance(width, height, RenderingHints.VALUE_ANTIALIAS_ON.hashCode()).getScaledInstance(128, 128, RenderingHints.VALUE_ANTIALIAS_OFF.hashCode())));
                            FileChooser.this.jLabel2.setText("Scaled: " + width + " x " + height);
                        }
                        catch (Exception e) {
                            FileChooser.this.jLabel4.setIcon(null);
                            FileChooser.this.jLabel2.setText("");
                        }
                    }
                    catch (Exception e) {
                        FileChooser.this.jLabel3.setIcon(null);
                        FileChooser.this.jLabel1.setText("");
                        FileChooser.this.jLabel4.setIcon(null);
                        FileChooser.this.jLabel2.setText("");
                    }
                }
            }
        });
        this.resize.setName("Resize Image");
        this.resize.start();
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        try {
            if (this.jTree1.getSelectionPath() == null) {
                return;
            }
            Object[] path = this.jTree1.getSelectionPath().getPath();
            File file = new File(path[path.length - 1].toString());
            if (file.exists()) {
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                if (file != null) {
                    fc.setCurrentDirectory(file);
                }
            } else if (path[path.length - 1].toString().equals("Computer")) {
                fc.setCurrentDirectory(FileChooser.getComputerFile());
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void setTree() {
        File[] roots;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        DefaultMutableTreeNode drives = new DefaultMutableTreeNode("Computer");
        DefaultMutableTreeNode lib = new DefaultMutableTreeNode("Libraries");
        for (File f : roots = File.listRoots()) {
            DefaultMutableTreeNode d = new DefaultMutableTreeNode(f);
            drives.add(d);
        }
        lib.add(new DefaultMutableTreeNode(new File(System.getProperty("user.home") + "/Pictures")));
        lib.add(new DefaultMutableTreeNode(new File(System.getProperty("user.home") + "/Documents")));
        lib.add(new DefaultMutableTreeNode(new File(System.getProperty("user.home") + "/Music")));
        lib.add(new DefaultMutableTreeNode(new File(System.getProperty("user.home") + "/Videos")));
        root.add(lib);
        root.add(drives);
        this.jTree1.setModel(new DefaultTreeModel(root));
        for (int a = 0; a < this.jTree1.getRowCount(); ++a) {
            this.jTree1.expandRow(a);
        }
    }

    private static File getComputerFile() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File defaultFile = fsv.getDefaultDirectory();
        while (defaultFile != null) {
            if ((defaultFile = defaultFile.getParentFile()) == null || !"Computer".equalsIgnoreCase(defaultFile.toString())) continue;
            return defaultFile;
        }
        return null;
    }

    static {
        returnStatus = 0;
    }

    private class CustomIconRenderer
    extends DefaultTreeCellRenderer {
        private CustomIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNode[] path = node.getPath();
            File f = new File(path[path.length - 1].toString());
            if (f.exists()) {
                this.setIcon(FileSystemView.getFileSystemView().getSystemIcon(f));
                this.setText(FileSystemView.getFileSystemView().getSystemDisplayName(f));
            } else {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            }
            return this;
        }
    }
}

