/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.CustomPaintPanel3;
import net.modmaker.Gui.CustomPaintPanel4;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.Textures;
import net.modmaker.report.Mail;
import net.modmaker.report.ReportDialog;

public class LogDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private CustomButton cancelButton;
    private CustomButton customButton3;
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel3 customPaintPanel31;
    private CustomPaintPanel4 customPaintPanel41;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;
    private CustomButton okButton;
    private int returnStatus = 0;
    private ModManager mod;
    private String log;

    public LogDialog(String log, boolean exporting, ModManager mod) {
        super((Frame)Settings.getFrame(), true);
        this.getContentPane().setBackground(new Color(51, 51, 51));
        this.initComponents();
        if (!exporting) {
            this.okButton.setText("Ok");
            this.cancelButton.setText("Cancel");
        }
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogDialog.this.doClose(0);
            }
        });
        this.jTextPane1.setText(log);
        this.jScrollPane1.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMaximum());
        this.jScrollPane1.getViewport().setOpaque(false);
        this.log = log;
        this.mod = mod;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
    }

    public void Update(String log) {
        this.jTextPane1.setText(log);
        this.jScrollPane1.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMaximum());
        this.log = log;
    }

    public void Finish() {
        this.okButton.setEnabled(true);
        this.okButton.setText("Oke");
    }

    public int getReturnStatus() {
        UIManager.put("Button.background", new ColorUIResource(new Color(51, 51, 51)));
        return this.returnStatus;
    }

    private void initComponents() {
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel3 = new JLabel();
        this.customPaintPanel31 = new CustomPaintPanel3();
        this.customPaintPanel41 = new CustomPaintPanel4();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.okButton = new CustomButton();
        this.cancelButton = new CustomButton();
        this.customButton3 = new CustomButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Errors Found!");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogDialog.this.closeDialog(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 0, 18));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Errors Found!");
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, 28, Short.MAX_VALUE).addContainerGap()));
        this.customPaintPanel31.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel31.setMaxColor(70);
        this.customPaintPanel31.setMinColor(100);
        this.customPaintPanel41.setBackground(new Color(51, 51, 51));
        this.customPaintPanel41.setAlpha(75);
        this.customPaintPanel41.setOpaque(false);
        this.jScrollPane1.setOpaque(false);
        this.jTextPane1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        GroupLayout customPaintPanel41Layout = new GroupLayout(this.customPaintPanel41);
        this.customPaintPanel41.setLayout(customPaintPanel41Layout);
        customPaintPanel41Layout.setHorizontalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        customPaintPanel41Layout.setVerticalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 255, Short.MAX_VALUE));
        GroupLayout customPaintPanel31Layout = new GroupLayout(this.customPaintPanel31);
        this.customPaintPanel31.setLayout(customPaintPanel31Layout);
        customPaintPanel31Layout.setHorizontalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addComponent(this.customPaintPanel41, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel31Layout.setVerticalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addComponent(this.customPaintPanel41, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.okButton.setIcon(new ImageIcon(Textures.smallOk));
        this.okButton.setText("Abort");
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LogDialog.this.okButtonMouseClicked(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(Textures.smallCancel));
        this.cancelButton.setText("Ignore");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LogDialog.this.cancelButtonMouseClicked(evt);
            }
        });
        this.customButton3.setIcon(new ImageIcon(Textures.smallReport));
        this.customButton3.setText("Report This Error");
        this.customButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LogDialog.this.customButton3MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.customButton3, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 241, Short.MAX_VALUE).addComponent(this.okButton, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 30, -2).addComponent(this.customButton3, -2, 30, -2).addComponent(this.okButton, -2, 30, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel11, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void customButton3MouseClicked(MouseEvent evt) {
        this.doClose(0);
        new Thread(){

            @Override
            public void run() {
                try {
                    ReportDialog rd = null;
                    if (LogDialog.this.mod != null) {
                        LogDialog.this.mod;
                        ModManager.Save();
                        SaveManager.saveMod(LogDialog.this.mod);
                        rd = new ReportDialog(LogDialog.this.mod);
                    } else {
                        rd = new ReportDialog(null);
                    }
                    rd.setVisible(true);
                    if (rd.getReturnStatus() == 1) {
                        String l = LogDialog.this.log;
                        String desc = "";
                        desc = LogDialog.this.mod != null ? "Exporting Report for mod: " + ((LogDialog)LogDialog.this).mod.getMod().name + "\n\nDesciption: " + rd.getDiscription() + "\n\n" + "log:" + l : "Exporting Report\n\nDesciption: " + rd.getDiscription() + "\n\n" + "log:" + l;
                        String mail = rd.getEmailAddress();
                        if (LogDialog.this.mod != null) {
                            File att = ((LogDialog)LogDialog.this).mod.getMod().saveFile;
                            Mail.mail(mail, "[REPORT] " + mail, desc, att);
                        } else {
                            Mail.mail(mail, "[REPORT] " + mail, desc);
                        }
                    }
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
        }.start();
    }

    private void cancelButtonMouseClicked(MouseEvent evt) {
        this.doClose(1);
    }

    private void okButtonMouseClicked(MouseEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LogDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LogDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LogDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LogDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        Textures.Load();
        new LogDialog("noting\nlolz", true, null).setVisible(true);
    }
}

