/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;

public class PlayerTextureChooser
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private boolean type;
    public BufferedImage image;
    private JButton cancelButton;
    private JButton jButton1;
    private JLabel jLabel1;
    private JButton okButton;
    private int returnStatus = 0;

    public PlayerTextureChooser(Frame parent, boolean modal, boolean type, BufferedImage in) {
        super(parent, modal);
        this.type = type;
        this.initComponents();
        this.getContentPane().setBackground(new Color(51, 51, 51));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerTextureChooser.this.doClose(0);
            }
        });
        BufferedImage texture = in == null ? new BufferedImage(320, 160, 2) : Textures.Resize(320, 160, in);
        Graphics2D g = texture.createGraphics();
        g.setColor(Color.black);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (type) {
            this.jLabel1.setText("The Texture for the Legs");
            g.drawLine(0, 80, 200, 80);
            g.drawLine(200, 80, 200, 160);
            g.drawString("Legs", 10, 70);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.drawLine(0, 80, 160, 80);
            g.drawLine(160, 0, 160, 80);
            g.drawLine(80, 80, 80, 160);
            g.drawLine(80, 80, 280, 80);
            g.drawLine(280, 80, 280, 160);
            g.drawLine(0, 120, 80, 120);
            g.drawLine(0, 120, 0, 160);
            g.drawLine(0, 159, 280, 159);
            g.drawLine(0, 0, 0, 80);
            g.drawLine(0, 0, 160, 0);
            g.drawString("Helmet", 170, 20);
            g.drawString("Body", 240, 75);
            g.drawString("Boots", 10, 115);
        }
        g.dispose();
        this.jButton1.setIcon(new ImageIcon(Textures.Resize(320, 160, texture)));
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PlayerTextureChooser.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setOpaque(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerTextureChooser.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setOpaque(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerTextureChooser.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerTextureChooser.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("The Texture for the helm, plate body and boots");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, 330, -2).addComponent(this.jLabel1)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".png") || file.getName().endsWith(".gif") || file.getName().endsWith(".jpg, jpeg") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "png,jpeg,gif";
            }
        };
        File f = FileChooser.showDialog(Settings.getCurrentDirectory().getPath(), FileChooser.OPEN_DIALOG, 64, 32, new FileFilter[]{ff});
        if (f != null) {
            try {
                this.image = Textures.Resize(64, 32, ImageIO.read(f));
                BufferedImage texture = Textures.Resize(320, 160, this.image);
                Graphics2D g = texture.createGraphics();
                g.setColor(Color.black);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.type) {
                    g.drawLine(0, 80, 200, 80);
                    g.drawLine(200, 80, 200, 160);
                    g.drawString("Legs", 10, 70);
                } else {
                    g.drawLine(0, 80, 160, 80);
                    g.drawLine(160, 0, 160, 80);
                    g.drawLine(80, 80, 80, 160);
                    g.drawLine(80, 80, 280, 80);
                    g.drawLine(280, 80, 280, 160);
                    g.drawLine(0, 120, 80, 120);
                    g.drawLine(0, 120, 0, 160);
                    g.drawLine(0, 159, 280, 159);
                    g.drawLine(0, 0, 0, 80);
                    g.drawLine(0, 0, 160, 0);
                    g.drawString("Helmet", 170, 20);
                    g.drawString("Body", 240, 75);
                    g.drawString("Boots", 10, 115);
                }
                g.dispose();
                this.jButton1.setIcon(new ImageIcon(Textures.Resize(320, 160, texture)));
            }
            catch (IOException ex) {
                Console.Err(ex);
            }
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PlayerTextureChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PlayerTextureChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PlayerTextureChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PlayerTextureChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerTextureChooser dialog = new PlayerTextureChooser((Frame)new JFrame(), true, false, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

