/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.Dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.Settings;
import net.modmaker.Main;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.events.Listeners.PluginChangeListener;
import net.modmaker.events.PluginChangeEvent;
import net.modmaker.events.Priority;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginManager;

public class PluginDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JTable jTable3;
    private PluginDialog dialog = this;
    private int returnStatus = 0;
    private boolean isUpdating = false;
    private boolean isUpdated = false;

    public PluginDialog() {
        this(0);
    }

    public PluginDialog(int tab) {
        super((Frame)Settings.getFrame(), true);
        this.initComponents();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginDialog.this.doClose(0);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.refreshTable();
        this.refreshTable2();
        this.setInstalledPlugins();
        this.jTabbedPane1.setSelectedIndex(tab);
        PluginManager.addPluginChangeListener(new PluginChangeListener(Priority.NORMAL){

            @Override
            public void onPluginChange(PluginChangeEvent event) {
                PluginDialog.this.setInstalledPlugins();
            }
        });
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable3 = new JTable();
        this.jLabel2 = new JLabel();
        this.jButton4 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.cancelButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jTable3.setAutoCreateRowSorter(true);
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Plugin", "Version", "State", "Progress"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable3.setRowHeight(25);
        this.jScrollPane3.setViewportView(this.jTable3);
        this.jLabel2.setText("No new plugins");
        this.jButton4.setText("Refresh");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton4ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("No Updates");
        this.jScrollPane2.setOpaque(false);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{"Block", "1.0", "Normal", "Update"}, {"Item", "1.2", "Downloading", "Update"}, {"Tool", "1.3", "Failed", "Update"}, {"Armor", "0.5", "Done", "Update"}}, new String[]{"Plugin", "Version", "State", "Update"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setOpaque(false);
        this.jTable1.setRowHeight(25);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButton1.setText("Refresh");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addComponent(this.jScrollPane2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 283, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton4))).addContainerGap()).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 283, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        this.setDefaultCloseOperation(0);
        this.setTitle("Plugin Manager");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PluginDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelButton.setText("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jTable2.setAutoCreateRowSorter(true);
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Plugin", "Version"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable2);
        this.jButton2.setText("Add Plugin");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Remove Plugin");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 343, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 312, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Installed", this.jPanel3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cancelButton)).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            Thread checkUpdates = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PluginDialog.this.jTable1.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jButton1.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jLabel1.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jPanel1.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jButton1.setEnabled(false);
                        if (Main.checkForUpdates()) {
                            PluginDialog.this.refreshTable();
                        }
                        PluginDialog.this.jButton1.setEnabled(true);
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    PluginDialog.this.jTable1.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jButton1.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jLabel1.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jPanel1.setCursor(Cursor.getPredefinedCursor(0));
                    ThreadManager.removeThread("Check For Updates");
                }
            });
            ThreadManager.addThread(checkUpdates, "Check For Updates");
            checkUpdates.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            int result;
            if (this.jTable2.getSelectedRow() != -1 && (result = OptionPane.showConfirmDialog(this, "Are you sure you want to remove this plugin?", "Remove Plugin", 0)) == 0) {
                Plugin p = PluginManager.getPlugins().get(this.jTable2.getSelectedRow());
                PluginManager.DisablePlugin(p.getName());
                this.setInstalledPlugins();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            File plugin = FileChooser.showDialog(Settings.getRoot() + "/plugins", FileChooser.OPEN_DIALOG, 0, 0, FileChooser.jarFilter);
            if (plugin != null) {
                PluginManager.EnablePlugin(plugin);
                this.setInstalledPlugins();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose(0);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        try {
            Thread checkAvailable = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PluginDialog.this.jTable3.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jButton4.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jLabel2.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jPanel2.setCursor(Cursor.getPredefinedCursor(3));
                        PluginDialog.this.jButton4.setEnabled(false);
                        if (Main.checkForUpdates()) {
                            PluginDialog.this.refreshTable2();
                        }
                        PluginDialog.this.jButton4.setEnabled(true);
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    PluginDialog.this.jTable3.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jButton4.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jLabel2.setCursor(Cursor.getPredefinedCursor(0));
                    PluginDialog.this.jPanel2.setCursor(Cursor.getPredefinedCursor(0));
                    ThreadManager.removeThread("Check new Plugins");
                }
            });
            ThreadManager.addThread(checkAvailable, "Check For new Plugins");
            checkAvailable.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void doClose(int retStatus) {
        int result;
        boolean restart = false;
        if (!this.isUpdating && this.isUpdated && (result = OptionPane.showConfirmDialog(this, "You must restart the editor to make the changes have effect", "Restart", 1)) == 0) {
            restart = true;
        }
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
        if (restart) {
            Main.onExit(true);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PluginDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PluginDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PluginDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PluginDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginDialog dialog = new PluginDialog(2);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void setInstalledPlugins() {
        Object[][] obj = new Object[PluginManager.getPlugins().size()][];
        for (int a = 0; a < obj.length; ++a) {
            Plugin p = PluginManager.getPlugins().get(a);
            obj[a] = new Object[]{p.getName(), p.getAuthor(), p.getVersion()};
        }
        this.jTable2.setModel(new DefaultTableModel(obj, new String[]{"Plugin", "Author", "Version"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
    }

    private void refreshTable() {
        Object[][] obj = new Object[PluginManager.getUpdates().size()][];
        if (obj.length != 0) {
            this.jLabel1.setText("Updates (" + obj.length + ")");
        } else {
            this.jLabel1.setText("No Updates");
        }
        for (int a = 0; a < obj.length; ++a) {
            PluginManager.UpdateData ud = PluginManager.getUpdates().get(a);
            obj[a] = new Object[]{ud.getName(), ud.getPlugin().getAuthor(), ud.getNewVersion(), ud.getStateAsString(), "Progress"};
        }
        this.jTable1.setModel(new DefaultTableModel(obj, new String[]{"Plugin", "Author", "Version", "Status", "Progress"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.getColumn("Progress").setCellRenderer(new ButtonRenderer(PluginManager.getUpdates(), true, this.jTable1));
    }

    private void refreshTable2() {
        Object[][] obj = new Object[PluginManager.getAvailable().size()][];
        if (obj.length != 0) {
            this.jLabel2.setText("Available (" + obj.length + ")");
        } else {
            this.jLabel2.setText("No Available");
        }
        for (int a = 0; a < obj.length; ++a) {
            PluginManager.UpdateData ud = PluginManager.getAvailable().get(a);
            obj[a] = new Object[]{ud.getName(), ud.getNewVersion(), ud.getStateAsString(), "Progress"};
        }
        this.jTable3.setModel(new DefaultTableModel(obj, new String[]{"Plugin", "Version", "Status", "Progress"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable3.getColumn("Progress").setCellRenderer(new ButtonRenderer(PluginManager.getAvailable(), false, this.jTable3));
    }

    private class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        private ArrayList<PluginManager.UpdateData> u;
        private final boolean fu;

        private void UpdateState() {
            boolean updating = false;
            for (PluginManager.UpdateData ud : this.u) {
                if (ud.getState() != 1) continue;
                updating = true;
            }
            if (!updating) {
                PluginDialog.this.jButton1.setEnabled(!updating);
                PluginDialog.this.cancelButton.setEnabled(!updating);
                PluginDialog.this.isUpdating = false;
            }
            PluginDialog.this.refreshTable();
        }

        public ButtonRenderer(ArrayList<PluginManager.UpdateData> ud, boolean forUpdating, final JTable table) {
            this.fu = forUpdating;
            this.setOpaque(true);
            this.u = ud;
            if (table.getMouseListeners().length > 2) {
                table.removeMouseListener(table.getMouseListeners()[2]);
            }
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        PluginManager.UpdateData data;
                        TableColumnModel model = table.getColumnModel();
                        if ((model.getColumnIndexAtX(e.getX()) == 3 || model.getColumnIndexAtX(e.getX()) == 4) && (data = (PluginManager.UpdateData)ButtonRenderer.this.u.get(table.getSelectedRow())).getState() == 0) {
                            data.setState(1);
                            table.repaint();
                            PluginDialog.this.jButton1.setEnabled(false);
                            PluginDialog.this.cancelButton.setEnabled(false);
                            PluginDialog.this.isUpdating = true;
                            data.addValueChangedListener(new PluginManager.ValueChangeListener(){

                                @Override
                                public void onValueChange(int i) {
                                    table.repaint();
                                }
                            });
                            Thread update = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (ButtonRenderer.this.fu) {
                                            PluginManager.UpdatePlugin(data);
                                        } else {
                                            PluginManager.DownloadPlugin(data);
                                        }
                                    }
                                    catch (Exception e) {
                                        Console.Err(e);
                                        data.setProgress(0);
                                        data.setState(2);
                                        OptionPane.showMessageDialog(PluginDialog.this.dialog, "Updating Failed: " + data.getName(), "Updating Failed!", 2);
                                    }
                                    data.setState(3);
                                    ButtonRenderer.this.UpdateState();
                                    table.repaint();
                                }
                            });
                            ThreadManager.addThread(update, "Update Plugin " + data.getName());
                            update.start();
                        }
                    }
                    catch (Exception ee) {
                        Console.Err(ee);
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (this.fu) {
                this.setText("Download");
            } else {
                this.setText("Update");
            }
            if (this.u.get(row).getState() != 0) {
                return this.u.get(row).getProgressBar();
            }
            return this;
        }
    }
}

