/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.EventDialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.CustomPaintPanel3;
import net.modmaker.Gui.CustomPaintPanel4;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.EventDialogs.NewActionChooser;
import net.modmaker.IO.Settings;
import net.modmaker.MinecraftEvents.ActionBase;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Utils.Textures;

public class EventEditor
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final ArrayList<EventBase> events;
    private CustomButton customButton2;
    private CustomButton customButton3;
    private CustomButton customButton4;
    private CustomButton customButton5;
    private CustomButton customButton6;
    private CustomButton customButton7;
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel3 customPaintPanel31;
    private CustomPaintPanel4 customPaintPanel41;
    private CustomPaintPanel4 customPaintPanel42;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JList jList2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private int returnStatus = 0;

    public EventEditor(ArrayList<EventBase> e) {
        super((Frame)Settings.getFrame(), true);
        this.initComponents();
        this.events = e;
        if (e == null) {
            return;
        }
        this.jList1.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return EventEditor.this.events.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((EventBase)EventEditor.this.events.get(i)).getName();
            }
        });
        this.jList1.setCellRenderer(new CustomCellRenderer());
        this.jList2.setCellRenderer(new CustomCellRenderer());
        if (!this.events.isEmpty()) {
            this.jList1.setSelectedIndex(0);
        }
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventEditor.this.doClose(0);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.jScrollPane1.getViewport().setOpaque(false);
        this.jScrollPane2.getViewport().setOpaque(false);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.customButton2 = new CustomButton();
        this.customPaintPanel31 = new CustomPaintPanel3();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.customButton3 = new CustomButton();
        this.customButton4 = new CustomButton();
        this.customButton5 = new CustomButton();
        this.customButton6 = new CustomButton();
        this.customButton7 = new CustomButton();
        this.customPaintPanel41 = new CustomPaintPanel4();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.customPaintPanel42 = new CustomPaintPanel4();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Event Editor");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EventEditor.this.closeDialog(evt);
            }
        });
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.customButton2.setIcon(new ImageIcon(Textures.smallOk));
        this.customButton2.setText("Ok");
        this.customButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton2MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton2, -2, 100, -2).addContainerGap()));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customButton2, -2, 30, -2).addContainerGap()));
        this.customPaintPanel31.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.customPaintPanel31.setMaxColor(70);
        this.customPaintPanel31.setMinColor(100);
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Events");
        this.jLabel2.setForeground(new Color(204, 204, 204));
        this.jLabel2.setText("Actions");
        this.customButton3.setText("Move Up");
        this.customButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton3MouseClicked(evt);
            }
        });
        this.customButton4.setText("Move Down");
        this.customButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton4MouseClicked(evt);
            }
        });
        this.customButton5.setText("Edit");
        this.customButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton5MouseClicked(evt);
            }
        });
        this.customButton6.setIcon(new ImageIcon(Textures.smallAddFile));
        this.customButton6.setText("New");
        this.customButton6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton6MouseClicked(evt);
            }
        });
        this.customButton7.setIcon(new ImageIcon(Textures.smallCancel));
        this.customButton7.setText("Delete");
        this.customButton7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.customButton7MouseClicked(evt);
            }
        });
        this.customPaintPanel41.setBackground(new Color(51, 51, 51));
        this.customPaintPanel41.setAlpha(75);
        this.customPaintPanel41.setOpaque(false);
        this.jScrollPane1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jScrollPane1.setOpaque(false);
        this.jList1.setBackground(new Color(100, 100, 100));
        this.jList1.setSelectionMode(0);
        this.jList1.setOpaque(false);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EventEditor.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout customPaintPanel41Layout = new GroupLayout(this.customPaintPanel41);
        this.customPaintPanel41.setLayout(customPaintPanel41Layout);
        customPaintPanel41Layout.setHorizontalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 192, Short.MAX_VALUE));
        customPaintPanel41Layout.setVerticalGroup(customPaintPanel41Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        this.customPaintPanel42.setBackground(new Color(51, 51, 51));
        this.customPaintPanel42.setAlpha(75);
        this.customPaintPanel42.setOpaque(false);
        this.jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setOpaque(false);
        this.jList2.setBackground(new Color(100, 100, 100));
        this.jList2.setSelectionMode(0);
        this.jList2.setOpaque(false);
        this.jList2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EventEditor.this.jList2MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        GroupLayout customPaintPanel42Layout = new GroupLayout(this.customPaintPanel42);
        this.customPaintPanel42.setLayout(customPaintPanel42Layout);
        customPaintPanel42Layout.setHorizontalGroup(customPaintPanel42Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 289, Short.MAX_VALUE));
        customPaintPanel42Layout.setVerticalGroup(customPaintPanel42Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2));
        GroupLayout customPaintPanel31Layout = new GroupLayout(this.customPaintPanel31);
        this.customPaintPanel31.setLayout(customPaintPanel31Layout);
        customPaintPanel31Layout.setHorizontalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.customPaintPanel41, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.customPaintPanel42, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.customButton3, -1, -1, Short.MAX_VALUE).addComponent(this.customButton4, -1, 130, Short.MAX_VALUE).addComponent(this.customButton5, -1, -1, Short.MAX_VALUE).addComponent(this.customButton6, -1, -1, Short.MAX_VALUE).addComponent(this.customButton7, -1, -1, Short.MAX_VALUE))).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        customPaintPanel31Layout.setVerticalGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel31Layout.createSequentialGroup().addContainerGap().addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customPaintPanel31Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel41, -1, -1, Short.MAX_VALUE).addGroup(customPaintPanel31Layout.createSequentialGroup().addComponent(this.customButton3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton4, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton5, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton6, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton7, -2, 30, -2).addGap(0, 251, Short.MAX_VALUE)).addComponent(this.customPaintPanel42, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jLabel3.setFont(new Font("Tahoma", 0, 18));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Event Editor");
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, 28, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel11, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel31, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.customPaintPanel31, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        try {
            int row = this.jList1.getSelectedIndex();
            if (row != -1 && row < this.events.size()) {
                final EventBase event = this.events.get(row);
                this.jList2.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        if (event.getReturnStatement() == null) {
                            return event.getActionSize();
                        }
                        return event.getActionSize() + 1;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                        return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                    }
                });
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jList2MouseClicked(MouseEvent evt) {
        try {
            if (evt.getClickCount() == 2) {
                this.customButton5MouseClicked(null);
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void customButton2MouseClicked(MouseEvent evt) {
        this.doClose(1);
    }

    private void customButton3MouseClicked(MouseEvent evt) {
        int row = this.jList1.getSelectedIndex();
        if (row != -1 && row < this.events.size()) {
            final EventBase event = this.events.get(row);
            row = this.jList2.getSelectedIndex();
            if (row > 0 && row < event.getActionSize()) {
                ActionBase action = event.getAction(row);
                event.removeAction(row);
                event.addAction(action, row - 1);
                this.jList2.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        if (event.getReturnStatement() == null) {
                            return event.getActionSize();
                        }
                        return event.getActionSize() + 1;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                        return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                    }
                });
                this.jList2.setSelectedIndex(row - 1);
            }
        }
    }

    private void customButton4MouseClicked(MouseEvent evt) {
        int row = this.jList1.getSelectedIndex();
        if (row != -1 && row < this.events.size()) {
            final EventBase event = this.events.get(row);
            row = this.jList2.getSelectedIndex();
            if (row > -1 && row < event.getActionSize() - 1) {
                ActionBase action = event.getAction(row);
                event.removeAction(row);
                event.addAction(action, row + 1);
                this.jList2.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        if (event.getReturnStatement() == null) {
                            return event.getActionSize();
                        }
                        return event.getActionSize() + 1;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                        return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                    }
                });
                this.jList2.setSelectedIndex(row + 1);
            }
        }
    }

    private void customButton5MouseClicked(MouseEvent evt) {
        try {
            int row = this.jList1.getSelectedIndex();
            if (row != -1 && row < this.events.size()) {
                final EventBase event = this.events.get(row);
                row = this.jList2.getSelectedIndex();
                if (row != -1 && row < event.getActionSize() + 1) {
                    ActionBase action = row == event.getActionSize() ? event.getReturnStatement() : event.getAction(row);
                    action.onEdit(this);
                    this.jList2.setModel(new AbstractListModel(){

                        @Override
                        public int getSize() {
                            if (event.getReturnStatement() == null) {
                                return event.getActionSize();
                            }
                            return event.getActionSize() + 1;
                        }

                        @Override
                        public Object getElementAt(int i) {
                            ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                            return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void customButton6MouseClicked(MouseEvent evt) {
        try {
            int row = this.jList1.getSelectedIndex();
            if (row != -1 && row < this.events.size()) {
                final EventBase event = this.events.get(row);
                NewActionChooser nac = new NewActionChooser((Window)this, ActionBase.getActions(), event);
                nac.setVisible(true);
                if (nac.getReturnStatus() == 1 && nac.getSelectedAction() != null) {
                    event.addAction(nac.getSelectedAction());
                    this.jList2.setModel(new AbstractListModel(){

                        @Override
                        public int getSize() {
                            if (event.getReturnStatement() == null) {
                                return event.getActionSize();
                            }
                            return event.getActionSize() + 1;
                        }

                        @Override
                        public Object getElementAt(int i) {
                            ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                            return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void customButton7MouseClicked(MouseEvent evt) {
        int ret;
        int row = this.jList1.getSelectedIndex();
        if (row != -1 && row < this.events.size() && (ret = OptionPane.showConfirmDialog(this, "Are you sure you want to delete this action?", "Delete action!", 0, 2)) == 0) {
            final EventBase event = this.events.get(row);
            row = this.jList2.getSelectedIndex();
            if (row > -1 && row < event.getActionSize()) {
                event.removeAction(row);
                this.jList2.setModel(new AbstractListModel(){

                    @Override
                    public int getSize() {
                        if (event.getReturnStatement() == null) {
                            return event.getActionSize();
                        }
                        return event.getActionSize() + 1;
                    }

                    @Override
                    public Object getElementAt(int i) {
                        ActionBase action = i == event.getActionSize() ? event.getReturnStatement() : event.getAction(i);
                        return action.getName() + (action.getDescription().equals("") ? "" : ": " + action.getDescription());
                    }
                });
            }
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EventEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EventEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EventEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EventEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventEditor dialog = new EventEditor(EventBase.getBlockEvents());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class CustomCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CustomCellRenderer() {
            this.setForeground(new Color(204, 204, 204));
            this.setBackground(new Color(150, 150, 150));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(String.valueOf(value));
            this.setOpaque(isSelected);
            if (isSelected) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(new Color(204, 204, 204));
            }
            return this;
        }
    }
}

