/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui.EventDialogs;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.modmaker.Console.Console;
import net.modmaker.MinecraftEvents.Actions.ActionScript;

public class ScriptEditor
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private ActionScript script;
    private JButton cancelButton;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea3;
    private JButton okButton;
    private int returnStatus = 0;

    public ScriptEditor(Window parent, ActionScript script) {
        super(parent);
        this.setModal(true);
        this.script = script;
        this.initComponents();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditor.this.doClose(0);
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.jLabel6.setText("<html>" + script.getEvent().getParameters() + "</html>");
        try {
            if (script.getEvent().getDocUrl() == null) {
                this.jButton1.setEnabled(false);
            }
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jSeparator2 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jLabel7 = new JLabel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Script Editor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScriptEditor.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Event: " + this.script.getEvent().getName());
        this.jLabel2.setText("Imports:");
        this.jLabel3.setText("(* = required)");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Monospaced", 0, 11));
        this.jTextArea1.setRows(5);
        this.jTextArea1.setTabSize(4);
        this.jTextArea1.setText(this.script.getImports());
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel5.setText("* Inside the Event Methode:");
        this.jLabel6.setFont(new Font("Monospaced", 0, 11));
        this.jLabel6.setText("public void onBlockEvent(){");
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setFont(new Font("Monospaced", 0, 11));
        this.jTextArea3.setRows(5);
        this.jTextArea3.setTabSize(4);
        this.jTextArea3.setText(this.script.getCode());
        this.jScrollPane3.setViewportView(this.jTextArea3);
        this.jLabel7.setFont(new Font("Monospaced", 0, 11));
        this.jLabel7.setHorizontalAlignment(11);
        this.jLabel7.setText("}");
        this.jButton1.setText("Show Javadocs");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptEditor.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel5)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.jScrollPane3, -1, 767, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)))).addGroup(layout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -2, 31, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 138, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.jLabel3).addComponent(this.jButton1)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(this.script.getEvent().getDocUrl());
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public String getImports() {
        return this.jTextArea1.getText();
    }

    public String getCode() {
        return this.jTextArea3.getText();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ScriptEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ScriptEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ScriptEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ScriptEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptEditor dialog = new ScriptEditor((Window)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

