/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.MenuBarUI;
import net.modmaker.Console.Console;
import net.modmaker.Export.Export;
import net.modmaker.Gui.Dialogs.About;
import net.modmaker.Gui.Dialogs.Backups;
import net.modmaker.Gui.Dialogs.InstallMCP;
import net.modmaker.Gui.Dialogs.LogDialog;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.Dialogs.Options;
import net.modmaker.Gui.Dialogs.PluginDialog;
import net.modmaker.Gui.MainPanel;
import net.modmaker.Gui.Tree;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.IO.SetupManager;
import net.modmaker.Main;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.McpScripts;
import net.modmaker.Utils.Textures;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.Utils.Unique;
import net.modmaker.Utils.Urls;
import net.modmaker.backup.BackupManager;
import net.modmaker.plugin.SaveBase;
import net.modmaker.report.Mail;
import net.modmaker.report.ReportDialog;
import net.modmaker.textureeditor.TextureEditor;

public class Frame
extends JFrame {
    private JMenuBar jMenuBar1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem21;
    private JMenuItem jMenuItem22;
    private JMenuItem jMenuItem23;
    private JMenuItem jMenuItem24;
    private JMenuItem jMenuItem25;
    private JMenuItem jMenuItem26;
    private JMenuItem jMenuItem27;
    private JMenuItem jMenuItem28;
    private JMenuItem jMenuItem29;
    private JMenuItem jMenuItem30;
    private JMenuItem jMenuItem31;

    public Frame() {
        this.initComponents();
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.customInit();
        try {
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            list.add(Textures.Logo16);
            list.add(Textures.Logo32);
            this.setIconImages(list);
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Deathly's Mod Editor " + Settings.getVersion() + (Settings.getDebug() ? " [DEV] " : " [Pre Release]"));
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    public void setBackupMenu(JMenu menu) {
        this.jMenu2.remove(4);
        this.jMenu2.add((Component)menu, 4);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Frame().setVisible(true);
            }
        });
    }

    private void customInit() {
        this.setContentPane(new MainPanel());
        this.jMenu1 = new JMenu("File");
        this.jMenu2 = new JMenu("Tools");
        this.jMenu3 = new JMenu("Help");
        this.jMenuItem1 = new JMenuItem("New Mod"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem2 = new JMenuItem("Open"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem3 = new JMenuItem("Save"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenu4 = new JMenu("Export ..."){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem4 = new JMenuItem("Install Mod"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem5 = new JMenuItem("Exit"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem6 = new JMenuItem("Test Client"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem7 = new JMenuItem("Test Server"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem8 = new JMenuItem("Check for errors"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenu5 = new JMenu("MCP Scripts"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 3, 51 + i + this.getHeight() * 3, 51 + i + this.getHeight() * 3));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem9 = new JMenuItem("Backups"){

            @Override
            public void paintComponent(Graphics g) {
                int i;
                for (i = 0; i < this.getHeight() / 2; ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 4, 51 + i + this.getHeight() * 4, 51 + i + this.getHeight() * 4));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                for (i = this.getHeight() / 2; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 5 - i, 51 + this.getHeight() * 5 - i, 51 + this.getHeight() * 5 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem10 = new JMenuItem("Instal MCP"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 4 - i, 51 + this.getHeight() * 4 - i, 51 + this.getHeight() * 4 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem11 = new JMenuItem("Plugins"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem12 = new JMenuItem("Options"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem13 = new JMenuItem("Texture Editor"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem14 = new JMenuItem("About"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem15 = new JMenuItem("Planet Minecraft"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem16 = new JMenuItem("Minecraft Forum"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem17 = new JMenuItem("Report Error"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem18 = new JMenuItem("Source Code"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem19 = new JMenuItem("Textures"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem20 = new JMenuItem("Final Mod"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem21 = new JMenuItem("Executable Installation"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem22 = new JMenuItem("Cleanup"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem23 = new JMenuItem("Decompile"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem24 = new JMenuItem("Get Changed Src"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2, 51 + i + this.getHeight() * 2));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem25 = new JMenuItem("Reformat"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 3, 51 + i + this.getHeight() * 3, 51 + i + this.getHeight() * 3));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem26 = new JMenuItem("Start Client"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight() * 4, 51 + i + this.getHeight() * 4, 51 + i + this.getHeight() * 4));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem27 = new JMenuItem("Start Server"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 5 - i, 51 + this.getHeight() * 5 - i, 51 + this.getHeight() * 5 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem28 = new JMenuItem("Update Ids"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 4 - i, 51 + this.getHeight() * 4 - i, 51 + this.getHeight() * 4 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem29 = new JMenuItem("Update MCP"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i, 51 + this.getHeight() * 3 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem30 = new JMenuItem("Update MD5"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem31 = new JMenuItem("Update Names"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuBar1.setUI(new MenuBarUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                for (int i = Frame.this.jMenuBar1.getHeight() - 1; i >= 0; --i) {
                    int v = i * 4;
                    g.setColor(new Color(100 + v, 100 + v, 100 + v));
                    g.fillRect(0, Frame.this.jMenuBar1.getHeight() - i - 1, Frame.this.jMenuBar1.getWidth(), 1);
                }
            }
        });
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jMenu4);
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu2.add(this.jMenuItem6);
        this.jMenu2.add(this.jMenuItem7);
        this.jMenu2.add(this.jMenuItem8);
        this.jMenu2.add(this.jMenu5);
        this.jMenu2.add(this.jMenuItem9);
        this.jMenu2.add(this.jMenuItem10);
        this.jMenu2.add(this.jMenuItem11);
        this.jMenu2.add(this.jMenuItem12);
        this.jMenu3.add(this.jMenuItem14);
        this.jMenu3.add(this.jMenuItem15);
        this.jMenu3.add(this.jMenuItem16);
        this.jMenu3.add(this.jMenuItem17);
        this.jMenu4.add(this.jMenuItem18);
        this.jMenu4.add(this.jMenuItem19);
        this.jMenu4.add(this.jMenuItem20);
        this.jMenu4.add(this.jMenuItem21);
        this.jMenu5.add(this.jMenuItem22);
        this.jMenu5.add(this.jMenuItem23);
        this.jMenu5.add(this.jMenuItem24);
        this.jMenu5.add(this.jMenuItem25);
        this.jMenu5.add(this.jMenuItem26);
        this.jMenu5.add(this.jMenuItem27);
        this.jMenu5.add(this.jMenuItem28);
        this.jMenu5.add(this.jMenuItem29);
        this.jMenu5.add(this.jMenuItem30);
        this.jMenu5.add(this.jMenuItem31);
        for (Component comp : this.jMenu1.getMenuComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        for (Component comp : this.jMenu2.getMenuComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        for (Component comp : this.jMenu3.getMenuComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        for (Component comp : this.jMenu4.getMenuComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        for (Component comp : this.jMenu5.getMenuComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jMenuItem1.setIcon(new ImageIcon(Textures.smallNewMod));
        this.jMenuItem2.setIcon(new ImageIcon(Textures.smallOpenMod));
        this.jMenuItem3.setIcon(new ImageIcon(Textures.smallSaveMod));
        this.jMenu4.setIcon(new ImageIcon(Textures.smallExport));
        this.jMenuItem4.setIcon(new ImageIcon(Textures.smallInstall));
        this.jMenuItem5.setIcon(new ImageIcon(Textures.smallCancel));
        this.jMenuItem6.setIcon(new ImageIcon(Textures.smallRunMod));
        this.jMenuItem7.setIcon(new ImageIcon(Textures.smallRunMod));
        this.jMenuItem10.setIcon(new ImageIcon(Textures.smallInstall));
        this.jMenuItem14.setIcon(new ImageIcon(Textures.Logo16));
        this.jMenuItem15.setIcon(new ImageIcon(Textures.planetMC));
        this.jMenuItem16.setIcon(new ImageIcon(Textures.MCForum));
        this.jMenuItem17.setIcon(new ImageIcon(Textures.smallReport));
        final Frame frame = this;
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame.this.newMod(e);
            }
        });
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.open(e);
            }
        });
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.save(e);
            }
        });
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.installModOnMinecraft(e);
            }
        });
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.exit(e);
            }
        });
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.testMod(e);
            }
        });
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.testServerMod(e);
            }
        });
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.checkForErrors(e);
            }
        });
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.backup(e);
            }
        });
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.InstallMCP(e);
            }
        });
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.plugins(e);
            }
        });
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.options(e);
            }
        });
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.textureEditor(e);
            }
        });
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.about(e);
            }
        });
        this.jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.planetMC(e);
            }
        });
        this.jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.mcForum(e);
            }
        });
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.reportError(e);
            }
        });
        this.jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.sourceCode(e);
            }
        });
        this.jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.textures(e);
            }
        });
        this.jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.finalMod(e);
            }
        });
        this.jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.installer(e);
            }
        });
        this.jMenuItem22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_Cleanup(e);
            }
        });
        this.jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_Decompile(e);
            }
        });
        this.jMenuItem24.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_getChangedSrc(e);
            }
        });
        this.jMenuItem25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_Reformat(e);
            }
        });
        this.jMenuItem26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_StartClient(e);
            }
        });
        this.jMenuItem27.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_StartServer(e);
            }
        });
        this.jMenuItem28.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_UpdateIDs(e);
            }
        });
        this.jMenuItem29.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_UpdateMCP(e);
            }
        });
        this.jMenuItem30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_UpdateMD5(e);
            }
        });
        this.jMenuItem31.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.MCP_UpdateNames(e);
            }
        });
    }

    private void planetMC(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(Urls.PlanetMinecraft.getUrlAsString()));
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void mcForum(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(Urls.MinecraftForum.getUrlAsString()));
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void options(ActionEvent evt) {
        try {
            Options o = new Options();
            o.setVisible(true);
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void newMod(ActionEvent evt) {
        try {
            Mod mod = new Mod();
            mod.name = Unique.getModName("new Mod");
            mod.version = "1.0.0";
            MainPanel.setPanel(new ModManager(mod).getModPanel());
            Console.Info("Created a new mod");
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void open(ActionEvent evt) {
        try {
            Mod mod = SaveManager.loadMod();
            if (mod != null) {
                ModManager manager = new ModManager(mod);
                for (SaveBase sb : manager.getMod().listAllSaveBase()) {
                    try {
                        if (sb.getPanel() != null) continue;
                        if (sb.getParent() == null) {
                            sb.getPlugin().getPanelBase(sb);
                            continue;
                        }
                        sb.getParent().getNewChildPanel(sb);
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                    }
                }
                MainPanel.setPanel(manager.getModPanel());
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void save(ActionEvent evt) {
        try {
            Main.saveConfig();
            for (ModManager mod : ModManager.mods) {
                try {
                    SaveManager.saveMod(mod);
                    BackupManager.backup();
                }
                catch (Exception e) {
                    Console.Err(e);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    JOptionPane.showMessageDialog(null, "Error while saving:\n\n" + sw.toString(), "Error!", 0);
                }
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void exit(ActionEvent evt) {
        try {
            Main.onExit(false);
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void about(ActionEvent evt) {
        try {
            new About((java.awt.Frame)Settings.getFrame(), true).setVisible(true);
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void InstallMCP(ActionEvent evt) {
        int ret = 0;
        if (Settings.isInstalled()) {
            ret = OptionPane.showConfirmDialog(this, "MCP is already installed!\n\nDo you want to re\u00efnstall it?", "MCP is installed!", 0, 2);
        }
        if (ret == 0) {
            InstallMCP id = new InstallMCP();
            id.setVisible(true);
            int result = id.getReturnStatus();
            if (result == 0) {
                SetupManager.runSetup();
            }
        }
    }

    private void checkForErrors(ActionEvent evt) {
        try {
            ModManager manager = null;
            if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath.length > 0 && Tree.getTree().currentTreePath[0] != null) {
                manager = Tree.getTree().currentTreePath[0].mod;
            }
            if (manager == null) {
                if (ModManager.mods.isEmpty()) {
                    OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                } else if (ModManager.mods.size() != 1) {
                    Object[] mods = new ModManager[ModManager.mods.size()];
                    for (int a = 0; a < mods.length; ++a) {
                        mods[a] = ModManager.mods.get(a);
                    }
                    manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                } else {
                    manager = ModManager.mods.get(0);
                }
            }
            if (manager != null) {
                final ModManager m = manager;
                Thread checkForErrors = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            67 v0 = this;
                            v0.m.Save();
                            ArrayList<String> log = new ArrayList<String>();
                            String error = Export.ContainsError(m.getMod().name);
                            if (error != null) {
                                log.add("Modname " + m.getMod().name + " : " + error);
                            }
                            for (SaveBase sb : m.getModPanel().mod.listAllSaveBase()) {
                                try {
                                    sb.Check(log);
                                }
                                catch (Exception e) {
                                    log.add(sb.getName() + ": " + e.getMessage());
                                }
                            }
                            if (!log.isEmpty()) {
                                String text = "";
                                for (String str : log) {
                                    if (text.equals("")) {
                                        text = str;
                                        continue;
                                    }
                                    text = text + "\n" + str;
                                }
                                LogDialog ld = new LogDialog(text, true, null);
                                ld.setVisible(true);
                                if (ld.getReturnStatus() == 0) {
                                    throw new Exception("Errors found!");
                                }
                            } else {
                                OptionPane.showMessageDialog(Settings.getFrame(), "No error's found", "No Errors", 1);
                            }
                        }
                        catch (Exception ex) {
                            return;
                        }
                        ThreadManager.removeThread("Check for Errors");
                    }
                });
                ThreadManager.addThread(checkForErrors, "Check for Errors");
                checkForErrors.start();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void testMod(ActionEvent evt) {
        try {
            ModManager manager = null;
            if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath.length > 0 && Tree.getTree().currentTreePath[0] != null) {
                manager = Tree.getTree().currentTreePath[0].mod;
            }
            if (manager == null) {
                if (ModManager.mods.isEmpty()) {
                    OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                } else if (ModManager.mods.size() != 1) {
                    Object[] mods = new ModManager[ModManager.mods.size()];
                    for (int a = 0; a < mods.length; ++a) {
                        mods[a] = ModManager.mods.get(a);
                    }
                    manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                } else {
                    manager = ModManager.mods.get(0);
                }
            }
            if (manager != null) {
                final ModManager mod = manager;
                Thread testMod = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                mod.checkForErrors();
                            }
                            catch (Exception ex) {
                                return;
                            }
                            Export.testMod(mod, true);
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                        ThreadManager.removeThread("Test Client");
                    }
                });
                ThreadManager.addThread(testMod, "Test Client");
                testMod.start();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_Recompile(ActionEvent evt) {
        Thread recompile = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    McpScripts.Recompile(null);
                    Settings.put("modmaker.reobf", "false");
                }
                catch (Exception e) {
                    Console.Err(e);
                }
                ThreadManager.removeThread("Recompiling");
            }
        });
        try {
            ThreadManager.addThread(recompile, "Recompiling");
            recompile.start();
        }
        catch (Exception e) {
            Console.Warning("Minecraft is already be recompiling!");
        }
    }

    private void MCP_Cleanup(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.Cleanup();
                        McpScripts.PToOut(p, "Cleanup");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("Cleanup");
                }
            });
            ThreadManager.addThread(t, "Cleanup");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_Decompile(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.Decompile();
                        McpScripts.PToOut(p, "Decompile");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("Decompile");
                }
            });
            ThreadManager.addThread(t, "Decompile");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_getChangedSrc(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.getChangedSrc();
                        McpScripts.PToOut(p, "getChangedSrc");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("getChangedSrc");
                }
            });
            ThreadManager.addThread(t, "getChangedSrc");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_Reformat(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.Reformat();
                        McpScripts.PToOut(p, "Reformat");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("Reformat");
                }
            });
            ThreadManager.addThread(t, "Reformat");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_StartClient(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.StartClient();
                        McpScripts.PToOut(p, "StartClient");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("StartClient");
                }
            });
            ThreadManager.addThread(t, "StartClient");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_StartServer(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.StartServer();
                        McpScripts.PToOut(p, "StartServer");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("StartServer");
                }
            });
            ThreadManager.addThread(t, "StartServer");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_UpdateIDs(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.updateIds();
                        McpScripts.PToOut(p, "updateIds");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("updateIds");
                }
            });
            ThreadManager.addThread(t, "updateIds");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_UpdateMCP(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.updateMCP();
                        McpScripts.PToOut(p, "updateMCP");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("updateMCP");
                }
            });
            ThreadManager.addThread(t, "updateMCP");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_UpdateMD5(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.updateMd5();
                        McpScripts.PToOut(p, "updateMd5");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("updateMd5");
                }
            });
            ThreadManager.addThread(t, "updateMd5");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_UpdateNames(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = McpScripts.updateNames();
                        McpScripts.PToOut(p, "updateNames");
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("updateNames");
                }
            });
            ThreadManager.addThread(t, "updateNames");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void MCP_ReObfuscate(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        McpScripts.ReObfuscate(null);
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("ReObfuscate");
                }
            });
            ThreadManager.addThread(t, "ReObfuscate");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void plugins(ActionEvent evt) {
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PluginDialog pd = new PluginDialog(0);
                        pd.setVisible(true);
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("Plugin Manager");
                }
            });
            ThreadManager.addThread(t, "Plugin Manager");
            t.start();
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void testServerMod(ActionEvent evt) {
        try {
            if (!Settings.isInstalled()) {
                OptionPane.showMessageDialog(Settings.getFrame(), "MCP isn't installed!", "MCP isn't installed", 2);
                return;
            }
            ModManager manager = null;
            if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath[0] != null) {
                manager = Tree.getTree().currentTreePath[0].mod;
            }
            if (manager == null) {
                if (ModManager.mods.isEmpty()) {
                    OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                } else if (ModManager.mods.size() != 1) {
                    Object[] mods = new ModManager[ModManager.mods.size()];
                    for (int a = 0; a < mods.length; ++a) {
                        mods[a] = ModManager.mods.get(a);
                    }
                    manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                } else {
                    manager = ModManager.mods.get(0);
                }
            }
            if (manager != null) {
                final ModManager mod = manager;
                Thread testMod = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                mod.checkForErrors();
                            }
                            catch (Exception ex) {
                                return;
                            }
                            Export.testMod(mod, false);
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                        ThreadManager.removeThread("Test Server");
                    }
                });
                ThreadManager.addThread(testMod, "Test Server");
                testMod.start();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void installModOnMinecraft(ActionEvent evt) {
        Thread installer = new Thread(new Runnable(){

            @Override
            public void run() {
                block12: {
                    try {
                        if (!Settings.isInstalled()) {
                            OptionPane.showMessageDialog(Settings.getFrame(), "MCP isn't installed!", "MCP isn't installed", 2);
                            return;
                        }
                        Settings.getJdkRoot();
                        ModManager manager = null;
                        if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath[0] != null) {
                            manager = Tree.getTree().currentTreePath[0].mod;
                        }
                        if (manager == null) {
                            if (ModManager.mods.isEmpty()) {
                                OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                            } else if (ModManager.mods.size() != 1) {
                                Object[] mods = new ModManager[ModManager.mods.size()];
                                for (int a = 0; a < mods.length; ++a) {
                                    mods[a] = ModManager.mods.get(a);
                                }
                                manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                            } else {
                                manager = ModManager.mods.get(0);
                            }
                        }
                        if (manager == null) break block12;
                        try {
                            manager.checkForErrors();
                        }
                        catch (Exception ex) {
                            return;
                        }
                        Export.Install(manager);
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                }
                ThreadManager.removeThread("InstallModOnMinecraft");
            }
        });
        try {
            ThreadManager.addThread(installer, "InstallModOnMinecraft");
            installer.start();
        }
        catch (Exception e) {
            Console.Warning("The mod is already installing");
        }
    }

    public void reportError(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReportDialog rd;
                    ModManager manager = null;
                    Tree.TreeModPath[] tmp = Tree.getTree().currentTreePath;
                    if (tmp != null && tmp[0] != null) {
                        manager = tmp[0].mod;
                    }
                    if (manager == null && !ModManager.mods.isEmpty()) {
                        if (ModManager.mods.size() != 1) {
                            Object[] mods = new ModManager[ModManager.mods.size()];
                            for (int a = 0; a < mods.length; ++a) {
                                mods[a] = ModManager.mods.get(a);
                            }
                            manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                        } else {
                            manager = ModManager.mods.get(0);
                        }
                    }
                    if (manager != null) {
                        manager.Save();
                        SaveManager.saveMod(manager);
                        rd = new ReportDialog(manager);
                        rd.setVisible(true);
                        if (rd.getReturnStatus() == 1) {
                            String desc = "Custom Report for mod: " + manager + "\n\nDescription: " + rd.getDiscription();
                            String mail = rd.getEmailAddress();
                            File att = manager.getMod().saveFile;
                            Mail.mail(mail, "[REPORT] " + mail, desc, att);
                        }
                    } else {
                        rd = new ReportDialog(null);
                        rd.setVisible(true);
                        if (rd.getReturnStatus() == 1) {
                            String desc = "Custom Report [no mods]\n\nDescription:\n" + rd.getDiscription();
                            String mail = rd.getEmailAddress();
                            Mail.mail(mail, "[REPORT] " + mail, desc);
                        }
                    }
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
        }).start();
    }

    private void backup(ActionEvent evt) {
        Backups b = new Backups((java.awt.Frame)this, true);
        b.setVisible(true);
    }

    private void textureEditor(ActionEvent evt) {
        TextureEditor te = new TextureEditor((java.awt.Frame)this, null);
        te.setVisible(true);
    }

    public void installer(ActionEvent evt) {
        Thread installer = new Thread(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        if (!Settings.isInstalled()) {
                            OptionPane.showMessageDialog(Settings.getFrame(), "MCP isn't installed!", "MCP isn't installed", 2);
                            return;
                        }
                        Settings.getJdkRoot();
                        ModManager manager = null;
                        if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath.length > 0 && Tree.getTree().currentTreePath[0] != null) {
                            manager = Tree.getTree().currentTreePath[0].mod;
                        }
                        if (manager == null) {
                            if (ModManager.mods.isEmpty()) {
                                OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                            } else if (ModManager.mods.size() != 1) {
                                Object[] mods = new ModManager[ModManager.mods.size()];
                                for (int a = 0; a < mods.length; ++a) {
                                    mods[a] = ModManager.mods.get(a);
                                }
                                manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                            } else {
                                manager = ModManager.mods.get(0);
                            }
                        }
                        if (manager == null) break block13;
                        try {
                            manager.checkForErrors();
                        }
                        catch (Exception ex) {
                            return;
                        }
                        File out = Export.ExportToInstaller(manager);
                        long startTime = System.currentTimeMillis();
                        OptionPane.showMessageDialog(Settings.getFrame(), "www.planetminecraft.com warned me that you're not allowed to \npublish mods generated by any mod editor on their site", "READ THIS!", 2);
                        if (System.currentTimeMillis() - startTime < 2000L) {
                            OptionPane.showMessageDialog(Settings.getFrame(), "YOU DIDN'T READ IT!\n\nDONT PUBLISH THIS MOD OP PLANETMINECRAFT!", "READ THIS!", 2);
                        }
                        Settings.getOS().openDirInExplorer(out.getParentFile());
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                }
                ThreadManager.removeThread("Create Installer");
            }
        });
        try {
            ThreadManager.addThread(installer, "Create Installer");
            installer.start();
        }
        catch (Exception e) {
            Console.Warning("The installer is already be creating");
        }
    }

    public void finalMod(ActionEvent evt) {
        try {
            if (!Settings.isInstalled()) {
                OptionPane.showMessageDialog(Settings.getFrame(), "MCP isn't installed!", "MCP isn't installed", 2);
                return;
            }
            ModManager manager = null;
            if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath.length > 0 && Tree.getTree().currentTreePath[0] != null) {
                manager = Tree.getTree().currentTreePath[0].mod;
            }
            if (manager == null) {
                if (ModManager.mods.isEmpty()) {
                    OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                } else if (ModManager.mods.size() != 1) {
                    Object[] mods = new ModManager[ModManager.mods.size()];
                    for (int a = 0; a < mods.length; ++a) {
                        mods[a] = ModManager.mods.get(a);
                    }
                    manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                } else {
                    manager = ModManager.mods.get(0);
                }
            }
            if (manager != null) {
                final ModManager mod = manager;
                Thread testMod = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                mod.checkForErrors();
                            }
                            catch (Exception ex) {
                                return;
                            }
                            File out = Export.ExportToClasses(mod);
                            OptionPane.showMessageDialog(Settings.getFrame(), "Give allways credits to Deathly's Mod Editor!", "Credits!", 2);
                            long startTime = System.currentTimeMillis();
                            OptionPane.showMessageDialog(Settings.getFrame(), "www.planetminecraft.com warned me that you're not allowed to \npublish mods generated by any mod editor on their site", "READ THIS!", 2);
                            if (System.currentTimeMillis() - startTime < 2000L) {
                                OptionPane.showMessageDialog(Settings.getFrame(), "YOU DIDN'T READ IT!\n\nwww.planetminecraft.com warned me that you're not allowed to \npublish mods generated by any mod editor on their site", "READ THIS!", 2);
                            }
                            Settings.getOS().openDirInExplorer(out.getParentFile());
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                        ThreadManager.removeThread("Export to classes");
                    }
                });
                ThreadManager.addThread(testMod, "Export to classes");
                testMod.start();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    public void textures(ActionEvent evt) {
        Thread export = new Thread(new Runnable(){

            @Override
            public void run() {
                block12: {
                    try {
                        ModManager manager = null;
                        if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath[0] != null) {
                            manager = Tree.getTree().currentTreePath[0].mod;
                        }
                        if (manager == null) {
                            if (ModManager.mods.isEmpty()) {
                                OptionPane.showMessageDialog(Settings.getFrame(), "No Mods Found", "No Mods", 2);
                            } else if (ModManager.mods.size() != 1) {
                                Object[] mods = new ModManager[ModManager.mods.size()];
                                for (int a = 0; a < mods.length; ++a) {
                                    mods[a] = ModManager.mods.get(a);
                                }
                                manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                            } else {
                                manager = ModManager.mods.get(0);
                            }
                        }
                        if (manager == null) break block12;
                        try {
                            manager.checkForErrors();
                        }
                        catch (Exception ex) {
                            return;
                        }
                        File out = Export.ExportTextures(manager);
                        Settings.getOS().openDirInExplorer(out);
                    }
                    catch (Export.ExportException e) {
                        Console.Err(e);
                        OptionPane.showMessageDialog(Settings.getFrame(), "Unable to generate source code\nCause:" + (e.getPlugin() == null ? "" : e.getPlugin().getName()) + " in " + e.getMessage(), "ExportException: " + e.getCause().getMessage(), 2);
                    }
                    catch (IOException ee) {
                        Console.Err(ee);
                        OptionPane.showMessageDialog(Settings.getFrame(), "Unable to generate source code\nCause:" + ee.getMessage(), "IOException", 2);
                    }
                }
                ThreadManager.removeThread("Export Textures");
            }
        });
        try {
            ThreadManager.addThread(export, "Export Textures");
            export.start();
        }
        catch (Exception e) {
            Console.Warning("The textures are already be exporting");
        }
    }

    public void sourceCode(ActionEvent evt) {
        try {
            ModManager manager = null;
            if (Tree.getTree().currentTreePath != null && Tree.getTree().currentTreePath.length > 0 && Tree.getTree().currentTreePath[0] != null) {
                manager = Tree.getTree().currentTreePath[0].mod;
            }
            if (manager == null) {
                if (ModManager.mods.isEmpty()) {
                    OptionPane.showMessageDialog(this, "You must create a mod first!", "No mods", 1);
                    return;
                }
                if (ModManager.mods.size() != 1) {
                    Object[] mods = new ModManager[ModManager.mods.size()];
                    for (int a = 0; a < mods.length; ++a) {
                        mods[a] = ModManager.mods.get(a);
                    }
                    manager = (ModManager)OptionPane.showInputDialog(Settings.getFrame(), "Choose your mod:", "Mod Chooser", 3, mods, ModManager.mods.get(0).toString());
                } else {
                    manager = ModManager.mods.get(0);
                }
            }
            if (manager != null) {
                final ModManager m = manager;
                Thread export = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                m.checkForErrors();
                            }
                            catch (Exception e) {
                                return;
                            }
                            File out = Export.ExportSrc(m);
                            Settings.getOS().openDirInExplorer(out);
                        }
                        catch (Export.ExportException e) {
                            Console.Err(e);
                            OptionPane.showMessageDialog(Settings.getFrame(), "Unable to generate source code\nCause:" + (e.getPlugin() == null ? "" : e.getPlugin().getName()) + " in " + e.getMessage(), "ExportException: " + e.getCause().getMessage(), 2);
                        }
                        catch (IOException ee) {
                            Console.Err(ee);
                            OptionPane.showMessageDialog(Settings.getFrame(), "Unable to generate source code\nCause:" + ee.getMessage(), "IOException", 2);
                        }
                        ThreadManager.removeThread("Export to Source Code");
                    }
                });
                ThreadManager.addThread(export, "Export to Source Code");
                export.start();
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }
}

