/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.Dialogs.PluginDialog;
import net.modmaker.Gui.MainPanel;
import net.modmaker.Gui.Tree;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.Textures;
import net.modmaker.Utils.Unique;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginManager;
import net.modmaker.plugin.SaveBase;

public class Popup
extends JPopupMenu {
    public Popup() {
        JMenuItem item1 = new JMenuItem("New Mod"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        item1.setIcon(new ImageIcon(Textures.smallNewMod));
        item1.setForeground(new Color(204, 204, 204));
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mod mod = new Mod();
                mod.name = Unique.getModName("new Mod");
                mod.version = "1.0.0";
                MainPanel.setPanel(new ModManager(mod).getModPanel());
            }
        });
        JMenuItem item2 = new JMenuItem("Load"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        item2.setIcon(new ImageIcon(Textures.smallOpenMod));
        item2.setForeground(new Color(204, 204, 204));
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ee) {
                try {
                    Mod mod = SaveManager.loadMod();
                    if (mod != null) {
                        ModManager manager = new ModManager(mod);
                        for (SaveBase sb : manager.getMod().listAllSaveBase()) {
                            try {
                                if (sb.getPanel() != null) continue;
                                if (sb.getParent() == null) {
                                    sb.getPlugin().getPanelBase(sb);
                                    continue;
                                }
                                sb.getParent().getNewChildPanel(sb);
                            }
                            catch (Throwable e) {
                                Console.Err(e);
                            }
                        }
                        MainPanel.setPanel(manager.getModPanel());
                    }
                }
                catch (Exception e) {
                    Console.Err(e);
                }
            }
        });
        this.add(item1);
        this.add(item2);
    }

    public Popup(final ModManager mod) {
        JMenu menu1 = new JMenu("New ..."){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        menu1.setIcon(new ImageIcon(Textures.smallAddFile));
        menu1.setForeground(new Color(204, 204, 204));
        int i = 0;
        while (i < PluginManager.getPlugins().size()) {
            final Plugin plugin = PluginManager.getPlugins().get(i);
            final int count = i++;
            JMenuItem item = new JMenuItem(plugin.getName()){

                @Override
                public void paintComponent(Graphics g) {
                    if (PluginManager.getPlugins().size() % 2 == 0) {
                        if (count < PluginManager.getPlugins().size() / 2 - 1) {
                            this.paintUpSide(g);
                        } else {
                            this.paintDownSide(g);
                        }
                    } else if (count < PluginManager.getPlugins().size() / 2) {
                        this.paintUpSide(g);
                    } else if (count > PluginManager.getPlugins().size() / 2) {
                        this.paintDownSide(g);
                    } else {
                        this.paintMiddel(g);
                    }
                    super.paintComponent(g);
                }

                public void paintUpSide(Graphics g) {
                    for (int i = 0; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + i + this.getHeight() * count, 51 + i + this.getHeight() * count, 51 + i + this.getHeight() * count));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                }

                public void paintDownSide(Graphics g) {
                    int index = PluginManager.getPlugins().size() - count;
                    for (int i = 0; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() * index - i, 51 + this.getHeight() * index - i, 51 + this.getHeight() * index - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                }

                public void paintMiddel(Graphics g) {
                    for (int i = 0; i < this.getHeight() / 2; ++i) {
                        g.setColor(new Color(51 + i + this.getHeight() * count, 51 + i + this.getHeight() * count, 51 + i + this.getHeight() * count));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    int index = PluginManager.getPlugins().size() - count;
                    for (int i = this.getHeight() / 2; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() * index - i, 51 + this.getHeight() * index - i, 51 + this.getHeight() * index - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                }
            };
            item.setForeground(new Color(204, 204, 204));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaveBase sb = plugin.getSaveBase(mod.getMod());
                    PanelBase pb = plugin.getPanelBase(sb);
                    mod.getMod().object.add(sb);
                    Tree.getTree().UpdateTree();
                }
            });
            menu1.add(item);
        }
        if (menu1.getItemCount() == 0) {
            JMenuItem item = new JMenuItem("[No Plugins Found....]"){

                @Override
                public void paintComponent(Graphics g) {
                    int i;
                    for (i = 0; i < this.getHeight() / 2; ++i) {
                        g.setColor(new Color(51 + i, 51 + i, 51 + i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    for (i = this.getHeight() / 2; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    super.paintComponent(g);
                }
            };
            item.setForeground(new Color(204, 204, 204));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginDialog pd = new PluginDialog(0);
                    pd.setVisible(true);
                }
            });
            menu1.add(item);
        }
        JMenuItem item1 = new JMenuItem("Save"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i + this.getHeight(), 51 + i + this.getHeight(), 51 + i + this.getHeight()));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        item1.setIcon(new ImageIcon(Textures.smallSaveMod));
        item1.setForeground(new Color(204, 204, 204));
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    SaveManager.saveMod(mod);
                }
                catch (Exception e) {
                    Console.Err(e);
                    OptionPane.showMessageDialog(Settings.getFrame(), "Cannot Save Mod", "Failed to Save Mod", 0);
                }
            }
        });
        JMenuItem item2 = new JMenuItem("Close"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i, 51 + this.getHeight() * 2 - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        item2.setForeground(new Color(204, 204, 204));
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    SaveManager.saveMod(mod);
                    MainPanel.setPanel(MainPanel.startPanel);
                    for (int a = 0; a < ModManager.mods.size(); ++a) {
                        ModManager manager = ModManager.mods.get(a);
                        if (!manager.getMod().name.equals(mod.getMod().name)) continue;
                        ModManager.mods.remove(a);
                        break;
                    }
                    Tree.getTree().UpdateTree();
                }
                catch (Exception e) {
                    Console.Err(e);
                    OptionPane.showMessageDialog(Settings.getFrame(), "Cannot Save Mod", "Failed to Save Mod", 0);
                }
            }
        });
        JMenuItem item3 = new JMenuItem("Delete"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        item3.setIcon(new ImageIcon(Textures.smallCancel));
        item3.setForeground(new Color(204, 204, 204));
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = OptionPane.showConfirmDialog(null, "Are You sure you want to delete this File?\nYou can't recover it anymore!", "Delete Mod", 0, 2);
                if (result == 0) {
                    MainPanel.setPanel(MainPanel.startPanel);
                    for (int a = 0; a < ModManager.mods.size(); ++a) {
                        ModManager manager = ModManager.mods.get(a);
                        if (!manager.getMod().name.equals(mod.getMod().name)) continue;
                        ModManager.mods.remove(a);
                        break;
                    }
                    Tree.getTree().UpdateTree();
                    if (mod.getMod().saveFile != null) {
                        mod.getMod().saveFile.delete();
                    }
                }
            }
        });
        this.add(menu1);
        this.add(item1);
        this.add(item2);
        this.add(item3);
    }

    public Popup(final ModManager manager, Plugin plugin, final ArrayList<Tree.TreeModPath> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            final int c = i;
            JMenuItem item1 = new JMenuItem("Add " + paths.get((int)i).plugin.getName()){

                @Override
                public void paintComponent(Graphics g) {
                    int i;
                    for (i = 0; i < this.getHeight() / 2; ++i) {
                        g.setColor(new Color(51 + i, 51 + i + this.getHeight() * 0, 51 + i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    for (i = this.getHeight() / 2; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    super.paintComponent(g);
                }
            };
            item1.setIcon(new ImageIcon(Textures.smallAddFile));
            item1.setForeground(new Color(204, 204, 204));
            item1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaveBase sb = ((Tree.TreeModPath)paths.get((int)c)).plugin.getSaveBase(manager.getMod());
                    PanelBase pb = ((Tree.TreeModPath)paths.get((int)c)).plugin.getPanelBase(sb);
                    manager.getMod().object.add(sb);
                    Tree.getTree().UpdateTree();
                    MainPanel.setPanel(pb);
                }
            });
            this.add(item1);
        }
    }

    public Popup(final ModManager manager, final SaveBase sb, final ArrayList<Tree.TreeModPath> paths) {
        final SaveBase child = sb.getNewChild();
        if (child != null) {
            String name = child.getName().split("_")[0];
            JMenuItem item = new JMenuItem("Add " + name){

                @Override
                public void paintComponent(Graphics g) {
                    for (int i = 0; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + i, 51 + i + this.getHeight() * 0, 51 + i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    super.paintComponent(g);
                }
            };
            item.setIcon(new ImageIcon(Textures.smallAddFile));
            item.setForeground(new Color(204, 204, 204));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelBase pb = sb.getNewChildPanel(child);
                    sb.addChild(child);
                    Tree.getTree().UpdateTree();
                    MainPanel.setPanel(pb);
                }
            });
            this.add(item);
        }
        JMenuItem item = new JMenuItem("Delete"){

            @Override
            public void paintComponent(Graphics g) {
                if (sb.getNewChild() == null && paths.size() == 1) {
                    int i;
                    for (i = 0; i < this.getHeight() / 2; ++i) {
                        g.setColor(new Color(51 + i, 51 + i + this.getHeight() * 0, 51 + i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    for (i = this.getHeight() / 2; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                } else {
                    for (int i = 0; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                }
                super.paintComponent(g);
            }
        };
        item.setIcon(new ImageIcon(Textures.smallCancel));
        item.setForeground(new Color(204, 204, 204));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = OptionPane.showConfirmDialog(null, "Are You sure you want to delete this File?\nYou can't recover it anymore!", "Delete Mod", 0, 2);
                if (result == 0) {
                    if (sb.getParent() != null) {
                        for (int a = 0; a < sb.getParent().getChildren().size(); ++a) {
                            SaveBase o = sb.getParent().getChildren().get(a);
                            if (!o.getName().equals(sb.getName())) continue;
                            sb.getParent().removeChild(a);
                        }
                    } else {
                        for (int a = 0; a < manager.getMod().object.size(); ++a) {
                            SaveBase o = manager.getMod().object.get(a);
                            if (!o.getClass().isAssignableFrom(sb.getClass()) || !o.getName().equals(sb.getName())) continue;
                            manager.getMod().object.remove(a);
                        }
                    }
                    Tree.getTree().UpdateTree();
                    MainPanel.setPanel(manager.getModPanel());
                }
            }
        });
        this.add(item);
        if (paths.size() > 1) {
            JMenuItem it = new JMenuItem("Delete All"){

                @Override
                public void paintComponent(Graphics g) {
                    int i;
                    for (i = 0; i < this.getHeight(); ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i, this.getWidth(), 1);
                    }
                    for (i = this.getHeight(); i < this.getHeight() * 2; ++i) {
                        g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                        g.drawRect(0, i - this.getHeight(), this.getWidth(), 1);
                    }
                    super.paintComponent(g);
                }
            };
            it.setIcon(new ImageIcon(Textures.smallCancel));
            it.setForeground(new Color(204, 204, 204));
            it.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = OptionPane.showConfirmDialog(null, "Are You sure you want to delete these Files?\nYou can't recover them anymore!", "Delete Mod", 0, 2);
                    if (result == 0) {
                        for (int i = 0; i < paths.size(); ++i) {
                            SaveBase o = ((Tree.TreeModPath)paths.get((int)i)).subPath.get(((Tree.TreeModPath)paths.get((int)i)).subPath.size() - 1);
                            if (o.getParent() != null) {
                                SaveBase parent = o.getParent();
                                parent.removeChild(o);
                                continue;
                            }
                            Mod mod = o.getMod();
                            mod.object.remove(o);
                        }
                        Tree.getTree().UpdateTree();
                        MainPanel.setPanel(manager.getModPanel());
                    }
                }
            });
            this.add(it);
        }
    }
}

