/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.modmaker.Console.Console;
import net.modmaker.Gui.MainPanel;
import net.modmaker.Gui.Popup;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.Textures;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginManager;
import net.modmaker.plugin.SaveBase;

public class Tree
extends JTree {
    private static Tree tree;
    public TreeModPath[] currentTreePath;
    private DefaultMutableTreeNode main;

    public Tree() {
        tree = this;
        this.setCellRenderer(new CustomIconRenderer());
        DefaultTreeCellRenderer render = (DefaultTreeCellRenderer)this.getCellRenderer();
        render.setTextSelectionColor(Color.white);
        render.setBackgroundSelectionColor(new Color(100, 100, 100));
        render.setBackground(new Color(100, 100, 100));
        render.setBorderSelectionColor(new Color(100, 100, 100));
        render.setTextNonSelectionColor(Color.black);
        this.setBackground(new Color(100, 100, 100));
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Tree.this.currentTreePath = new TreeModPath[e.getPaths().length];
                for (int i = 0; i < e.getPaths().length; ++i) {
                    Tree.this.currentTreePath[i] = new TreeModPath(e.getPaths()[i]);
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Tree.this.PropertyChange(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Tree.this.MousePressed(evt);
            }
        });
    }

    public static Tree getTree() {
        return tree;
    }

    public void UpdateTree() {
        ArrayList<String> ep = new ArrayList<String>();
        for (int a = 0; a < this.getRowCount(); ++a) {
            ep.add(this.getExpansionState(this, a));
        }
        this.main = new DefaultMutableTreeNode("Mods");
        for (ModManager manager : ModManager.mods) {
            DefaultMutableTreeNode mod = new DefaultMutableTreeNode(manager.getMod().name);
            this.main.add(mod);
            for (Plugin plugin : PluginManager.getPlugins()) {
                DefaultMutableTreeNode p = new DefaultMutableTreeNode(plugin.getName());
                mod.add(p);
                for (SaveBase sb : manager.getMod().object) {
                    if (!sb.getClass().isAssignableFrom(plugin.getSaveBase(null).getClass())) continue;
                    this.treeChildren(p, sb);
                }
            }
        }
        this.setModel(new DefaultTreeModel(this.main));
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private void treeChildren(DefaultMutableTreeNode parent, SaveBase s) {
        DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(s.getName());
        parent.add(sNode);
        if (!s.getChildren().isEmpty()) {
            for (SaveBase schild : s.getChildren()) {
                this.treeChildren(sNode, schild);
            }
        }
    }

    public boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public String getExpansionState(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        StringBuffer buf = new StringBuffer();
        int rowCount = tree.getRowCount();
        for (int i = row; i < rowCount; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (i != row && !this.isDescendant(path, rowPath)) break;
            if (!tree.isExpanded(path)) continue;
            buf.append("," + String.valueOf(i - row));
        }
        return buf.toString();
    }

    public void restoreExpanstionState(JTree tree, int row, String expansionState) {
        StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while (stok.hasMoreTokens()) {
            int token = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return this.main;
    }

    public void MousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            Popup pop;
            try {
                if (this.currentTreePath[0] == null) {
                    pop = new Popup();
                } else if (!this.currentTreePath[0].subPath.isEmpty()) {
                    ArrayList<TreeModPath> paths = new ArrayList<TreeModPath>();
                    for (int i = 0; i < this.currentTreePath.length; ++i) {
                        if (this.currentTreePath[i].subPath.isEmpty()) continue;
                        paths.add(this.currentTreePath[i]);
                    }
                    pop = new Popup(this.currentTreePath[0].mod, this.currentTreePath[0].subPath.get(this.currentTreePath[0].subPath.size() - 1), paths);
                } else if (this.currentTreePath[0].plugin != null) {
                    ArrayList<TreeModPath> paths = new ArrayList<TreeModPath>();
                    for (int i = 0; i < this.currentTreePath.length; ++i) {
                        if (this.currentTreePath[i].plugin == null) continue;
                        paths.add(this.currentTreePath[i]);
                    }
                    pop = new Popup(this.currentTreePath[0].mod, this.currentTreePath[0].plugin, paths);
                } else {
                    pop = this.currentTreePath[0].mod != null ? new Popup(this.currentTreePath[0].mod) : new Popup();
                }
            }
            catch (Exception e) {
                pop = new Popup();
            }
            if (pop == null) {
                pop = new Popup();
            }
            pop.show(this, evt.getX(), evt.getY());
        }
    }

    private void PropertyChange(PropertyChangeEvent evt) {
        try {
            TreePath[] tp = this.getSelectionPaths();
            if (tp != null) {
                this.currentTreePath = new TreeModPath[tp.length];
                for (int i = 0; i < tp.length; ++i) {
                    this.currentTreePath[i] = new TreeModPath(tp[i]);
                }
                if (tp.length > 0) {
                    if (!this.currentTreePath[0].subPath.isEmpty()) {
                        PanelBase panel = this.currentTreePath[0].subPath.get(this.currentTreePath[0].subPath.size() - 1).getPanel();
                        MainPanel.setPanel(panel);
                    } else if (this.currentTreePath[0].plugin == null) {
                        if (this.currentTreePath[0].mod != null) {
                            MainPanel.setPanel(this.currentTreePath[0].mod.getModPanel());
                        } else {
                            MainPanel.setPanel(MainPanel.startPanel);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public static class TreeModPath {
        public int length;
        public ModManager mod;
        public Plugin plugin;
        public ArrayList<SaveBase> subPath;

        public TreeModPath(TreePath path) {
            block17: {
                try {
                    Object[] obj = path.getPath();
                    this.length = obj.length;
                    this.subPath = new ArrayList();
                    if (this.length <= 1) {
                        this.mod = null;
                        this.plugin = null;
                        break block17;
                    }
                    if (this.length == 2) {
                        ModManager m = null;
                        for (ModManager mod : ModManager.mods) {
                            if (!mod.getMod().name.equalsIgnoreCase(obj[1].toString())) continue;
                            m = mod;
                        }
                        this.mod = m;
                        this.plugin = null;
                        break block17;
                    }
                    if (this.length == 3) {
                        ModManager m = null;
                        for (ModManager mod : ModManager.mods) {
                            if (!mod.getMod().name.equalsIgnoreCase(obj[1].toString())) continue;
                            m = mod;
                        }
                        this.mod = m;
                        Plugin p = null;
                        for (Plugin plugin : PluginManager.getPlugins()) {
                            if (!plugin.getName().equalsIgnoreCase(obj[2].toString())) continue;
                            p = plugin;
                        }
                        this.plugin = p;
                        break block17;
                    }
                    if (this.length == 4) {
                        ModManager m = null;
                        for (ModManager mod : ModManager.mods) {
                            if (!mod.getMod().name.equalsIgnoreCase(obj[1].toString())) continue;
                            m = mod;
                        }
                        this.mod = m;
                        Plugin p = null;
                        for (Plugin plugin : PluginManager.getPlugins()) {
                            if (!plugin.getName().equalsIgnoreCase(obj[2].toString())) continue;
                            p = plugin;
                        }
                        this.plugin = p;
                        for (SaveBase sb : this.mod.getMod().object) {
                            if (!sb.getPlugin().getName().equalsIgnoreCase(this.plugin.getName()) || !sb.getName().equals(obj[3].toString()) || sb.getParent() != null) continue;
                            this.subPath.add(sb);
                            break block17;
                        }
                        break block17;
                    }
                    ModManager m = null;
                    for (ModManager mod : ModManager.mods) {
                        if (!mod.getMod().name.equalsIgnoreCase(obj[1].toString())) continue;
                        m = mod;
                    }
                    this.mod = m;
                    Plugin p = null;
                    for (Plugin plugin : PluginManager.getPlugins()) {
                        if (!plugin.getName().equalsIgnoreCase(obj[2].toString())) continue;
                        p = plugin;
                    }
                    this.plugin = p;
                    for (SaveBase sb : this.mod.getMod().object) {
                        if (!sb.getPlugin().getName().equalsIgnoreCase(this.plugin.getName()) || !sb.getName().equals(obj[3].toString()) || sb.getParent() != null) continue;
                        this.subPath.add(sb);
                        break;
                    }
                    block11: for (int a = 4; a < obj.length; ++a) {
                        for (SaveBase sb : this.subPath.get(this.subPath.size() - 1).getChildren()) {
                            if (!sb.getName().equalsIgnoreCase(obj[a].toString())) continue;
                            this.subPath.add(sb);
                            continue block11;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class CustomIconRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon folder;
        private ImageIcon file;

        public CustomIconRenderer() {
            try {
                this.folder = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/folder.png")));
                this.file = new ImageIcon(Textures.Transparent(Color.black, ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/File.png"))));
            }
            catch (IOException e) {
                Console.Err(e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNode[] path = node.getPath();
            if (path.length == 1) {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            } else if (path.length == 2) {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            } else if (path.length == 3) {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            } else {
                this.setIcon(this.file);
            }
            return this;
        }
    }
}

