/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.Frame;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.ModManager;
import net.modmaker.plugin.PluginManager;

public class BackupSystem {
    private static Thread backupSystem;

    public static void startBackupSystem() {
        if (backupSystem == null) {
            backupSystem = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            long time = System.currentTimeMillis();
                            new File(Settings.getRoot() + "/backup/" + BackupSystem.getDate(time)).mkdirs();
                            for (ModManager manager : ModManager.mods) {
                                File saveFile = SaveManager.saveMod(manager);
                                FileManager.Copy(saveFile, new File(Settings.getRoot() + "/backup/" + BackupSystem.getDate(time) + "/" + saveFile.getName()));
                            }
                            SaveManager.saveConfig(new File(Settings.getRoot() + "/backup/" + BackupSystem.getDate(time) + "/Config.cfg"));
                            BackupSystem.setBackupList();
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            });
            backupSystem.start();
        } else if (!backupSystem.isAlive()) {
            backupSystem.start();
        }
    }

    public static void stopBackupSystem() {
        if (backupSystem != null && backupSystem.isAlive()) {
            backupSystem.stop();
        }
    }

    public static void setBackupList() {
        File[] files = new File(Settings.getRoot() + "/backup").listFiles();
        JMenu menu = new JMenu("Restore Backup");
        int count = 0;
        for (int a = files.length - 1; a >= 0; --a) {
            final File file = files[a];
            if (!file.isDirectory()) continue;
            ++count;
            if (a > 10) {
                FileManager.Delete(file);
                continue;
            }
            try {
                JMenuItem item = new JMenuItem();
                item.setText(file.getName());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int r = OptionPane.showConfirmDialog(Settings.getFrame(), "Are you sure you want to restore a backup?", "Restore Backup", 0, 3);
                        if (r == 0) {
                            try {
                                ModManager.mods.clear();
                                PluginManager.DisablePlugins();
                                FileManager.Copy(new File(file.getPath() + "/Config.cfg"), new File(Settings.getRoot() + "/Config.cfg"));
                                for (File saveFile : file.listFiles(new FilenameFilter(){

                                    @Override
                                    public boolean accept(File dir, String name) {
                                        return !name.equals("Config.cfg");
                                    }
                                })) {
                                    FileManager.Copy(saveFile, new File(Settings.getRoot() + "/Save/" + saveFile.getName()));
                                }
                                SaveManager.loadConfig();
                                PluginManager.EnablePlugins();
                                SaveManager.loadAllMods();
                            }
                            catch (Exception ee) {
                                Console.Err(ee);
                            }
                        }
                    }
                });
                menu.add(item);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        while (menu.getItemCount() > 10) {
            menu.remove(menu.getItemCount() - 1);
        }
        if (Settings.getFrame() != null) {
            ((Frame)Settings.getFrame()).setBackupMenu(menu);
        }
    }

    private static String getDate(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH.mm.ss dd-MM-yyyy");
        return sdf.format(time);
    }
}

