/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.modmaker.IO.ClassObject;
import net.modmaker.IO.ClassWriter;
import net.modmaker.IO.MethodeObject;
import net.modmaker.IO.VariableObject;

public class ClassReader {
    private final Reader reader;
    private String text = "";
    private int rows = 0;
    private int rowCount = 0;
    private ClassObject classObj;

    public ClassReader(Reader reader) {
        this.reader = reader;
    }

    public ClassReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public ClassReader(String fileName) throws FileNotFoundException {
        this(new FileReader(fileName));
    }

    public void analizeClass() throws Exception {
        this.classObj = new ClassObject();
        try {
            char[] buffer = new char[1024];
            int i = 0;
            while ((i = this.reader.read(buffer)) != -1) {
                for (int a = 0; a < 1024; ++a) {
                    char[] test = new char[1];
                    if (buffer[a] == test[0]) continue;
                    this.text = this.text + buffer[a];
                }
                buffer = new char[1024];
            }
            this.text = this.text.replace("\r", "");
            String[] lines = this.text.split("\n");
            this.rows = lines.length;
            this.rowCount = 0;
            boolean inComment = false;
            while (this.rowCount < this.rows) {
                String[] split;
                String line = lines[this.rowCount];
                if (line.contains("//")) {
                    line = line.split("//")[0];
                }
                if (!inComment) {
                    if (line.contains("/*")) {
                        if (line.contains("*/")) {
                            inComment = false;
                            this.readLine(line.split("/*")[0]);
                            split = line.split(Pattern.quote("*/"));
                            if (split.length > 1) {
                                this.readLine(split[split.length - 1]);
                            }
                        } else {
                            inComment = true;
                        }
                    } else {
                        this.readLine(line);
                    }
                } else if (line.contains("*/")) {
                    inComment = false;
                    split = line.split(Pattern.quote("*/"));
                    if (split.length > 1) {
                        this.readLine(split[split.length - 1]);
                    }
                }
                ++this.rowCount;
            }
        }
        catch (Throwable e) {
            Throwable ee = null;
            try {
                ee = new Exception(this.text.split("\n")[this.rowCount] + " (Line: " + this.rowCount + ")", e);
            }
            catch (Exception eee) {
                ee = e;
            }
            ee.printStackTrace();
        }
    }

    private void readLine(String line) {
        while (line.startsWith(" ")) {
            line = line.substring(1);
        }
        while (line.endsWith(" ")) {
            line = line.substring(0, line.length() - 1);
        }
        if (!"".equals(line) && line != null) {
            if (line.startsWith("package ")) {
                this.classObj.setPackage(line.substring("package ".length()));
                if (this.classObj.getPackage().endsWith(";")) {
                    this.classObj.setPackage(this.classObj.getPackage().substring(0, this.classObj.getPackage().length() - 1));
                }
                while (this.classObj.getPackage().startsWith(" ")) {
                    this.classObj.setPackage(this.classObj.getPackage().substring(1));
                }
            } else if (line.startsWith("import ")) {
                String im = line.substring("import ".length());
                if (im.endsWith(";")) {
                    im = im.substring(0, im.length() - 1);
                }
                while (im.startsWith(" ")) {
                    im = im.substring(1);
                }
                while (im.endsWith(" ")) {
                    im = im.substring(0, im.length() - 1);
                }
                this.classObj.getImports().add(im);
            } else if (line.contains("class")) {
                this.readClass();
            }
        }
    }

    private void readClass() {
        String l;
        String[] lines = this.text.split("\n");
        int row = 1;
        while (true) {
            l = lines[this.rowCount - row];
            while (l.startsWith(" ")) {
                l = l.substring(1);
            }
            while (l.endsWith(" ")) {
                l = l.substring(0, l.length() - 1);
            }
            if (!l.startsWith("@")) break;
            this.classObj.getAnnotations().add(l);
            --row;
        }
        l = lines[this.rowCount];
        l = l.replace("  ", " ");
        l = l.replace("   ", " ");
        l = l.replace("    ", " ");
        String[] spl = (l = l.replace("     ", " ")).split("class ");
        String begin = spl[0];
        if (!begin.equals("")) {
            String[] spb;
            for (String str : spb = begin.split(" ")) {
                this.classObj.getPre().add(str);
            }
        }
        String end = spl[1];
        boolean endsWithBrack = false;
        while (end.startsWith(" ")) {
            end = end.substring(1);
        }
        while (end.endsWith(" ")) {
            end = end.substring(0, end.length() - 1);
        }
        if (end.endsWith("{")) {
            endsWithBrack = true;
            end = end.substring(0, end.length() - 1);
        }
        while (end.endsWith(" ")) {
            end = end.substring(0, end.length() - 1);
        }
        String[] endSp = end.split(" ");
        this.classObj.setName(endSp[0]);
        for (int a = 1; a < endSp.length; ++a) {
            if (endSp[a].equals("extends")) {
                if (a + 1 >= endSp.length) continue;
                this.classObj.setExtends(endSp[++a]);
                continue;
            }
            if (!endSp[a].equals("implements") || a + 1 >= endSp.length) continue;
            this.classObj.setImplements(endSp[++a]);
        }
        ++this.rowCount;
        boolean inComment = false;
        while (this.rowCount < this.rows) {
            String[] split;
            String line = lines[this.rowCount];
            while (line.startsWith(" ")) {
                line = line.substring(1);
            }
            while (line.endsWith(" ")) {
                line = line.substring(0, line.length() - 1);
            }
            if (!endsWithBrack) {
                if (line.contains("{")) {
                    endsWithBrack = true;
                    ++this.rowCount;
                    continue;
                }
                ++this.rowCount;
                continue;
            }
            if (line.contains("//")) {
                line = line.split("//")[0];
            }
            if (!inComment) {
                if (line.contains("/*")) {
                    if (line.contains("*/")) {
                        inComment = false;
                        this.readClassLine(line.split("/*")[0], lines);
                        split = line.split(Pattern.quote("*/"));
                        if (split.length > 1) {
                            this.readClassLine(split[split.length - 1], lines);
                        }
                    } else {
                        inComment = true;
                    }
                } else {
                    if (this.rowCount == 42) {
                        // empty if block
                    }
                    this.readClassLine(line, lines);
                }
            } else if (line.contains("*/")) {
                inComment = false;
                split = line.split(Pattern.quote("*/"));
                if (split.length > 1) {
                    this.readClassLine(split[split.length - 1], lines);
                }
            }
            ++this.rowCount;
        }
    }

    private void readClassLine(String line, String[] lines) {
        while (line.startsWith(" ")) {
            line = line.substring(1);
        }
        while (line.endsWith(" ")) {
            line = line.substring(0, line.length() - 1);
        }
        if (!(line == null || "".equals(line) || line.startsWith("@") || line.startsWith("}"))) {
            if (line.contains("(") && !line.contains("=")) {
                MethodeObject meth = new MethodeObject();
                int row = 1;
                while (true) {
                    String l = lines[this.rowCount - row];
                    while (l.startsWith(" ")) {
                        l = l.substring(1);
                    }
                    while (l.endsWith(" ")) {
                        l = l.substring(0, l.length() - 1);
                    }
                    if (!l.startsWith("@")) break;
                    meth.getAnnotations().add(l);
                    --row;
                }
                String pre = line.split(Pattern.quote("("))[0];
                pre = pre.replace("     ", " ");
                pre = pre.replace("    ", " ");
                pre = pre.replace("   ", " ");
                pre = pre.replace("  ", " ");
                String[] preSplit = pre.split(" ");
                meth.setName(preSplit[preSplit.length - 1]);
                ArrayList<String> parts = new ArrayList<String>();
                if (preSplit.length >= 3) {
                    for (int a = 0; a < preSplit.length - 2; ++a) {
                        parts.add(preSplit[a]);
                    }
                }
                if (preSplit.length >= 2) {
                    String part = preSplit[preSplit.length - 2];
                    if (part.equals("public") || part.equals("private") || part.equals("protected")) {
                        meth.setType(null);
                        parts.add(part);
                    } else {
                        meth.setType(part);
                    }
                }
                meth.setPre(parts);
                String pars = line.split(Pattern.quote("("))[1];
                if (!pars.equals(")")) {
                    pars = pars.split(Pattern.quote(")"))[0];
                    while (pars.startsWith(" ")) {
                        pars = pars.substring(1);
                    }
                    while (pars.endsWith(" ")) {
                        pars = pars.substring(0, pars.length() - 1);
                    }
                    ArrayList<String> parsArray = new ArrayList<String>();
                    if (pars.contains(",")) {
                        String[] parmSplit;
                        for (String str : parmSplit = pars.split(",")) {
                            while (str.startsWith(" ")) {
                                str = str.substring(1);
                            }
                            while (str.endsWith(" ")) {
                                str = str.substring(0, str.length() - 1);
                            }
                            parsArray.add(str);
                        }
                        meth.setParms(parsArray);
                    } else if (!pars.equals("")) {
                        parsArray.add(pars);
                        meth.setParms(parsArray);
                    }
                }
                if (!line.endsWith("{")) {
                    while (this.rowCount < this.rows && !lines[this.rowCount].contains("{")) {
                        ++this.rowCount;
                    }
                }
                this.readMethode(meth);
                if (meth.getType() == null) {
                    this.classObj.getConstructor().add(meth);
                } else {
                    this.classObj.getMethodes().add(meth);
                }
            } else {
                VariableObject var = new VariableObject();
                int row = 1;
                while (true) {
                    String l = lines[this.rowCount - row];
                    while (l.startsWith(" ")) {
                        l = l.substring(1);
                    }
                    while (l.endsWith(" ")) {
                        l = l.substring(0, l.length() - 1);
                    }
                    if (!l.startsWith("@")) break;
                    var.getAnnotations().add(l);
                    --row;
                }
                if (line.contains("=")) {
                    String init = line.split("=")[1];
                    if (init.endsWith(";")) {
                        init = init.substring(0, init.length() - 1);
                    }
                    while (init.startsWith(" ")) {
                        init = init.substring(1);
                    }
                    while (init.endsWith(" ")) {
                        init = init.substring(0, init.length() - 1);
                    }
                    var.setInit(init);
                    line = line.split("=")[0];
                    while (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    while (line.endsWith(" ")) {
                        line = line.substring(0, line.length() - 1);
                    }
                } else {
                    if (line.endsWith(";")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    while (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    while (line.endsWith(" ")) {
                        line = line.substring(0, line.length() - 1);
                    }
                }
                line = line.replace("     ", " ");
                line = line.replace("    ", " ");
                line = line.replace("   ", " ");
                line = line.replace("  ", " ");
                String[] preSplit = line.split(" ");
                var.setName(preSplit[preSplit.length - 1]);
                ArrayList<String> parts = new ArrayList<String>();
                if (preSplit.length >= 3) {
                    for (int a = 0; a < preSplit.length - 2; ++a) {
                        parts.add(preSplit[a]);
                    }
                }
                if (preSplit.length >= 2) {
                    String part = preSplit[preSplit.length - 2];
                    var.setType(part);
                }
                var.setPre(parts);
                this.classObj.getVariables().add(var);
            }
        }
    }

    private void readMethode(MethodeObject meth) {
        String[] lines = this.text.split("\n");
        String mText = "";
        int count = 0;
        boolean broken = false;
        String l = lines[this.rowCount];
        String[] brackSplit = l.split(Pattern.quote("{"));
        String after = null;
        if (brackSplit.length > 1) {
            int a;
            for (a = 1; a < brackSplit.length; ++a) {
                after = after == null ? brackSplit[a] : after + "{" + brackSplit[a];
            }
            for (a = 0; a < after.length(); ++a) {
                String c = after.substring(a, a + 1);
                mText = mText + c;
                if (c.equals("{")) {
                    ++count;
                } else if (c.equals("}")) {
                    --count;
                }
                if (count < 0) {
                    broken = true;
                }
                if (broken) break;
            }
            if (broken) {
                meth.setCode(mText);
                return;
            }
            mText = mText + "\n";
            ++this.rowCount;
        } else {
            ++this.rowCount;
            mText = "\n";
        }
        while (this.rowCount < this.rows) {
            String line = lines[this.rowCount];
            for (int a = 0; a < line.length(); ++a) {
                String c = line.substring(a, a + 1);
                mText = mText + c;
                if (c.equals("{")) {
                    ++count;
                } else if (c.equals("}")) {
                    --count;
                }
                if (count < 0) {
                    broken = true;
                }
                if (broken) break;
            }
            if (broken) break;
            mText = mText + "\n";
            ++this.rowCount;
        }
        meth.setCode(mText);
    }

    public ClassObject getClassObject() {
        return this.classObj;
    }

    public void setClassObject(ClassObject classObj) {
        this.classObj = classObj;
    }

    public static void main(String[] args) throws Throwable {
        File root = new File("C:\\Program Files\\Deathly's Mod Editor\\MCP\\forge\\mcp\\src\\minecraft\\net\\minecraft\\client\\model");
        File out = new File("C:\\Program Files\\Deathly's Mod Editor\\MCP\\forge\\mcp\\src\\minecraft\\net\\minecraft\\client\\model2");
        out.mkdirs();
        File[] list = root.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!file.getName().endsWith(".java")) continue;
                ClassReader reader = new ClassReader(file);
                reader.analizeClass();
                ClassObject clas = reader.getClassObject();
                int i = clas.getName().length();
                String str = "";
                for (int a = 0; a < 21 - i; ++a) {
                    str = str + " ";
                }
                System.out.println(clas.getName() + str + " extends " + clas.getExtends());
                clas.setPackage("net.minecraft.client.model2");
                ClassWriter writer = new ClassWriter(out + "/" + file.getName());
                writer.writeClass(clas);
            }
        }
    }
}

