/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.modmaker.IO.ClassObject;
import net.modmaker.IO.MethodeObject;
import net.modmaker.IO.Settings;
import net.modmaker.IO.VariableObject;

public class ClassWriter {
    private final Writer writer;

    public ClassWriter(Writer writer) {
        this.writer = writer;
    }

    public ClassWriter(File file) throws IOException {
        this.writer = new FileWriter(file);
    }

    public ClassWriter(String fileName) throws IOException {
        this.writer = new FileWriter(fileName);
    }

    public void writeClass(ClassObject clas) throws IOException {
        this.writer.write("\n");
        if (clas.getPackage() != null) {
            this.writer.write("package " + clas.getPackage() + ";\n\n");
        }
        this.writer.write("/**\n * \n * @author " + Settings.getAuthor() + "\n" + " * \n" + " * This class is generated by Deathly's Mod Editor Version " + Settings.getVersion() + "\n" + " * Original Author: Deathlykiller\n" + " * \n" + " * Licence: All rights reserved\n" + " * \n" + " * See Planet Minecraft: http://www.planetminecraft.com/mod/mc-mod-editor-1494390\n" + " * See Minecraft Forums: http://www.minecraftforum.net/topic/1473653-deathlys-mod-editor\n" + " */\n\n");
        for (String im : clas.getImports()) {
            this.writer.write("import " + im + ";\n");
        }
        if (!clas.getImports().isEmpty()) {
            this.writer.write("\n");
        }
        for (String str : clas.getAnnotations()) {
            this.writer.write(str);
        }
        if (!clas.getAnnotations().isEmpty()) {
            this.writer.write("\n");
        }
        String typeClass = "";
        for (String str : clas.getPre()) {
            if (typeClass == "") {
                typeClass = str + " ";
                continue;
            }
            typeClass = typeClass + str + " ";
        }
        this.writer.write(typeClass + "class " + clas.getName() + (clas.getExtends() != null ? " extends " + clas.getExtends() : "") + (clas.getImplements() != null ? " implements " + clas.getImplements() : "") + "{\n");
        this.writer.write("\n");
        for (VariableObject var : clas.getVariables()) {
            this.writer.write("    " + var + ";\n");
        }
        if (!clas.getVariables().isEmpty()) {
            this.writer.write("\n");
        }
        for (MethodeObject con : clas.getConstructor()) {
            this.writer.write("    " + con + "\n");
        }
        for (MethodeObject con : clas.getMethodes()) {
            this.writer.write("    " + con + "\n");
        }
        this.writer.write("}");
        this.writer.close();
    }
}

