/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.modmaker.Console.Console;
import net.modmaker.IO.Settings;

public class FileManager {
    private static long count = 0L;

    public static void compress(File f, File files) throws IOException {
        Console.Info("Compress " + files.getName() + " to " + f.getName());
        files.mkdirs();
        f.getParentFile().mkdirs();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(f));
        ArrayList<File> dir = new ArrayList<File>();
        FileManager.ScanDir(files, dir);
        byte[] buffer = new byte[1024];
        int i = 0;
        for (int a = 0; a < dir.size(); ++a) {
            if (!dir.get(a).isFile()) continue;
            FileInputStream fis = new FileInputStream(dir.get(a));
            ZipEntry entry = new ZipEntry(dir.get(a).getPath().substring(files.getPath().length() + 1));
            zos.putNextEntry(entry);
            while ((i = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, i);
            }
            fis.close();
        }
        zos.close();
    }

    public static void Zip(File f, File workingDir) throws IOException {
        Console.Info("Compress " + workingDir.getName() + " to " + f.getName());
        if (!f.exists()) {
            throw new IOException("File doesn't Exists");
        }
        workingDir.mkdirs();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(workingDir.getPath() + "/" + f.getName() + ".zip"));
        ArrayList<File> dir = new ArrayList<File>();
        FileManager.ScanDir(f, dir);
        byte[] buffer = new byte[1024];
        int i = 0;
        for (int a = 0; a < dir.size(); ++a) {
            if (!dir.get(a).isFile()) continue;
            FileInputStream fis = new FileInputStream(dir.get(a));
            ZipEntry entry = new ZipEntry(dir.get(a).getPath().substring(f.getPath().length() + 1));
            zos.putNextEntry(entry);
            while ((i = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, i);
            }
            fis.close();
        }
        zos.close();
    }

    public static void Zip2(String files, String zip) throws IOException {
        Console.Info("Compress " + files + " to " + zip);
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zip));
            FileManager.zipDir(files, zos, "");
        }
        catch (Exception e) {
            Console.Err(e);
        }
        try {
            zos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void zipDir(String dir2zip, ZipOutputStream zos, String path) throws Exception {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                FileManager.zipDir(filePath, zos, path + f.getName() + "/");
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(path + f.getName());
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
        }
    }

    private static void ScanDir(File f, ArrayList<File> dir) {
        dir.add(f);
        if (f.isDirectory() && f.listFiles() != null) {
            for (File child : f.listFiles()) {
                FileManager.ScanDir(child, dir);
            }
        }
    }

    public static void UnZip(File f, File workingDir) throws Exception {
        Console.Info("Decompress " + workingDir.getName() + " to " + f.getName());
        ZipFile zip = new ZipFile(f);
        Enumeration<? extends ZipEntry> ee = zip.entries();
        byte[] buffer = new byte[1024];
        boolean i = false;
        workingDir.mkdirs();
        while (ee.hasMoreElements()) {
            ZipEntry entry = ee.nextElement();
            if (entry.isDirectory()) {
                new File(workingDir.getPath() + "/" + entry.getName()).mkdirs();
                continue;
            }
            File out = new File(workingDir.getPath() + "/" + entry.getName());
            out.getAbsoluteFile().getParentFile().mkdirs();
            try {
                FileManager.extractFile(zip.getInputStream(entry), new FileOutputStream(out));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        zip.close();
    }

    private static void extractFile(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = in.read(buffer)) >= 0) {
            out.write(buffer, 0, i);
        }
        in.close();
        out.close();
    }

    public static void Copy(File f1, File f2) throws IOException {
        if (f1.isDirectory()) {
            for (File f : f1.listFiles()) {
                FileManager.Copy(f, new File(f2.getPath() + "/" + f.getName()));
            }
        } else {
            f2.getParentFile().mkdirs();
            f2.delete();
            FileInputStream fis = new FileInputStream(f1);
            FileOutputStream fos = new FileOutputStream(f2);
            try {
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static void Delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileManager.Delete(f);
            }
            file.delete();
        } else if (file.isFile()) {
            file.delete();
        }
    }

    public static void extractFromResources(String url, File f) throws IOException {
        Console.Info("Extract from resources: " + f.getName());
        byte[] buffer = new byte[1024];
        int i = 0;
        f.getParentFile().mkdirs();
        InputStream in = new Object().getClass().getResourceAsStream(url);
        if (in == null) {
            throw new IOException("Could not extract from resources: " + url);
        }
        FileOutputStream out = new FileOutputStream(f);
        while ((i = in.read(buffer)) > -1) {
            out.write(buffer, 0, i);
        }
        in.close();
        out.close();
    }

    public static void addToJar(File jar, File dir) throws Exception {
        String line;
        Console.Info("Add " + dir.getName() + " to " + jar.getName());
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(dir);
        ArrayList<String> args = new ArrayList<String>();
        args.add(Settings.getJdkRoot().getParent() + "/jar.exe");
        args.add("uf");
        args.add(jar.getAbsolutePath());
        args.add("*");
        pb.command(args);
        final Process p = pb.start();
        BufferedReader bf = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader bf = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    while ((line = bf.readLine()) != null) {
                        Console.Info("    " + line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        while ((line = bf.readLine()) != null) {
            Console.Info("    " + line);
        }
    }

    public static boolean compareTwoFiles(File f1, File f2) {
        try {
            String l2;
            String l1;
            BufferedReader bf1 = new BufferedReader(new InputStreamReader(new FileInputStream(f1)));
            BufferedReader bf2 = new BufferedReader(new InputStreamReader(new FileInputStream(f2)));
            do {
                l1 = bf1.readLine();
                l2 = bf2.readLine();
                if (l1 == null) {
                    return l2 == null;
                }
                if (l2 != null) continue;
                return l1 == null;
            } while (l1.equals(l2));
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void Move(File f1, File f2) {
        if (f1.isDirectory()) {
            for (File f : f1.listFiles()) {
                FileManager.Move(f, new File(f2.getPath() + "/" + f.getName()));
            }
        } else {
            f2.getParentFile().mkdirs();
            f2.delete();
            f1.renameTo(f2);
        }
    }

    public static File getTempFile() {
        File temp = new File(Settings.getRoot() + "/temp/files/temp" + count + ".tmp");
        ++count;
        temp.getParentFile().mkdirs();
        return temp;
    }
}

