/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Export.Export;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.IO.Settings;
import net.modmaker.IO.WorkingDirectory;
import net.modmaker.MinecraftEvents.ActionBase;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.DropData;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginManager;
import net.modmaker.plugin.SaveBase;

public class SaveManager {
    private static ArrayList<File> modPaths = new ArrayList();

    public static void loadConfig() throws Exception {
        modPaths.clear();
        File saveFile = new File(Settings.getRoot() + "/Config.cfg");
        if (saveFile.exists()) {
            String line;
            BufferedReader bf = new BufferedReader(new FileReader(saveFile));
            boolean newCfg = false;
            while ((line = bf.readLine()) != null) {
                try {
                    if (newCfg) {
                        String[] split;
                        if (line.startsWith("Workbench:")) {
                            while ((line = bf.readLine()) != null) {
                                try {
                                    if (line == null || !line.startsWith("Mod:")) continue;
                                    modPaths.add(new File(line.substring("Mod:".length())));
                                }
                                catch (Exception e) {
                                    Console.Err(e);
                                }
                            }
                            continue;
                        }
                        if (!line.contains(":") || (split = line.split(":")).length <= 1) continue;
                        String value = null;
                        for (int a = 1; a < split.length; ++a) {
                            value = value == null ? split[a] : value + ":" + split[a];
                        }
                        Settings.put(split[0], value);
                        continue;
                    }
                    if (line.startsWith("Deathly's Mod Editor Config File: ")) {
                        newCfg = true;
                        continue;
                    }
                    if (line.startsWith("Author:")) {
                        Settings.setAuthor(line.substring("Author:".length()));
                        continue;
                    }
                    if (line.startsWith("Cd:")) {
                        Settings.setCurrentDirectory(new File(line.substring("Cd:".length())));
                        continue;
                    }
                    if (line.startsWith("Installed:")) {
                        Settings.setInstalled(Boolean.parseBoolean(line.substring("Installed:".length())));
                        continue;
                    }
                    if (line.startsWith("LastCompiledModName:")) {
                        Export.setOldMod(line.substring("LastCompiledModName:".length()));
                        Console.Info("Last compiled: " + Export.getOldMod());
                        continue;
                    }
                    if (line.startsWith("AddPlugin:")) {
                        Settings.put("modmaker.plugins.add", line.substring("AddPlugin:".length()));
                        continue;
                    }
                    if (line.startsWith("IgnorePlugin:")) {
                        Settings.put("modmaker.plugins.ignore", line.substring("IgnorePlugin:".length()));
                        continue;
                    }
                    if (!line.startsWith("Workbench:")) continue;
                    while ((line = bf.readLine()) != null) {
                        try {
                            if (line == null || !line.startsWith("Mod:")) continue;
                            modPaths.add(new File(line.substring("Mod:".length())));
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                    }
                }
                catch (Exception e) {
                    Console.Err(e);
                }
            }
            bf.close();
        }
    }

    public static void saveConfig() throws Exception {
        File saveFile = new File(Settings.getRoot() + "/Config.cfg");
        SaveManager.saveConfig(saveFile);
    }

    public static void saveConfig(File saveFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));
        writer.write("Deathly's Mod Editor Config File: " + Settings.getVersion());
        writer.newLine();
        for (Map.Entry pairs : Settings.getMap().entrySet()) {
            if (pairs.getKey().toString().startsWith("modmaker.runtime") || pairs.getKey().toString().startsWith("modmaker.uptodate")) continue;
            writer.write(pairs.getKey() + ":" + pairs.getValue());
            writer.newLine();
        }
        writer.write("Workbench:");
        writer.newLine();
        for (ModManager mod : ModManager.mods) {
            if (mod.getMod().saveFile == null) {
                mod.getMod().saveFile = new File(Settings.getRoot() + "/Save/" + mod.getMod().name + ".DME");
            }
            writer.write("Mod:" + mod.getMod().saveFile.getPath());
            writer.newLine();
        }
        writer.close();
    }

    public static void loadAllMods() throws Exception {
        for (File file : modPaths) {
            try {
                Mod mod = SaveManager.loadMod(file);
                if (mod == null) {
                    return;
                }
                new ModManager(mod);
            }
            catch (Throwable e) {
                Console.Warning("Failed to load mod: " + file.getName());
                e.printStackTrace();
            }
        }
    }

    public static Mod loadMod(File file) throws Exception {
        String line;
        Mod mod = new Mod();
        mod.saveFile = file;
        BufferedReader bf = new BufferedReader(new FileReader(file));
        if (mod.saveFile.getName().endsWith(".MMSaveFile")) {
            mod.saveFile = new File(Settings.getRoot() + "/Save/" + mod.saveFile.getName().substring(0, mod.saveFile.getName().length() - ".MMSaveFile".length()) + ".DME");
            BufferedWriter writer = new BufferedWriter(new FileWriter(mod.saveFile));
            int state = 0;
            while ((line = bf.readLine()) != null) {
                if (line.equals("Blocks{")) {
                    line = "Block{";
                } else if (line.equals("Items{")) {
                    line = "Item{";
                } else if (line.equals("ToolMaterial{")) {
                    line = "Tool Material{";
                } else if (line.equals("ArmorMaterial{")) {
                    line = "Armor Material{";
                } else if (line.equals("Recipes{")) {
                    line = "Recipes{";
                } else if (line.equals("Smeltings{")) {
                    line = "Smelting{";
                } else if (line.equals("        Tools{")) {
                    line = "";
                    ++state;
                } else if (line.equals("        }") && state > 0) {
                    --state;
                    line = "";
                }
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
            bf.close();
            bf = new BufferedReader(new FileReader(mod.saveFile));
        }
        block5: while ((line = bf.readLine()) != null) {
            if (line.startsWith("Name:")) {
                mod.name = line.substring("Name:".length());
                continue;
            }
            if (line.startsWith("Version:")) {
                mod.version = line.substring("Version:".length());
                continue;
            }
            if (line.startsWith("Credits:")) {
                mod.credits = line.substring("Credits:".length());
                continue;
            }
            if (line.startsWith("LogoImage:")) {
                mod.logoFile = new BufferedImageSeri(line.substring("LogoImage:".length()));
                continue;
            }
            if (line.startsWith("Logo:")) {
                if ("".equals(line)) continue;
                try {
                    BufferedImage image = ImageIO.read(new File(line.substring("Logo".length())));
                    mod.logoFile = new BufferedImageSeri(image);
                }
                catch (Throwable e) {
                    Console.Warning("Unable to load " + mod.name + " Logo");
                }
                continue;
            }
            if (line.startsWith("Url:")) {
                mod.url = line.substring("Url:".length());
                continue;
            }
            if (line.startsWith("Description:")) {
                mod.description = line.substring("Description:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCclientImports:")) {
                mod.CCclientImports = line.substring("CCclientImports:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCclientMethodes:")) {
                mod.CCclientMethodes = line.substring("CCclientMethodes:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCclientRI:")) {
                mod.CCclientRI = line.substring("CCclientRI:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCimports:")) {
                mod.CCimports = line.substring("CCimports:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCload:")) {
                mod.CCload = line.substring("CCload:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCmethode:")) {
                mod.CCmethode = line.substring("CCmethode:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCpreLoad:")) {
                mod.CCpreLoad = line.substring("CCpreLoad:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCserverImports:")) {
                mod.CCserverImports = line.substring("CCserverImports:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCserverRI:")) {
                mod.CCserverRI = line.substring("CCserverRI:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCserverMethodes:")) {
                mod.CCserverMethodes = line.substring("CCserverMethodes:".length()).replace("<br>", "\n");
                continue;
            }
            if (line.startsWith("CCserverVars:")) {
                mod.CCserverVars = line.substring("CCserverVars:".length()).replace("<br>", "\n");
                continue;
            }
            if (!line.endsWith("{")) continue;
            String pluginName = line.substring(0, line.length() - 1);
            Plugin plugin = PluginManager.getPlugin(pluginName);
            if (plugin != null) {
                int state = 0;
                while ((line = SaveManager.removeSpaces(bf.readLine())) != null) {
                    if (line.startsWith("}")) {
                        if (state <= 0) continue block5;
                        state = 0;
                    }
                    if (line.startsWith("Armor{")) {
                        state = 1;
                        continue;
                    }
                    if (line.startsWith("Tools{")) {
                        state = 1;
                        continue;
                    }
                    if (!SaveManager.removeSpaces(line).equals("{")) continue;
                    SaveBase sb = plugin.getSaveBase(mod);
                    while (!(line = SaveManager.removeSpaces(bf.readLine())).equals("}")) {
                        try {
                            if (line.equals("{")) {
                                SaveManager.loadChild(bf, sb);
                                continue;
                            }
                            if (line.equals("Events{")) {
                                SaveManager.loadEvents(sb, bf);
                                continue;
                            }
                            if (line.equals("Drops{")) {
                                SaveManager.loadDrops(sb, bf);
                                continue;
                            }
                            if (line.equals("RareDrops{")) {
                                SaveManager.loadRareDrops(sb, bf);
                                continue;
                            }
                            if (line.startsWith("DropItSelf:")) {
                                sb.setDropItself(Boolean.parseBoolean(line.substring("DropItSelf:".length())));
                                continue;
                            }
                            sb.Load(line);
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                    }
                    mod.object.add(sb);
                }
                continue;
            }
            String text = pluginName + "{";
            int count = 1;
            boolean brk = false;
            while ((line = SaveManager.removeSpaces(bf.readLine())) != null) {
                for (int a = 0; a < line.length() - 1; ++a) {
                    String ch = line.substring(a, a + 1);
                    text = text + ch;
                    if (ch.equals("{")) {
                        ++count;
                    }
                    if (ch.equals("}")) {
                        --count;
                    }
                    if (count != 0) continue;
                    brk = true;
                    break;
                }
                if (brk) break;
                text = text + "\n";
            }
            mod.unknown.add(text);
            if ("".equals(SaveManager.removeSpaces(pluginName)) || pluginName == null) continue;
            Console.Warning("Unknown Plugin:" + pluginName);
        }
        mod.triggerInitializedEvent();
        for (ModManager manager : ModManager.mods) {
            if (!manager.getMod().name.equalsIgnoreCase(mod.name)) continue;
            Console.Warning("Mod: " + mod.name + " Already loaded!");
            return null;
        }
        Console.Info("Loaded mod: " + mod.name);
        return mod;
    }

    private static void loadChild(BufferedReader bf, SaveBase sb) throws Exception {
        String line;
        SaveBase child = sb.getNewChild();
        sb.addChild(child);
        while (!(line = SaveManager.removeSpaces(bf.readLine())).equals("}")) {
            try {
                if (line.equals("{")) {
                    SaveManager.loadChild(bf, child);
                    continue;
                }
                if (line.equals("Events{")) {
                    SaveManager.loadEvents(child, bf);
                    continue;
                }
                if (line.equals("Drops{")) {
                    SaveManager.loadDrops(child, bf);
                    continue;
                }
                if (line.equals("RareDrops{")) {
                    SaveManager.loadRareDrops(child, bf);
                    continue;
                }
                if (line.startsWith("DropItSelf:")) {
                    child.setDropItself(Boolean.parseBoolean(line.substring("DropItSelf:".length())));
                    continue;
                }
                child.Load(line);
            }
            catch (Exception e) {
                Console.Err(e);
            }
        }
        sb.getNewChildPanel(child);
    }

    public static String removeSpaces(String line) {
        if (line != null) {
            while (line.startsWith(" ")) {
                line = line.substring(1);
            }
            while (line.endsWith(" ")) {
                line = line.substring(0, line.length() - 1);
            }
        }
        return line;
    }

    public static File saveMod(ModManager manager) throws IOException {
        Console.Info("Start saveing");
        Mod mod = manager.getMod();
        manager.Save();
        if (mod.saveFile == null) {
            mod.saveFile = new File(Settings.getRoot() + "/Save/" + mod.name + ".DME");
        }
        mod.saveFile.getParentFile().mkdirs();
        BufWriter bf = new BufWriter(new FileWriter(mod.saveFile));
        bf.writeLine("Deathly's Mod Editor V" + Settings.getVersion());
        bf.writeLine("Name:" + mod.name);
        if (mod.version != null) {
            bf.writeLine("Version:" + mod.version);
        }
        if (mod.credits != null) {
            bf.writeLine("Credits:" + mod.credits);
        }
        if (mod.logoFile != null) {
            bf.writeLine("LogoImage:" + mod.logoFile.toString());
        }
        if (mod.url != null) {
            bf.writeLine("Url:" + mod.url);
        }
        if (mod.description != null) {
            bf.writeLine("Description:" + mod.description.replace("\n", "<br>"));
        }
        if (mod.CCimports != null) {
            bf.writeLine("CCimports:" + mod.CCclientImports.replace("\n", "<br>"));
        }
        if (mod.CCload != null) {
            bf.writeLine("CCload:" + mod.CCload.replace("\n", "<br>"));
        }
        if (mod.CCpreLoad != null) {
            bf.writeLine("CCpreLoad:" + mod.CCpreLoad.replace("\n", "<br>"));
        }
        if (mod.CCmethode != null) {
            bf.writeLine("CCmethode:" + mod.CCmethode.replace("\n", "<br>"));
        }
        if (mod.CCclientImports != null) {
            bf.writeLine("CCclientImports:" + mod.CCclientImports.replace("\n", "<br>"));
        }
        if (mod.CCclientMethodes != null) {
            bf.writeLine("CCclientMethodes:" + mod.CCclientMethodes.replace("\n", "<br>"));
        }
        if (mod.CCclientRI != null) {
            bf.writeLine("CCclientRI:" + mod.CCclientRI.replace("\n", "<br>"));
        }
        if (mod.CCserverImports != null) {
            bf.writeLine("CCserverImports:" + mod.CCserverImports.replace("\n", "<br>"));
        }
        if (mod.CCserverMethodes != null) {
            bf.writeLine("CCserverMethodes:" + mod.CCserverMethodes.replace("\n", "<br>"));
        }
        if (mod.CCserverRI != null) {
            bf.writeLine("CCserverRI:" + mod.CCserverRI.replace("\n", "<br>"));
        }
        if (mod.CCserverVars != null) {
            bf.writeLine("CCserverVars:" + mod.CCserverVars.replace("\n", "<br>"));
        }
        for (Plugin plugin : PluginManager.getPlugins()) {
            bf.writeLine(plugin.getName() + "{");
            for (SaveBase sb : mod.object) {
                if (!sb.getPlugin().getName().equals(plugin.getName())) continue;
                bf.setPrefix("    ");
                bf.writeLine("{");
                bf.setPrefix("        ");
                try {
                    sb.Save(bf);
                }
                catch (Exception e) {
                    Console.Err(e);
                }
                SaveManager.saveDrops(sb, bf);
                SaveManager.saveEvents(sb, bf);
                SaveManager.saveChild(sb, bf);
                bf.setPrefix("    ");
                bf.writeLine("}");
                bf.setPrefix("");
            }
            bf.setPrefix("");
            bf.writeLine("}");
        }
        for (String text : mod.unknown) {
            if (text.contains("\n")) {
                String[] split;
                for (String str : split = text.split("\n")) {
                    bf.writeLine(str);
                    bf.newLine();
                }
                continue;
            }
            bf.writeLine(text);
            bf.newLine();
        }
        bf.close();
        Console.Info("Save mod: " + mod.name);
        return mod.saveFile;
    }

    private static void saveChild(SaveBase sb, BufWriter bf) throws IOException {
        for (SaveBase child : sb.getChildren()) {
            bf.writeLine("{");
            bf.setPrefix(bf.prefix + "    ");
            try {
                child.Save(bf);
            }
            catch (Exception e) {
                Console.Err(e);
            }
            SaveManager.saveDrops(child, bf);
            SaveManager.saveEvents(child, bf);
            SaveManager.saveChild(child, bf);
            bf.setPrefix(bf.prefix.substring(0, bf.prefix.length() - 4));
            bf.writeLine("}");
        }
    }

    public static Mod loadMod() throws Exception {
        File file = FileChooser.showDialog(Settings.getRoot() + "/Save", FileChooser.OPEN_DIALOG, 0, 0);
        if (file != null) {
            return SaveManager.loadMod(file);
        }
        return null;
    }

    private static void saveEvents(SaveBase sb, BufWriter bf) throws IOException {
        if (sb.getEvents() != null && !sb.getEvents().isEmpty()) {
            bf.writeLine("Events{");
            bf.setPrefix(bf.getPrefix() + "    ");
            for (EventBase event : sb.getEvents()) {
                if (event == null || event.getActionSize() <= 0) continue;
                bf.writeLine(event.getName() + "{");
                bf.setPrefix(bf.getPrefix() + "    ");
                for (int a = 0; a < event.getActionSize(); ++a) {
                    bf.writeLine(event.getAction(a).toString());
                }
                bf.setPrefix(bf.getPrefix().substring(4));
                bf.writeLine("}");
            }
            bf.setPrefix(bf.getPrefix().substring(4));
            bf.writeLine("}");
        }
    }

    private static void loadEvents(SaveBase sb, BufferedReader bf) throws Exception {
        String line;
        ArrayList<EventBase> events = sb.getEvents();
        block0: while ((line = bf.readLine()) != null && !(line = SaveManager.removeSpaces(line)).equals("}")) {
            if (!line.endsWith("{")) continue;
            int state = 1;
            String eventName = line.substring(0, line.length() - 1);
            EventBase event = null;
            for (EventBase eb : sb.getEvents()) {
                if (!eb.getName().equals(eventName)) continue;
                event = eb;
            }
            if (event != null) {
                while ((line = bf.readLine()) != null) {
                    if ((line = SaveManager.removeSpaces(line)).contains("}")) {
                        --state;
                    }
                    if (line.contains("{")) {
                        ++state;
                    }
                    if (state == 0) continue block0;
                    ActionBase action = ActionBase.getActionBase(line);
                    if (action != null) {
                        event.addAction(action);
                        continue;
                    }
                    Console.Warning("Unknown Action: " + line + " at " + sb.getName() + " at " + event.getName() + " event");
                }
                continue;
            }
            Console.Warning("Unknown event: " + eventName + " at " + sb.getName());
            while ((line = bf.readLine()) != null) {
                if ((line = SaveManager.removeSpaces(line)).contains("}")) {
                    --state;
                }
                if (line.contains("{")) {
                    ++state;
                }
                if (state != 0) continue;
                continue block0;
            }
        }
        sb.setEvents(events);
    }

    private static void loadDrops(SaveBase sb, BufferedReader bf) throws IOException {
        String line;
        ArrayList<DropData> drops = new ArrayList<DropData>();
        while ((line = bf.readLine()) != null && !(line = SaveManager.removeSpaces(line)).equals("}")) {
            DropData dd = new DropData(line, sb.getMod());
            drops.add(dd);
        }
        sb.setDrops(drops);
    }

    private static void loadRareDrops(SaveBase sb, BufferedReader bf) throws IOException {
        String line;
        ArrayList<DropData> rareDrops = new ArrayList<DropData>();
        while ((line = bf.readLine()) != null && !(line = SaveManager.removeSpaces(line)).equals("}")) {
            DropData dd = new DropData(line, sb.getMod());
            rareDrops.add(dd);
        }
        sb.setRareDrops(rareDrops);
    }

    private static void saveDrops(SaveBase child, BufWriter bf) throws IOException {
        bf.writeLine("DropItSelf:" + child.dropItself());
        if (!child.getDrops().isEmpty()) {
            bf.writeLine("Drops{");
            bf.setPrefix(bf.getPrefix() + "    ");
            for (DropData dd : child.getDrops()) {
                bf.writeLine(dd.toString());
            }
            bf.setPrefix(bf.getPrefix().substring(4));
            bf.writeLine("}");
        }
        if (!child.getRareDrops().isEmpty()) {
            bf.writeLine("RareDrops{");
            bf.setPrefix(bf.getPrefix() + "    ");
            for (DropData dd : child.getRareDrops()) {
                bf.writeLine(dd.toString());
            }
            bf.setPrefix(bf.getPrefix().substring(4));
            bf.writeLine("}");
        }
    }

    public static void loadLaunchConfig() {
        File configFile = new File(WorkingDirectory.getDefaultWorkingDirectory() + "/installdata.dat");
        SaveManager.loadLaunchConfig(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadLaunchConfig(File configFile) {
        Console.Info("Load Settings");
        if (configFile != null) {
            if (configFile.exists() && configFile.isFile()) {
                BufferedReader bf = null;
                try {
                    String line;
                    bf = new BufferedReader(new FileReader(configFile));
                    int count = 0;
                    while ((line = bf.readLine()) != null) {
                        try {
                            if (count == 0) {
                                Settings.put("modmaker.runtime.programroot", line);
                            } else if (line.startsWith("Args:")) {
                                Settings.put("modmaker.runtime.args", line.substring("Args:".length()));
                            } else if (line.startsWith("Options:")) {
                                Settings.put("modmaker.runtime.options", line.substring("Options:".length()));
                            } else if (line.startsWith("showConsole:")) {
                                Settings.put("modmaker.runtime.showconsole", line.substring("showConsole:".length()));
                            } else if (line.startsWith("showLauncher:")) {
                                Settings.put("modmaker.runtime.showlauncher", line.substring("showLauncher:".length()));
                            } else {
                                Console.Warning("Reading Config file: ignore line " + count);
                            }
                        }
                        catch (Throwable e) {
                            Console.Warning("Reading Config file: error line " + count);
                        }
                        ++count;
                    }
                    if (count != 0) return;
                    Console.Warning("Config file is empty");
                    return;
                }
                catch (Throwable e) {
                    Console.Warning("Error while reading Config file");
                    Console.Err(e);
                    return;
                }
                finally {
                    if (bf != null) {
                        try {
                            bf.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            Console.Warning("Config file doesn't exists");
            return;
        }
        Console.Warning("Config file == null");
    }

    public static void loadUpdateData() {
        try {
            File upToDate = new File(Settings.getRoot() + "/UpToDate.ini");
            if (upToDate.exists() && upToDate.isFile()) {
                int version;
                BufferedReader reader = new BufferedReader(new FileReader(upToDate));
                String line = reader.readLine();
                boolean n = false;
                if (line != null && line.startsWith("uptodate:") && (version = Integer.parseInt(line.substring("uptodate:".length()))) >= 5) {
                    n = true;
                }
                if (n) {
                    String plugins = "";
                    String libs = "";
                    String nat = "";
                    while ((line = reader.readLine()) != null) {
                        String[] split;
                        if (!line.contains(":") || (split = line.split(":")).length < 2) continue;
                        String value = split[1];
                        if (split.length > 2) {
                            value = value + ":" + split[2];
                        }
                        Settings.put("modmaker.uptodate." + split[0], value);
                        if (split[0].startsWith("plugins.")) {
                            plugins = plugins + split[0].substring("plugins.".length()) + ";";
                            continue;
                        }
                        if (split[0].startsWith("lib.native.")) {
                            if (!split[0].startsWith("lib.native." + WorkingDirectory.getPlatform().toString().toLowerCase())) continue;
                            nat = nat + split[0].substring(("lib.native." + WorkingDirectory.getPlatform().toString()).length() + 1) + ";";
                            continue;
                        }
                        if (!split[0].startsWith("lib.")) continue;
                        libs = libs + split[0].substring("lib.".length()) + ";";
                    }
                    Settings.put("modmaker.uptodate.plugins.data", plugins);
                    Settings.put("modmaker.uptodate.lib.data", libs);
                    Settings.put("modmaker.uptodate.lib.native.data", nat);
                }
                reader.close();
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public static void saveAllMods() throws IOException {
        for (ModManager manager : ModManager.mods) {
            SaveManager.saveMod(manager);
        }
    }

    public static class BufWriter
    extends BufferedWriter {
        private String prefix;

        public BufWriter(Writer w) {
            super(w);
        }

        public BufWriter(Writer w, int i) {
            super(w, i);
        }

        public void writeLine(String line) throws IOException {
            if (this.prefix != null) {
                line = this.prefix + line;
            }
            this.write(line);
            this.newLine();
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

