/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.MainPanel;
import net.modmaker.IO.DownloadManager;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.IO.Task;
import net.modmaker.IO.WorkingDirectory;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.Utils.Urls;
import net.modmaker.events.Listeners.SetupListener;

public class SetupManager {
    private static ArrayList<Task> tasks = new ArrayList();
    private static ArrayList<SetupListener> listeners = new ArrayList();

    public static void addTask(Task task, int i) {
        tasks.add(i, task);
    }

    public static void addTask(Task task) {
        tasks.add(task);
    }

    public static void removeTask(Task task) {
        for (int a = 0; a < tasks.size(); ++a) {
            if (!tasks.get(a).getName().equals(task.getName())) continue;
            tasks.remove(a);
        }
    }

    public static void removeTask(int i) {
        tasks.remove(i);
    }

    public static ArrayList<Task> getAllTasks() {
        return tasks;
    }

    public static Task getTask(int i) {
        return tasks.get(i);
    }

    public static void addSetupListener(SetupListener sl) {
        listeners.add(sl);
    }

    public static void removeSetupListener(SetupListener sl) {
        listeners.remove(sl);
    }

    public static ArrayList<SetupListener> getSetupListeners() {
        return listeners;
    }

    public static void runSetup() {
        block6: {
            if (!Settings.isCheckForUpdates()) {
                OptionPane.showMessageDialog(Settings.getFrame(), "You need to enable updates in the arguments\nin order to download and install mcp", "Updates are disabled!", 2);
            } else if (Urls.MCFORGE.getUrlAsString() == null) {
                OptionPane.showMessageDialog(Settings.getFrame(), "Unable to find mc forge download url", "Unknown mc forge url", 2);
            } else {
                MainPanel.setInstalled(true);
                Thread setup = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Settings.setInstalled(false);
                            boolean error = false;
                            for (Task task : tasks) {
                                try {
                                    Console.Info(task.getName());
                                    MainPanel.setProgress(task.getName(), 0);
                                    task.Run();
                                }
                                catch (Throwable e) {
                                    error = true;
                                    Console.Err(e);
                                    MainPanel.setInstalled(false);
                                    MainPanel.setIndeterminate(false);
                                    OptionPane.showMessageDialog(Settings.getFrame(), "An Error occured while installing MCP:\n\n" + task.getName(), "Error", 0);
                                    break;
                                }
                            }
                            MainPanel.setIndeterminate(false);
                            if (!error) {
                                Settings.setInstalled(true);
                                MainPanel.setProgress("MCP Installation Complete!", 100);
                                Console.Info("MCP Installation Complete!");
                                OptionPane.showMessageDialog(Settings.getFrame(), "MCP installation is complete!", "Complete", 1);
                                for (SetupListener sl : listeners) {
                                    try {
                                        sl.onMcpInstalled();
                                    }
                                    catch (Throwable e) {
                                        Console.Err(e);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Console.Err(e);
                        }
                        ThreadManager.removeThread("Minecraft Coder Pack Setup");
                    }
                });
                try {
                    ThreadManager.addThread(setup, "Minecraft Coder Pack Setup");
                    setup.start();
                }
                catch (Throwable e) {
                    Console.Warning(e.getMessage());
                    if (!e.getMessage().equals("Thread is already running")) break block6;
                    OptionPane.showMessageDialog(Settings.getFrame(), "Mcp is already installing ...", "Mcp setup!", 2);
                }
            }
        }
    }

    public static void loadSetup() {
        SetupManager.addTask(new Task("Cleaning MCP folder"){

            @Override
            public void Run() throws Exception {
                MainPanel.setIndeterminate(true);
                FileManager.Delete(new File(Settings.getRoot() + "/MCP"));
                MainPanel.setIndeterminate(false);
            }
        });
        SetupManager.addTask(new Task("Download Minecraft Forge"){

            @Override
            public void Run() throws Throwable {
                if (Urls.MCFORGE.getURL() == null) {
                    throw new Exception("");
                }
                DownloadManager.DownloadtoFile(Urls.MCFORGE.getURL(), new File(Settings.getRoot() + "/temp/MC forge.zip"));
            }
        });
        SetupManager.addTask(new Task("Extract Minecraft Forge"){

            @Override
            public void Run() throws Exception {
                FileManager.UnZip(new File(Settings.getRoot() + "/temp/MC forge.zip"), new File(Settings.getRoot() + "/MCP"));
            }
        });
        SetupManager.addTask(new Task("Check version"){

            @Override
            public void Run() throws Exception {
                String line;
                File version = new File(Settings.getRoot() + "/MCP/forge/fml/conf/version.cfg");
                BufferedReader bf = new BufferedReader(new FileReader(version));
                String MCPVersion = null;
                String ClientVersion = null;
                String ServerVersion = null;
                while ((line = bf.readLine()) != null) {
                    try {
                        if (line.startsWith("MCPVersion = ")) {
                            MCPVersion = line.substring("MCPVersion = ".length());
                            continue;
                        }
                        if (line.startsWith("ClientVersion = ")) {
                            ClientVersion = line.substring("ClientVersion = ".length());
                            continue;
                        }
                        if (!line.startsWith("ServerVersion = ")) continue;
                        ServerVersion = line.substring("ServerVersion = ".length());
                    }
                    catch (Throwable e) {
                        Console.Warning("Error while reading mcp versions");
                        Console.Warning(e.getMessage());
                    }
                }
                if (MCPVersion == null) {
                    Console.Warning("Unknown MCP version!");
                    int result = OptionPane.showConfirmDialog(Settings.getFrame(), "Unknown MCP version!\n\nDo you want to continue?", "Unknown MCP version!", 0, 2);
                    if (result != 0) {
                        throw new Exception("Wrong MCP version: " + MCPVersion + ", supported: " + Settings.getMCPVersion());
                    }
                }
                if (ClientVersion == null) {
                    Console.Warning("Unknown Minecraft Client version!");
                    int result = OptionPane.showConfirmDialog(Settings.getFrame(), "Unknown Minecraf Client version!\n\nDo you want to continue?", "Unknown Minecraf Client version!", 0, 2);
                    if (result != 0) {
                        throw new Exception("Wrong Minecraft Client version: " + ClientVersion + ", supported: " + Settings.getMinecraftVersion());
                    }
                }
                if (ServerVersion == null) {
                    Console.Warning("Unknown Minecraft Server version!");
                    int result = OptionPane.showConfirmDialog(Settings.getFrame(), "Unknown Minecraft Server version!\n\nDo you want to continue?", "Unknown Minecraft Server version!", 0, 2);
                    if (result != 0) {
                        throw new Exception("Wrong Minecraft Server version: " + ServerVersion + ", supported: " + Settings.getMinecraftVersion());
                    }
                }
                if (!MCPVersion.equals(Settings.getMCPVersion())) {
                    throw new Exception("Wrong MCP version: " + MCPVersion + ", supported: " + Settings.getMCPVersion());
                }
                if (!ClientVersion.equals(Settings.getMinecraftVersion())) {
                    throw new Exception("Wrong Minecraft Client version: " + ClientVersion + ", supported: " + Settings.getMinecraftVersion());
                }
                if (!ServerVersion.equals(Settings.getMinecraftVersion())) {
                    throw new Exception("Wrong Minecraft Server version: " + ServerVersion + ", supported: " + Settings.getMinecraftVersion());
                }
            }
        });
        SetupManager.addTask(new Task("Decompile Minecraft"){

            @Override
            public void Run() throws Exception {
                String line;
                MainPanel.setIndeterminate(true);
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                File dir = new File(Settings.getRoot() + "/MCP/forge");
                dir.getParentFile().mkdirs();
                pb.directory(dir);
                ArrayList<String> args = new ArrayList<String>();
                if (WorkingDirectory.getPlatform().equals((Object)WorkingDirectory.OS.WINDOWS)) {
                    args.add(dir.getPath() + "/fml/python/python_fml.exe");
                    args.add("install.py");
                } else if (WorkingDirectory.getPlatform().equals((Object)WorkingDirectory.OS.MAC)) {
                    args.add("python");
                    args.add("install.py");
                }
                pb.command(args);
                Process p = pb.start();
                final BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                final BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                Thread MCP_input = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                Console.Script(line);
                            }
                        }
                        catch (IOException ex) {
                            Console.Err(ex);
                        }
                    }
                });
                Thread MCP_output = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            bw.write("Yes");
                            bw.newLine();
                            bw.write("Yes");
                            bw.newLine();
                        }
                        catch (Throwable e) {
                            Console.Err(e);
                        }
                        ThreadManager.removeThread("MCP_Output");
                    }
                });
                ThreadManager.addThread(MCP_input, "MCP InputStreamReader");
                ThreadManager.addThread(MCP_output, "MCP OutputStreamWriter");
                MCP_input.start();
                MCP_output.start();
                long startTime = System.currentTimeMillis();
                BufferedReader out = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = out.readLine()) != null) {
                    if (line.contains("Exception")) {
                        throw new Exception("Decompile Error");
                    }
                    Console.Script(line);
                }
                long endTime = System.currentTimeMillis();
                Console.Info("Finished Decompiling > " + (endTime - startTime) / 1000L + " sec");
                MainPanel.setIndeterminate(false);
            }
        });
        SetupManager.addTask(new Task("Moving MCP"){

            @Override
            public void Run() throws Exception {
                MainPanel.setIndeterminate(true);
                FileManager.Move(new File(Settings.getRoot() + "/MCP/forge/mcp"), new File(Settings.getRoot() + "/MCP"));
                FileManager.Delete(new File(Settings.getRoot() + "/MCP/forge/mcp"));
                MainPanel.setIndeterminate(false);
            }
        });
    }
}

