/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.IO;

import java.io.File;
import java.io.IOException;
import net.modmaker.Console.Console;
import net.modmaker.IO.Settings;

public class WorkingDirectory {
    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("mac")) {
            return OS.MAC;
        }
        if (osName.contains("linux")) {
            return OS.LINUX;
        }
        if (osName.contains("unix")) {
            return OS.LINUX;
        }
        if (osName.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (osName.contains("solaris")) {
            return OS.SOLARIS;
        }
        return OS.UNKNOWN;
    }

    public static File getWorkingDirectory() {
        File file = WorkingDirectory.getDefaultWorkingDirectory();
        Settings.setRoot(file);
        return file;
    }

    public static File getDefaultWorkingDirectory() {
        File file;
        String home = System.getProperty("user.home");
        switch (WorkingDirectory.getPlatform().ordinal()) {
            case 0: {
                file = new File("C:/Program Files/Deathly's Mod Editor");
                break;
            }
            case 1: {
                file = new File(home + "/Library/Application Support/Deathly's Mod Editor");
                break;
            }
            case 2: 
            case 3: {
                file = new File(home + "/Deathly's Mod Editor");
                break;
            }
            default: {
                file = new File(home + "/Deathly's Mod Editor");
            }
        }
        if (file.isFile()) {
            file.delete();
        }
        if (!file.exists() && !file.mkdirs()) {
            Console.Err(new RuntimeException("The working directory could not be created: " + file.getAbsolutePath()));
        }
        return file;
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        SOLARIS,
        UNKNOWN;


        public String toString() {
            String name = super.toString();
            name = name.toLowerCase();
            String firstLetter = name.substring(0, 1).toUpperCase();
            name = firstLetter + name.substring(1);
            return name;
        }

        public void openDirInExplorer(File dir) throws IOException {
            if (this.equals((Object)WINDOWS)) {
                Runtime.getRuntime().exec("Explorer.exe " + dir.getPath());
            } else if (this.equals((Object)MAC)) {
                Runtime.getRuntime().exec("open " + dir.getPath());
            }
        }
    }
}

