/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.tools.ToolProvider;
import net.modmaker.Console.Console;
import net.modmaker.Console.ConsoleInput;
import net.modmaker.Gui.Dialogs.InstallMCP;
import net.modmaker.Gui.Dialogs.ItemChooser;
import net.modmaker.Gui.Dialogs.LoadDialog;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.Dialogs.PluginDialog;
import net.modmaker.Gui.Dialogs.QuitDialog;
import net.modmaker.Gui.Dialogs.WelcomeDialog;
import net.modmaker.Gui.Frame;
import net.modmaker.Gui.MainPanel;
import net.modmaker.IO.BackupSystem;
import net.modmaker.IO.DownloadManager;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.IO.SetupManager;
import net.modmaker.IO.WorkingDirectory;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.Textures;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.Utils.Urls;
import net.modmaker.backup.BackupManager;
import net.modmaker.backup.RepairWorkspace;
import net.modmaker.events.ExitEvent;
import net.modmaker.events.Listeners.ExitListener;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginManager;
import net.modmaker.plugin.SaveBase;

public class Main {
    private static ArrayList<ExitListener> exitListeners = new ArrayList();
    private static long startTime;

    public static void main(String[] args) {
        block47: {
            Console.Info("Deathly's Mod Editor " + Settings.getVersion());
            Console.Info("Copyright \u00a9 Deathlykiller. All rights reserved");
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Windows".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                JOptionPane.showMessageDialog(null, "Something went wrong with the UI:\n\n" + sw.toString());
            }
            if (!WorkingDirectory.getPlatform().equals((Object)WorkingDirectory.OS.WINDOWS)) {
                JOptionPane.showMessageDialog(null, "Deathly's Mod Editor is not tested on " + WorkingDirectory.getPlatform().toString(), "Warning!", 2);
            }
            Settings.setOS(WorkingDirectory.getPlatform());
            if (ToolProvider.getSystemJavaCompiler() == null) {
                JOptionPane.showMessageDialog(null, "You need to start this program with:\nJava Developments Kit (jdk)\nIn order to use al features", "Warning!", 2);
                Settings.put("modmaker.runtime.jdk", "false");
            } else {
                Settings.put("modmaker.runtime.jdk", "true");
            }
            try {
                File testFile = new File(Settings.getRoot() + "/testFile");
                testFile.delete();
                testFile.createNewFile();
                testFile.delete();
            }
            catch (IOException e) {
                if (!e.getMessage().equals("Access is denied e")) break block47;
                JOptionPane.showMessageDialog(null, "You should run this program as administrator!", "Fatal Error!", 64);
                System.exit(1);
            }
        }
        int time = 2000;
        try {
            File ld = new File("launchdata.dat");
            if (ld.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(ld));
                time = Integer.parseInt(reader.readLine());
                reader.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        startTime = System.currentTimeMillis();
        LoadDialog loading = new LoadDialog(null, "Loading Program", time);
        Settings.setDialog(loading);
        loading.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                JDialog dialog = Settings.getDialog();
                if (dialog != null && dialog instanceof LoadDialog) {
                    ((LoadDialog)dialog).start();
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (((LoadDialog)dialog).getReturnStatus() == 1) {
                        System.exit(0);
                    }
                }
            }
        }.start();
        if (args.length > 0) {
            for (int a = 0; a < args.length; ++a) {
                try {
                    if (args[a].equalsIgnoreCase("?") || args[a].equalsIgnoreCase("help")) {
                        Console.Info("Syntax: Command:Value -> Example: enableGui:false");
                        Console.Info("Command         | Value      | info");
                        Console.Info("                |            |");
                        Console.Info("Debug           | true/false | set debug mode");
                        Console.Info("enableGui       | true/false | determines if it is command-line or GUI");
                        Console.Info("enableInput     | true/false | enable/disable inputstream of this program");
                        Console.Info("loadConfig      | true/false | if it load the config file or use default settings");
                        Console.Info("loadPlugins     | true/false | load all plugins at startup");
                        Console.Info("loadWorkBench   | true/false | load all mods that were loaded last time");
                        Console.Info("loadLibs        | true/false | load the librarys on startup");
                        Console.Info("repairWorkspace | true/false | repair the workspace on startup");
                        Console.Info("makeBackup      | true/false | Set if it make backups or not");
                        Console.Info("Update          | true/false | Connect to the servers for update information");
                        System.exit(0);
                        continue;
                    }
                    String[] value = Main.getValue(args[a]);
                    Main.checkArg(value);
                    continue;
                }
                catch (Exception e) {
                    Console.Warning("Argument Exception: " + args[a]);
                }
            }
        }
        Settings.put("modmaker.root", new File("").getAbsolutePath());
        if (!Settings.getDebug()) {
            String ln;
            boolean exists = false;
            File root = new File("").getAbsoluteFile();
            File lib = new File(root.getPath() + "/lib");
            File[] rList = root.listFiles();
            File[] lList = lib.listFiles();
            if (rList != null && rList.length > 0) {
                for (File file : rList) {
                    if (!file.getName().toLowerCase().endsWith(".jar") || !(ln = file.getName().toLowerCase()).contains("deathly") || !ln.contains("mod") || !ln.contains("editor")) continue;
                    exists = true;
                    if (root.getName().equals("lib")) {
                        Settings.put("modmaker.root", root.getParent());
                        break;
                    }
                    Settings.put("modmaker.root", root.getPath());
                    break;
                }
            }
            if (lList != null && !exists && lList.length > 0) {
                for (File file : lList) {
                    if (!file.getName().toLowerCase().endsWith(".jar") || !(ln = file.getName().toLowerCase()).contains("deathly") || !ln.contains("mod") || !ln.contains("editor")) continue;
                    exists = true;
                    Settings.put("modmaker.root", root.getPath());
                    break;
                }
            }
            if (!exists) {
                int ret = OptionPane.showConfirmDialog(null, "Could not find workspace\nDo you want to create one in the directory?\n" + root.getPath(), "Wrong working directory!", 0, 2);
                if (ret == 0) {
                    Settings.put("modmaker.root", root.getPath());
                } else {
                    System.exit(0);
                }
            }
        }
        try {
            if (Settings.isLaunched()) {
                OptionPane.showConfirmDialog(null, "You don't need to start this program with\nDeathly's Mod Editor Launcher anymore", "No Launcher required!", 2);
                System.exit(1);
            }
            if (Settings.getDebug()) {
                Console.Info("Running in debug mode");
            }
            if (Settings.isEnableInput()) {
                ConsoleInput ci = new ConsoleInput(System.in);
                new Thread(ci).start();
            }
            if (Settings.isEnableGui()) {
                Main.loadTextures();
            } else {
                Console.Warning("Disable Gui");
            }
            SetupManager.loadSetup();
            if (Settings.isLoadConfig()) {
                Main.loadConfig();
                if (Settings.isRepairWorkspace()) {
                    RepairWorkspace.repairWorkspace();
                } else {
                    Console.Warning("Disable repair workspace");
                }
            } else {
                Console.Warning("Disable Config");
            }
            if (Settings.isLoadLibrarys()) {
                Main.loadLibs();
            } else {
                Console.Warning("Disable Librarys");
            }
            if (Settings.isLoadPlugins()) {
                Main.loadPlugins();
            } else {
                Console.Warning("Disable Plugins");
            }
            if (Settings.isLoadWorkBench()) {
                SaveManager.loadAllMods();
            } else {
                Console.Warning("Disable WorkBench");
            }
            if (Main.isUpdated()) {
                // empty if block
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block23: {
                        try {
                            if (Settings.isCheckForUpdates()) {
                                if (Main.checkForUpdates()) {
                                    PluginDialog pd;
                                    if (!PluginManager.getUpdates().isEmpty()) {
                                        pd = new PluginDialog(2);
                                        pd.setVisible(true);
                                    } else if (!PluginManager.getAvailable().isEmpty()) {
                                        pd = new PluginDialog(1);
                                        pd.setVisible(true);
                                    }
                                }
                            } else {
                                Console.Warning("Disable Check for updates");
                            }
                            if (!Settings.isInstalled()) {
                                while (Settings.getDialog() != null) {
                                    Thread.sleep(20L);
                                }
                                while (Settings.getFrame() == null) {
                                    Thread.sleep(20L);
                                }
                                InstallMCP id = new InstallMCP();
                                id.setVisible(true);
                                int result = id.getReturnStatus();
                                if (result == 0) {
                                    SetupManager.runSetup();
                                }
                                break block23;
                            }
                            if (!Settings.isCheckForUpdates()) break block23;
                            try {
                                String line;
                                File version = new File(Settings.getRoot() + "/MCP/forge/fml/conf/version.cfg");
                                BufferedReader bf = new BufferedReader(new FileReader(version));
                                String MCPVersion = null;
                                String ClientVersion = null;
                                String ServerVersion = null;
                                while ((line = bf.readLine()) != null) {
                                    try {
                                        if (line.startsWith("MCPVersion = ")) {
                                            MCPVersion = line.substring("MCPVersion = ".length());
                                            continue;
                                        }
                                        if (line.startsWith("ClientVersion = ")) {
                                            ClientVersion = line.substring("ClientVersion = ".length());
                                            continue;
                                        }
                                        if (!line.startsWith("ServerVersion = ")) continue;
                                        ServerVersion = line.substring("ServerVersion = ".length());
                                    }
                                    catch (Throwable e) {
                                        Console.Warning("Error while reading mcp versions");
                                        Console.Warning(e.getMessage());
                                    }
                                }
                                double mcpVersion = Double.parseDouble(MCPVersion);
                                if (mcpVersion != Double.parseDouble(Settings.getMCPVersion())) {
                                    Settings.setInstalled(false);
                                    MainPanel.setInstalled(false);
                                    while (Settings.getDialog() != null) {
                                        Thread.sleep(20L);
                                    }
                                    while (Settings.getFrame() == null) {
                                        Thread.sleep(20L);
                                    }
                                    InstallMCP id = new InstallMCP();
                                    id.setVisible(true);
                                    int result = id.getReturnStatus();
                                    if (result == 0) {
                                        SetupManager.runSetup();
                                    }
                                }
                            }
                            catch (Throwable e) {}
                        }
                        catch (Throwable e) {
                            Console.Err(e);
                        }
                    }
                }
            });
            t.setName("Check for updates");
            t.start();
            if (Settings.isEnableGui()) {
                Main.loadGUI();
            }
            if (Settings.isMakeBackup()) {
                BackupManager.runBackupSystem();
            } else {
                Console.Warning("Disable Backup");
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error:\n\n" + sw.toString(), "Fatal Error!", 0);
            System.exit(1);
        }
        Console.Info("Finished Main thread");
    }

    public static void addExitListener(ExitListener el) {
        exitListeners.add(el);
    }

    public static void removeExitListener(ExitListener el) {
        exitListeners.remove(el);
    }

    public static void onExit(final boolean update) {
        new Thread(){

            @Override
            public void run() {
                block9: {
                    try {
                        boolean proceed = true;
                        if (!ThreadManager.getRunningProcesses().isEmpty() || !ThreadManager.getRunningThreads().isEmpty()) {
                            QuitDialog qd = new QuitDialog(true);
                            qd.setVisible(true);
                            if (qd.getReturnStatus() == 0) {
                                proceed = false;
                            }
                        }
                        if (proceed) {
                            ExitEvent ee = new ExitEvent(new Main(), update);
                            Console.Info("onExit");
                            for (ExitListener el : exitListeners) {
                                try {
                                    el.onExit(ee);
                                }
                                catch (Exception e) {
                                    Console.Err(e);
                                }
                            }
                            Console.Info("Stop current threads");
                            ThreadManager.stopCurrentThreads();
                            Console.Info("Stop current processes");
                            ThreadManager.killCurrentProcesses();
                            Console.Info("Clear log");
                            Console.log.clear();
                            Console.Info("Save config");
                            Main.saveConfig();
                            Console.Info("Stop backup system");
                            BackupSystem.stopBackupSystem();
                            Console.Info("Disable plugins");
                            PluginManager.DisablePlugins();
                            Console.Info("Clear mods");
                            ModManager.mods.clear();
                            Console.Info("Delete temp");
                            new File(Settings.getRoot() + "/temp.temp").delete();
                            if (update) {
                                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                                builder.directory(Settings.getRootFile());
                                ArrayList<String> cmd = new ArrayList<String>();
                                cmd.add("java");
                                cmd.add("-jar");
                                cmd.add("lib/ProgramUpdater.jar");
                                builder.command(cmd);
                                builder.start();
                                Console.Info("Start program updater");
                            }
                            Console.Info("Dispose frame");
                            Settings.getFrame().setVisible(false);
                            Settings.getFrame().dispose();
                            System.exit(0);
                        }
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        OptionPane.showMessageDialog(Settings.getFrame(), "Error: \n\n" + sw.toString(), "Error", 0);
                        int result = OptionPane.showConfirmDialog(Settings.getFrame(), "Are you sure you want to quit?", "Quit", 0);
                        if (result != 0) break block9;
                        Settings.getFrame().setVisible(false);
                        Settings.getFrame().dispose();
                        System.exit(0);
                    }
                }
            }
        }.start();
    }

    private static String[] getValue(String arg) throws Exception {
        String[] split;
        if (arg.contains(":") && (split = arg.split(":")).length == 2) {
            return split;
        }
        throw new Exception("Unknown Argument: " + arg);
    }

    private static void checkArg(String[] arg) throws Exception {
        if (arg[0].equalsIgnoreCase("enableGui")) {
            Settings.setEnableGui(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("enableInput")) {
            Settings.setEnableInput(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("loadConfig")) {
            Settings.setLoadConfig(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("loadPlugins")) {
            Settings.setLoadPlugins(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("loadWorkBench")) {
            Settings.setLoadWorkBench(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("loadLibs")) {
            Settings.put("modmaker.runtime.loadlibs", arg[1]);
        } else if (arg[0].equalsIgnoreCase("repairWorkspace")) {
            Settings.setRepairWorkspace(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("makeBackup")) {
            Settings.setMakeBackup(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("Update")) {
            Settings.setCheckForUpdates(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("debug")) {
            Settings.setDebug(Boolean.parseBoolean(arg[1]));
        } else if (arg[0].equalsIgnoreCase("Launcher")) {
            Settings.setLaunched(true);
        } else {
            String key = "modmaker.runtime." + arg[0].toLowerCase();
            Settings.put(key, arg[1]);
        }
    }

    public static void loadPlugins() throws Exception {
        PluginManager.EnablePlugins();
    }

    public static void unloadPlugins() throws Exception {
        PluginManager.DisablePlugins();
    }

    public static void loadTextures() throws Exception {
        Textures.Load();
    }

    public static void loadGUI() throws Exception {
        try {
            UIManager.put("SplitPane.background", new ColorUIResource(111, 111, 111));
            UIManager.put("Tree.selectionBackground", new ColorUIResource(100, 100, 100));
            UIManager.put("Tree.textBackground", new ColorUIResource(100, 100, 100));
            UIManager.put("List.selectionBackground", new Color(0, 0, 0, 0));
            UIManager.put("List.selectionForeground", Color.white);
            UIManager.put("TextPane.selectionBackground", new Color(0, 0, 0, 0));
            UIManager.put("TextPane.selectionForeground", Color.white);
            UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
            new CompoundBorder(new LineBorder(new Color(30, 30, 30)), new LineBorder(new Color(51, 51, 51)));
            UIManager.put("PopupMenu.border", new LineBorder(new Color(51, 51, 51), 2));
            UIManager.put("Menu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("Menu.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("Menu.opaque", false);
            UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("PopupMenu.opaque", true);
            UIManager.put("MenuItem.background", new ColorUIResource(51, 51, 51));
            UIManager.put("MenuItem.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("MenuItem.opaque", false);
        }
        catch (Exception e) {
            Console.Err(e);
        }
        Frame mf = new Frame();
        boolean show = new Random().nextInt(3) == 0;
        WelcomeDialog wd = null;
        if (show && !Settings.getDebug()) {
            wd = new WelcomeDialog();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter("launchdata.dat"));
            writer.write(String.valueOf(System.currentTimeMillis() - startTime));
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (Settings.getDialog() != null) {
            Settings.getDialog().setVisible(false);
            Settings.getDialog().dispose();
            if (Settings.getDialog() instanceof LoadDialog && ((LoadDialog)Settings.getDialog()).getReturnStatus() == 1) {
                new File(Settings.getRoot() + "/temp.temp").delete();
                System.exit(0);
            }
        }
        if (show && !Settings.getDebug()) {
            Settings.setDialog(wd);
            wd.setVisible(true);
        }
        Settings.setDialog(null);
        mf.setVisible(true);
        mf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Main.onExit(false);
            }
        });
        mf.setExtendedState(6);
        Settings.setFrame(mf);
        new ItemChooser(mf);
        for (ModManager manager : ModManager.mods) {
            for (SaveBase sb : manager.getMod().listAllSaveBase()) {
                try {
                    if (sb.getParent() == null) {
                        sb.getPlugin().getPanelBase(sb);
                        continue;
                    }
                    sb.getParent().getNewChildPanel(sb);
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
        }
    }

    public static void loadConfig() throws Exception {
        try {
            SaveManager.loadConfig();
        }
        catch (Exception e) {
            Console.Err(e);
        }
        if (Settings.getAuthor() == null) {
            String name = "";
            try {
                name = System.getProperty("user.name");
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = (String)OptionPane.showInputDialog(Settings.getFrame(), "Your Name:", "Author", -1, null, name);
            if (name == null) {
                System.exit(0);
            } else if (name.equals("")) {
                System.exit(0);
            }
            Settings.setAuthor(name);
        }
        Console.Info("OS: " + WorkingDirectory.getPlatform().toString());
        Console.Info("Java " + System.getProperty("java.version") + " (" + System.getProperty("sun.arch.data.model") + " bit)");
        SaveManager.loadUpdateData();
        Console.Info("Root: " + Settings.getRootFile().getPath());
        File f = new File(Settings.getRoot() + "/temp.temp");
        if (f.exists()) {
            OptionPane.showMessageDialog(null, "The editor wasn't closed properly last time\n\nIf you lost any data you can replace an backup from going into the menu bar under tools/backup", "Warning!", 2);
        }
        new File(Settings.getRoot() + "/temp").mkdirs();
        f.createNewFile();
    }

    public static void saveConfig() throws Exception {
        block5: {
            try {
                SaveManager.saveConfig();
                for (ModManager mod : ModManager.mods) {
                    try {
                        SaveManager.saveMod(mod);
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        JOptionPane.showMessageDialog(null, "Error while saving:\n\n" + sw.toString(), "Error!", 0);
                    }
                }
            }
            catch (Exception e) {
                Console.Err(e);
                int result = OptionPane.showConfirmDialog(Settings.getFrame(), "Failed to Save\n\nAre you sure you want to quit?", "Failed to Save", 0);
                if (result == 0) break block5;
                throw new Exception();
            }
        }
    }

    public static boolean isUpdated() throws IOException {
        BufferedReader bf;
        if (new File(Settings.getRoot() + "Update.dat").exists() && (bf = new BufferedReader(new FileReader(Settings.getRoot() + "Update.dat"))).readLine() != null) {
            bf.close();
            Main.onExit(true);
        }
        return new File(Settings.getRoot() + "/updated").exists();
    }

    public static boolean checkForUpdates() {
        try {
            File launcher = new File(Settings.getRoot() + "/Deathly's Mod Editor Launcher.jar");
            if (!launcher.exists()) {
                FileManager.extractFromResources("/net/modmaker/res/DME_Launcher.jar", launcher);
            }
            if (new File(Settings.getRoot() + "/ProgramUpdater.jar").exists()) {
                new File(Settings.getRoot() + "/ProgramUpdater.jar").delete();
            }
            try {
                new File(Settings.getRoot() + "/lib").mkdirs();
                File updater = new File(Settings.getRoot() + "/lib/ProgramUpdater.jar");
                if (!updater.exists()) {
                    FileManager.extractFromResources("/net/modmaker/res/ModMaker_Updater.jar", updater);
                }
            }
            catch (Exception e) {
                Console.Warning("Unable to create ProgramUpdater.jar");
            }
            File uptodate = new File(Settings.getRoot() + "/UpToDate.ini");
            if (uptodate.exists()) {
                while (!uptodate.delete()) {
                    Thread.sleep(20L);
                }
            }
            boolean googleServers = false;
            try {
                Console.Info("Connecting to dropbox servers ....");
                DownloadManager.DownloadtoFile(Urls.UpToDate.getURL(), uptodate);
            }
            catch (Throwable eee) {
                Console.Info("Could not connect to dropbox servers");
                Console.Info("Connecting to google drive servers ....");
                try {
                    DownloadManager.DownloadtoFile(Urls.UpToDateGoogle.getURL(), uptodate);
                    googleServers = true;
                }
                catch (Throwable e) {
                    Console.Info("Could not connect to google drive servers");
                    throw e;
                }
            }
            Settings.put("modmaker.uptodate.servers", googleServers ? "google" : "dropbox");
            SaveManager.loadUpdateData();
            double rversion = Double.parseDouble(Settings.get("modmaker.uptodate.version"));
            if (rversion > Settings.getVersion()) {
                MainPanel.UpdateAvailable(true);
                while (RepairWorkspace.isRepairing()) {
                    Thread.sleep(20L);
                }
                int resutl = OptionPane.showConfirmDialog(null, "Update available!\n\nDo you want to update?", "Update", 0, 3);
                if (resutl == 0) {
                    MainPanel.UpdateAvailable(false);
                    DownloadManager.DownloadtoFile(new URL(Settings.get("modmaker.uptodate.editorurl")), new File(Settings.getRoot() + "/temp/Deathly's Mod Editor V" + rversion + ".temp"));
                    BufferedWriter scriptWriter = new BufferedWriter(new FileWriter(Settings.getRoot() + "/Update.dat"));
                    scriptWriter.write("Delete:" + Settings.getRoot() + "/lib/Deathly's Mod Editor.jar");
                    scriptWriter.newLine();
                    scriptWriter.write("Rename:" + Settings.getRoot() + "/temp/Deathly's Mod Editor V" + rversion + ".temp>" + Settings.getRoot() + "/lib/Deathly's Mod Editor.jar");
                    scriptWriter.newLine();
                    scriptWriter.write("Run:java -jar \"" + launcher.getAbsolutePath() + "\"");
                    scriptWriter.close();
                    Main.onExit(true);
                }
            }
            Settings.setMinecraftVersion(Settings.get("modmaker.uptodate.mcversion"));
            Settings.setMCPVersion(Settings.get("modmaker.uptodate.mcpversion"));
            Settings.setForgeVersion(Settings.get("modmaker.uptodate.forgeversion"));
            Urls.MCFORGE.setUrl(Settings.get("modmaker.uptodate.forgeurl"));
            MainPanel.setSystemInfo();
            ArrayList<PluginManager.UpdateData> updates = new ArrayList<PluginManager.UpdateData>();
            ArrayList<PluginManager.UpdateData> available = new ArrayList<PluginManager.UpdateData>();
            String data = Settings.get("modmaker.uptodate.plugins.data");
            if (!"".equals(data) && data.contains(";")) {
                String[] pluginNames = data.split(";");
                for (int i = 0; i < pluginNames.length - 1; ++i) {
                    try {
                        String name = pluginNames[i];
                        double version = Double.parseDouble(Settings.get("modmaker.uptodate.plugins." + name));
                        String url = Settings.get("modmaker.uptodate.url." + name);
                        boolean exists = false;
                        for (Plugin plugin : PluginManager.getPlugins()) {
                            if (!plugin.getName().equals(name)) continue;
                            exists = true;
                            if (!(plugin.getVersion() < version)) continue;
                            updates.add(new PluginManager.UpdateData(plugin, name, version, new URL(url), null));
                        }
                        if (exists) continue;
                        available.add(new PluginManager.UpdateData(null, name, version, new URL(url), null));
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        Console.Warning("Update check error: " + e.getLocalizedMessage());
                    }
                }
            }
            while (RepairWorkspace.isRepairing()) {
                Thread.sleep(20L);
            }
            PluginManager.setUpdates(updates);
            PluginManager.setAvailable(available);
            Console.Info("Connecting complete!");
            return false;
        }
        catch (Throwable e) {
            Console.Info("Connecting failed!");
            Console.Err(e);
            return false;
        }
    }

    public static void loadLibs() {
        File libFile = new File(Settings.getRoot() + "/lib");
        libFile.mkdirs();
        File[] list = libFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().endsWith(".jar") && !pathname.getName().equals("ProgramUpdater.jar")) {
                    Console.Info("Load library: " + pathname.getName().substring(0, pathname.getName().length() - 4));
                    return true;
                }
                return false;
            }
        });
        if (list == null) {
            return;
        }
        URL[] urls = new URL[list.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = list[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Console.Warning("Can't get url from: " + list[i].getPath());
            }
        }
        try {
            new File(Settings.getRoot() + "/lib/native").mkdirs();
            System.getProperties().put("java.library.path", new File(Settings.getRoot() + "/lib/native").getPath());
            Field fld = ClassLoader.class.getDeclaredField("sys_paths");
            fld.setAccessible(true);
            fld.set(null, null);
        }
        catch (Throwable e) {
            Console.Err(e);
        }
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        try {
            Method method = sysClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL url : urls) {
                method.invoke((Object)sysloader, url);
            }
        }
        catch (Throwable t) {
            Console.Err(t);
        }
    }
}

