/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.MinecraftEvents;

import java.awt.Window;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.MinecraftEvents.Actions.ActionScript;
import net.modmaker.MinecraftEvents.Actions.ScheduleBlock;
import net.modmaker.MinecraftEvents.Actions.TryToFall;
import net.modmaker.MinecraftEvents.EventBase;

public abstract class ActionBase {
    private final String name;
    private EventBase event;
    private static ArrayList<Class> actionClasses = new ArrayList();

    public ActionBase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEvent(EventBase event) {
        this.event = event;
    }

    public EventBase getEvent() {
        return this.event;
    }

    public abstract void onEdit(Window var1);

    public abstract Export.ExportHint getExportHint();

    public abstract String getDescription();

    public abstract String toString();

    public abstract void setData(String var1);

    public abstract boolean checkEvent(EventBase var1);

    public static ArrayList<ActionBase> getActions() throws InstantiationException, IllegalAccessException {
        ArrayList<ActionBase> actions = new ArrayList<ActionBase>();
        for (Class c : actionClasses) {
            ActionBase ab = (ActionBase)c.newInstance();
            actions.add(ab);
        }
        return actions;
    }

    public static void registerAction(ActionBase action) {
        actionClasses.add(action.getClass());
    }

    public static ActionBase getActionBase(String data) throws InstantiationException, IllegalAccessException {
        String name = data.split("<next>")[0];
        for (Class c : actionClasses) {
            ActionBase ab = (ActionBase)c.newInstance();
            if (!ab.getName().equals(name)) continue;
            ab.setData(data);
            return ab;
        }
        return null;
    }

    static {
        ActionBase.registerAction(new ActionScript());
        ActionBase.registerAction(new ScheduleBlock());
        ActionBase.registerAction(new TryToFall());
    }
}

