/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.MinecraftEvents.Actions;

import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.Gui.EventDialogs.ScriptEditor;
import net.modmaker.MinecraftEvents.ActionBase;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;

public class ActionScript
extends ActionBase {
    private String imports;
    private String code;

    public ActionScript() {
        super("Script");
    }

    @Override
    public void onEdit(Window parent) {
        ScriptEditor se = new ScriptEditor(parent, this);
        se.setVisible(true);
        if (se.getReturnStatus() == 1) {
            this.imports = se.getImports();
            this.code = se.getCode();
        }
    }

    @Override
    public Export.ExportHint getExportHint() {
        ArrayList<String> im = new ArrayList<String>();
        if (this.imports != null) {
            if (this.imports.contains("\n")) {
                String[] str;
                for (String i : str = this.imports.split("\n")) {
                    im.add(i);
                }
            } else if (!this.imports.equals("")) {
                im.add(this.imports);
            }
        }
        return new Export.ExportHint(im, null){

            @Override
            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                if (!ActionScript.this.code.contains("\n")) {
                    bf.write("        " + ActionScript.this.code);
                    bf.newLine();
                } else {
                    String[] split;
                    for (String line : split = ActionScript.this.code.split("\n")) {
                        bf.write("        " + line);
                        bf.newLine();
                    }
                }
            }
        };
    }

    public String getImports() {
        if (this.imports == null) {
            this.imports = "";
        }
        return this.imports;
    }

    public String getCode() {
        if (this.code == null) {
            this.code = "";
        }
        return this.code;
    }

    @Override
    public String getDescription() {
        if (this.code == null) {
            return "";
        }
        if (this.code.contains("\n")) {
            return this.code.split("\n")[0];
        }
        return this.code;
    }

    @Override
    public String toString() {
        if (this.imports == null) {
            this.imports = "";
        }
        if (this.code == null) {
            this.code = "";
        }
        return this.getName() + "<next>" + this.imports.replace("\n", "<br>") + "<next>" + this.code.replace("\n", "<br>");
    }

    @Override
    public void setData(String data) {
        String[] split = data.split("<next>");
        try {
            this.imports = split[1].replace("<br>", "\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.code = split[2].replace("<br>", "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean checkEvent(EventBase event) {
        return true;
    }
}

