/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.MinecraftEvents.Actions;

import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.Gui.EventDialogs.ReturnEditor;
import net.modmaker.MinecraftEvents.ActionBase;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;

public class ReturnStatement
extends ActionBase {
    private String code;

    public ReturnStatement(String code) {
        super("Return");
        this.code = code;
    }

    @Override
    public void onEdit(Window parent) {
        ReturnEditor re = new ReturnEditor(parent, this);
        re.setVisible(true);
        if (re.getReturnStatus() == 1) {
            this.code = re.getCode();
        }
    }

    @Override
    public Export.ExportHint getExportHint() {
        return new Export.ExportHint(new ArrayList(), null){

            @Override
            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                while (ReturnStatement.this.code.endsWith(" ")) {
                    ReturnStatement.this.code = ReturnStatement.this.code.substring(0, ReturnStatement.this.code.length() - 1);
                }
                if (!ReturnStatement.this.code.endsWith(";")) {
                    ReturnStatement.this.code = ReturnStatement.this.code + ";";
                }
                bf.write("        return " + ReturnStatement.this.code);
                bf.newLine();
            }
        };
    }

    @Override
    public String getDescription() {
        return this.code;
    }

    @Override
    public String toString() {
        return this.getName() + "<next>" + this.code;
    }

    @Override
    public void setData(String data) {
        String[] split = data.split("<next>");
        this.code = split[1];
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public boolean checkEvent(EventBase event) {
        return true;
    }
}

