/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.MinecraftEvents;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.MinecraftEvents.ActionBase;
import net.modmaker.MinecraftEvents.Actions.ReturnStatement;
import net.modmaker.MinecraftEvents.BlockEvents.breakBlock;
import net.modmaker.MinecraftEvents.BlockEvents.initializeBlock;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockActivated;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockAdded;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockClicked;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockDestroyedByExplosion;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockDestroyedByPlayer;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockEventReceived;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockHarvested;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockPlaced;
import net.modmaker.MinecraftEvents.BlockEvents.onBlockPlacedBy;
import net.modmaker.MinecraftEvents.BlockEvents.onEntityCollidedWithBlock;
import net.modmaker.MinecraftEvents.BlockEvents.onEntityWalking;
import net.modmaker.MinecraftEvents.BlockEvents.onFallenUpon;
import net.modmaker.MinecraftEvents.BlockEvents.onNeighborBlockChange;
import net.modmaker.MinecraftEvents.BlockEvents.onPostBlockPlaced;
import net.modmaker.MinecraftEvents.BlockEvents.onSetBlockIDWithMetaData;
import net.modmaker.MinecraftEvents.BlockEvents.randomDisplayTick;
import net.modmaker.MinecraftEvents.BlockEvents.updateTick;
import net.modmaker.MinecraftEvents.BlockEvents.velocityToAddToEntity;
import net.modmaker.MinecraftEvents.ItemEvents.doesContainerItemLeaveCraftingGrid;
import net.modmaker.MinecraftEvents.ItemEvents.getIconIndex;
import net.modmaker.MinecraftEvents.ItemEvents.hitEntity;
import net.modmaker.MinecraftEvents.ItemEvents.itemInteractionForEntity;
import net.modmaker.MinecraftEvents.ItemEvents.onBlockDestroyed;
import net.modmaker.MinecraftEvents.ItemEvents.onBlockStartBreak;
import net.modmaker.MinecraftEvents.ItemEvents.onCreated;
import net.modmaker.MinecraftEvents.ItemEvents.onDroppedByPlayer;
import net.modmaker.MinecraftEvents.ItemEvents.onFoodEaten;
import net.modmaker.MinecraftEvents.ItemEvents.onItemRightClick;
import net.modmaker.MinecraftEvents.ItemEvents.onItemUse;
import net.modmaker.MinecraftEvents.ItemEvents.onItemUseFirst;
import net.modmaker.MinecraftEvents.ItemEvents.onLeftClickEntity;
import net.modmaker.MinecraftEvents.ItemEvents.onPlayerStoppedUsing;
import net.modmaker.MinecraftEvents.ItemEvents.onUpdate;
import net.modmaker.MinecraftEvents.ItemEvents.onUsingItemTick;

public abstract class EventBase {
    private final String name;
    private ArrayList<ActionBase> actions = new ArrayList();
    private ReturnStatement r;
    private static ArrayList<Class> eventBaseClasses = new ArrayList();

    public EventBase(String name, ReturnStatement r) {
        this.name = name;
        this.r = r;
        if (r != null) {
            r.setEvent(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addAction(ActionBase action) {
        this.actions.add(action);
        action.setEvent(this);
    }

    public void addAction(ActionBase action, int index) {
        this.actions.add(index, action);
        action.setEvent(this);
    }

    public void removeAction(int index) {
        this.actions.get(index).setEvent(null);
        this.actions.remove(index);
    }

    public void removeAction(ActionBase action) {
        action.setEvent(null);
        this.actions.remove(action);
    }

    public ActionBase getAction(int i) {
        return this.actions.get(i);
    }

    public ArrayList<ActionBase> getActions() {
        return this.actions;
    }

    public int getActionSize() {
        return this.actions.size();
    }

    public abstract String getParameters();

    public abstract Export.ExportHint getExportHint();

    public abstract URI getDocUrl() throws URISyntaxException;

    public ReturnStatement getReturnStatement() {
        return this.r;
    }

    public static ArrayList<EventBase> getBlockEvents() {
        ArrayList<EventBase> blockEvents = new ArrayList<EventBase>();
        blockEvents.add(new breakBlock());
        blockEvents.add(new initializeBlock());
        blockEvents.add(new onBlockActivated());
        blockEvents.add(new onBlockAdded());
        blockEvents.add(new onBlockClicked());
        blockEvents.add(new onBlockDestroyedByExplosion());
        blockEvents.add(new onBlockDestroyedByPlayer());
        blockEvents.add(new onBlockEventReceived());
        blockEvents.add(new onBlockHarvested());
        blockEvents.add(new onBlockPlaced());
        blockEvents.add(new onBlockPlacedBy());
        blockEvents.add(new onEntityCollidedWithBlock());
        blockEvents.add(new onEntityWalking());
        blockEvents.add(new onFallenUpon());
        blockEvents.add(new onNeighborBlockChange());
        blockEvents.add(new onPostBlockPlaced());
        blockEvents.add(new onSetBlockIDWithMetaData());
        blockEvents.add(new randomDisplayTick());
        blockEvents.add(new updateTick());
        blockEvents.add(new velocityToAddToEntity());
        return blockEvents;
    }

    public void setReturnStatement(ReturnStatement ret) {
        this.r = ret;
    }

    public static ArrayList<EventBase> getItemEvents() {
        ArrayList<EventBase> itemEvents = new ArrayList<EventBase>();
        itemEvents.add(new doesContainerItemLeaveCraftingGrid());
        itemEvents.add(new getIconIndex());
        itemEvents.add(new hitEntity());
        itemEvents.add(new itemInteractionForEntity());
        itemEvents.add(new onBlockDestroyed());
        itemEvents.add(new onBlockStartBreak());
        itemEvents.add(new onCreated());
        itemEvents.add(new onDroppedByPlayer());
        itemEvents.add(new onFoodEaten());
        itemEvents.add(new onItemRightClick());
        itemEvents.add(new onItemUse());
        itemEvents.add(new onItemUseFirst());
        itemEvents.add(new onLeftClickEntity());
        itemEvents.add(new onPlayerStoppedUsing());
        itemEvents.add(new onUpdate());
        itemEvents.add(new onUsingItemTick());
        return itemEvents;
    }

    public static ArrayList<EventBase> getMobEvents() {
        ArrayList<EventBase> mobEvents = new ArrayList<EventBase>();
        return mobEvents;
    }

    public static void registerEvent(Class event) throws InstantiationException, IllegalAccessException {
        EventBase base = (EventBase)event.newInstance();
        eventBaseClasses.add(event);
    }

    public static void removeEvent(Class event) {
        eventBaseClasses.remove(event);
    }

    public static EventBase getEventByName(String line) throws InstantiationException, IllegalAccessException {
        for (Class c : eventBaseClasses) {
            EventBase event = (EventBase)c.newInstance();
            if (!event.getName().equals(line)) continue;
            return event;
        }
        return null;
    }
}

