/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Mod;

import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.Gui.Dialogs.LogDialog;
import net.modmaker.Gui.Tree;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModPanel;
import net.modmaker.plugin.SaveBase;

public class ModManager {
    private ModPanel modPanel;
    public static ArrayList<ModManager> mods = new ArrayList();

    public ModManager(Mod mod) {
        mods.add(this);
        mod.setManager(this);
        this.modPanel = new ModPanel(mod);
        if (Tree.getTree() != null) {
            Tree.getTree().UpdateTree();
        }
    }

    public Mod getMod() {
        return this.modPanel.mod;
    }

    public ModPanel getModPanel() {
        return this.modPanel;
    }

    public static void Save() {
        for (ModManager manager : mods) {
            manager.modPanel.Save();
            for (SaveBase sb : manager.modPanel.mod.listAllSaveBase()) {
                if (sb.getPanel() == null) continue;
                sb.getPanel().Save();
            }
        }
    }

    public static void Load() {
        for (ModManager manager : mods) {
            manager.modPanel.Load();
            for (SaveBase sb : manager.modPanel.mod.listAllSaveBase()) {
                sb.getPanel().Load();
            }
        }
    }

    public void checkForErrors() throws Exception {
        ModManager.Save();
        ArrayList<String> log = new ArrayList<String>();
        String error = Export.ContainsError(this.getMod().name);
        if (error != null) {
            log.add("Modname " + this.getMod().name + " : " + error);
        }
        for (SaveBase sb : this.modPanel.mod.listAllSaveBase()) {
            try {
                sb.Check(log);
            }
            catch (Exception e) {
                log.add(sb.getName() + ": " + e.getMessage());
            }
        }
        if (!log.isEmpty()) {
            String text = "";
            for (String str : log) {
                if (text.equals("")) {
                    text = str;
                    continue;
                }
                text = text + "\n" + str;
            }
            LogDialog ld = new LogDialog(text, true, this);
            ld.setVisible(true);
            if (ld.getReturnStatus() == 0) {
                throw new Exception("Errors found!");
            }
        }
    }

    public String toString() {
        if (this.modPanel != null) {
            return this.modPanel.mod.name;
        }
        return null;
    }
}

