/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.util.ArrayList;
import net.modmaker.Console.Console;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.EnumBlock;
import net.modmaker.Utils.Textures;
import net.modmaker.events.InitializedEvent;
import net.modmaker.events.Listeners.InitializedListener;
import net.modmaker.events.Listeners.UpdateListener;
import net.modmaker.events.UpdateEvent;
import net.modmaker.plugin.BlockBase;
import net.modmaker.plugin.ItemBase;
import net.modmaker.plugin.SaveBase;

public class BlockItemHolder {
    private ItemBase item;
    private BlockBase block;
    private EnumBlock eb;
    private String name;
    private int md;
    private boolean isBlock;
    private ArrayList<UpdateListener> listeners = new ArrayList();
    private boolean initialized;
    public static String TYPE_ENUMBLOCK = "[ENUMBLOCK]";
    public static String TYPE_BLOCK = "[BLOCK]";
    public static String TYPE_ITEM = "[ITEM]";
    public static String TYPE_OTHER = "[OTHER]";

    public BlockItemHolder(String name, boolean isBlock, Mod mod) {
        this(name, 0, isBlock, mod);
    }

    public BlockItemHolder(String n, int metaData, final boolean isBlock, final Mod mod) {
        this.item = null;
        this.block = null;
        this.eb = null;
        this.name = n;
        this.md = metaData;
        this.isBlock = isBlock;
        if (mod != null) {
            this.setInitialized(false);
            mod.addInitializedListener(new InitializedListener(){

                @Override
                public void onInitialized(InitializedEvent event) {
                    if (mod != null) {
                        for (SaveBase sb : mod.listAllSaveBase()) {
                            if (!BlockItemHolder.this.name.equals(sb.getName())) continue;
                            if (sb instanceof BlockBase && isBlock) {
                                BlockItemHolder.this.name = null;
                                BlockItemHolder.this.md = 0;
                                BlockItemHolder.this.block = (BlockBase)sb;
                                BlockItemHolder.this.setInitialized(true);
                                for (UpdateListener l : BlockItemHolder.this.listeners) {
                                    BlockItemHolder.this.block.addUpdateListener(l);
                                }
                                continue;
                            }
                            if (!(sb instanceof ItemBase) || isBlock) continue;
                            BlockItemHolder.this.name = null;
                            BlockItemHolder.this.md = 0;
                            BlockItemHolder.this.item = (ItemBase)sb;
                            BlockItemHolder.this.setInitialized(true);
                            for (UpdateListener l : BlockItemHolder.this.listeners) {
                                BlockItemHolder.this.item.addUpdateListener(l);
                            }
                        }
                    }
                }
            });
        } else {
            this.setInitialized(true);
        }
    }

    public BlockItemHolder(EnumBlock eb) {
        this.item = null;
        this.block = null;
        this.eb = eb;
        this.name = null;
        this.md = 0;
        this.isBlock = false;
        this.setInitialized(true);
    }

    public BlockItemHolder(ItemBase item) {
        this.item = item;
        this.block = null;
        this.eb = null;
        this.name = null;
        this.md = 0;
        this.isBlock = false;
        this.setInitialized(true);
    }

    public BlockItemHolder(BlockBase block) {
        this.item = null;
        this.block = block;
        this.eb = null;
        this.name = null;
        this.md = 0;
        this.isBlock = false;
        this.setInitialized(true);
    }

    public BlockItemHolder(String type, final Mod mod) {
        this.eb = null;
        this.block = null;
        this.item = null;
        this.name = null;
        this.md = 0;
        this.isBlock = false;
        if (type.startsWith(TYPE_ENUMBLOCK)) {
            this.eb = EnumBlock.getById(type.substring(TYPE_ENUMBLOCK.length()));
            this.setInitialized(true);
        } else if (type.startsWith(TYPE_BLOCK)) {
            final String blockName = type.substring(TYPE_BLOCK.length());
            for (SaveBase sb : mod.listAllSaveBase()) {
                if (!sb.getName().equals(blockName) || !(sb instanceof BlockBase)) continue;
                this.block = (BlockBase)sb;
                this.setInitialized(true);
            }
            if (!this.initialized) {
                mod.addInitializedListener(new InitializedListener(){

                    @Override
                    public void onInitialized(InitializedEvent event) {
                        for (SaveBase sb : mod.listAllSaveBase()) {
                            if (!sb.getName().equals(blockName) || !(sb instanceof BlockBase)) continue;
                            BlockItemHolder.this.block = (BlockBase)sb;
                            BlockItemHolder.this.setInitialized(true);
                        }
                    }
                });
            }
        } else if (type.startsWith(TYPE_ITEM)) {
            final String itemName = type.substring(TYPE_ITEM.length());
            for (SaveBase sb : mod.listAllSaveBase()) {
                if (!sb.getName().equals(itemName) || !(sb instanceof ItemBase)) continue;
                this.item = (ItemBase)sb;
                this.setInitialized(true);
            }
            if (!this.initialized) {
                mod.addInitializedListener(new InitializedListener(){

                    @Override
                    public void onInitialized(InitializedEvent event) {
                        for (SaveBase sb : mod.listAllSaveBase()) {
                            if (!sb.getName().equals(itemName) || !(sb instanceof ItemBase)) continue;
                            BlockItemHolder.this.item = (ItemBase)sb;
                            BlockItemHolder.this.setInitialized(true);
                        }
                    }
                });
            }
        } else if (type.startsWith(TYPE_OTHER)) {
            String[] split = type.substring(TYPE_OTHER.length()).split(",");
            try {
                this.name = split[0];
                this.md = Integer.parseInt(split[1]);
                this.isBlock = Boolean.parseBoolean(split[2]);
                String imageText = split[3];
                for (int a = 4; a < split.length; ++a) {
                    imageText = imageText + "," + split[a];
                }
            }
            catch (Exception e) {
                Console.Err(e);
            }
        } else {
            Console.Warning("Unknown type: " + type);
        }
    }

    private void setInitialized(boolean i) {
        this.initialized = i;
        if (i) {
            UpdateEvent event = new UpdateEvent(this);
            for (UpdateListener l : this.listeners) {
                l.onUpdate(event);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addUpdateListener(UpdateListener l) {
        if (this.item != null) {
            this.item.addUpdateListener(l);
        } else if (this.block != null) {
            this.block.addUpdateListener(l);
        } else {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(UpdateListener l) {
        if (this.item != null) {
            this.item.removeUpdateListener(l);
        } else if (this.block != null) {
            this.block.removeUpdateListener(l);
        } else {
            this.listeners.remove(l);
        }
    }

    public BufferedImageSeri getTexture() {
        if (this.item != null) {
            return this.item.getTexture();
        }
        if (this.block != null) {
            return this.block.getTexture();
        }
        if (this.eb != null) {
            return this.eb.getTexture();
        }
        if (this.name != null) {
            return new BufferedImageSeri(Textures.getNoTexture());
        }
        return new BufferedImageSeri(Textures.getNoTexture());
    }

    public String getName() {
        if (this.item != null) {
            return this.item.getName();
        }
        if (this.block != null) {
            return this.block.getName();
        }
        if (this.eb != null) {
            return this.eb.getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    public String getJavaName() {
        if (this.item != null) {
            return "Server." + this.item.getJavaName();
        }
        if (this.block != null) {
            return "Server." + this.block.getJavaName();
        }
        if (this.eb != null) {
            return this.eb.getJavaName();
        }
        if (this.name != null) {
            return "Server." + this.name.replace(" ", "_");
        }
        return null;
    }

    public String getId() {
        if (this.eb != null) {
            return this.eb.getId();
        }
        if (this.item != null) {
            return this.item.getId() + ":0";
        }
        if (this.block != null) {
            return this.block.getId() + ":0";
        }
        if (this.md != 0) {
            return "-:" + String.valueOf(this.md);
        }
        return "-";
    }

    public String getIDType() {
        if (this.eb != null) {
            if (this.eb.isBlock()) {
                return ".blockID";
            }
            return ".itemID";
        }
        if (this.block != null) {
            return ".blockID";
        }
        if (this.item != null) {
            return ".itemID";
        }
        if (this.isBlock) {
            return ".blockID";
        }
        return ".itemID";
    }

    public String getData() {
        if (this.eb != null) {
            return TYPE_ENUMBLOCK + this.eb.getId();
        }
        if (this.block != null) {
            return TYPE_BLOCK + this.block.getName();
        }
        if (this.item != null) {
            return TYPE_ITEM + this.item.getName();
        }
        return TYPE_OTHER + this.name + "," + this.md + "," + this.isBlock + "," + this.getTexture().toString();
    }
}

