/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import net.modmaker.textureeditor.layers.Layer;

public class BufferedImageSeri
implements Serializable {
    private ArrayList<Integer> rgb = new ArrayList();
    private int w;
    private int h;
    private int type;

    public BufferedImageSeri(BufferedImage bi) {
        this.w = bi.getWidth();
        this.h = bi.getHeight();
        this.type = bi.getType();
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                this.rgb.add(bi.getRGB(x, y));
            }
        }
    }

    public BufferedImageSeri(String line) {
        String[] args = line.split(",");
        this.w = Integer.parseInt(args[0]);
        this.h = Integer.parseInt(args[1]);
        this.type = Integer.parseInt(args[2]);
        for (int a = 3; a < args.length; ++a) {
            this.rgb.add(Integer.parseInt(args[a]));
        }
    }

    public BufferedImage getImage() {
        if (this.type == 0) {
            this.type = 2;
        }
        BufferedImage bi = new BufferedImage(this.w, this.h, this.type);
        int pix = 0;
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                bi.setRGB(x, y, this.rgb.get(pix));
                ++pix;
            }
        }
        return bi;
    }

    public Layer getLayer() {
        Layer bi = new Layer(null, this.w, this.h);
        int pix = 0;
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                bi.setRGB(x, y, this.rgb.get(pix));
                ++pix;
            }
        }
        return bi;
    }

    public String toString() {
        String line = this.w + "," + this.h + "," + this.type;
        for (int pix : this.rgb) {
            line = line + "," + pix;
        }
        return line;
    }
}

