/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.Textures;

public enum EnumBlock implements Serializable
{
    Air("Air", "<none>", 0, null),
    Stone("Stone", "stone", 1, "stone"),
    Grass("Grass", "grass", 2, "grass_side"),
    Dirt("Dirt", "dirt", 3, "dirt"),
    CobbleStone("CobbleStone", "cobblestone", 4, "stonebrick"),
    Wood0("Wood", "planks", 5, "wood"),
    Wood1("Wood", "planks", 5, 1, "wood_spruce"),
    Wood2("Wood", "planks", 5, 2, "wood_birch"),
    Wood3("Wood", "planks", 5, 3, "wood_jungle"),
    Sapling0("Sapling", "sapling", 6, 0, "sapling"),
    Sapling1("Sapling", "sapling", 6, 1, "sapling_spruce"),
    Sapling2("Sapling", "sapling", 6, 2, "sapling_birch"),
    Sapling3("Sapling", "sapling", 6, 3, "sapling_jungle"),
    BedRock("BedRock", "bedrock", 7, "bedrock"),
    Water("Water", "waterMoving", 8, "water"),
    StationaryWater("Stationary Water", "waterStill", 9, "water"),
    Lava("Lava", "lavaMoving", 10, "lava"),
    StationaryLava("Stationary Lava", "lavaStill", 12, "lava"),
    Sand("Sand", "sand", 13, "sand"),
    Gravel("Gravel", "gravel", 14, "gravel"),
    GoldOre("Gold Ore", "oreGold", 15, "oreGold"),
    IronOre("Iron Ore", "oreIron", 16, "oreIron"),
    CoalOre("Coal Ore", "oreCoal", 17, "oreCoal"),
    Logs0("Logs", "wood", 18, "tree_side"),
    Logs1("Logs", "wood", 18, 1, "tree_spruce"),
    Logs2("Logs", "wood", 18, 2, "tree_birch"),
    Logs3("Logs", "wood", 18, 3, "tree_jungle"),
    Leaves("Leaves", "leaves", 18, "leaves"),
    Sponge("Sponge", "sponge", 19, "sponge"),
    Glass("Glass", "glass", 20, "glass"),
    LapisLazuliOre("Lapis Lazuli Ore", "oreLapis", 21, "oreLapis"),
    LapisLazuliBlock("Lapis Lazuli Block", "blockLapis", 22, "blockLapis"),
    Dispencer("Dispencer", "dispenser", 23, "dispenser_front"),
    SandStone0("SandStone", "sandStone", 24, 0, "sandstone_side"),
    SandStone1("SandStone", "sandStone", 24, 1, "sandstone_carved"),
    SandStone2("SandStone", "sandStone", 24, 2, "sandstone_smooth"),
    NoteBlock("Note Block", "music", 25, "musicBlock"),
    Bed("Bed", "bed", 26, "bed_head_top"),
    PoweredRail("Powered Rail", "railPowered", 27, "goldenRail"),
    DetectorRail("Detector Rail", "railDetector", 28, "detectorRail"),
    StickyPiston("Sticky Piston", "pistonStickyBase", 29, "piston_side"),
    Web("Web", "web", 30, "web"),
    DeadShrub("Dead Shrub", "tallGrass", 31, "deadbush"),
    TailGrass("Tail Grass", "tallGrass", 31, 1, "tallgrass"),
    LiveShrub("Live Shrub", "tallGrass", 31, 2, "fern"),
    DeadShrub2("Dead Shrub", "deadBush", 32, "deadbush"),
    Piston("Piston", "pistonBase", 33, "piston_side"),
    PistonHead("Piston Head", "pistonExtension", 34, "piston_top"),
    WhiteWool("White Wool", "cloth", 35, "cloth_0"),
    OrangeWool("Orange Wool", "cloth", 35, 1, "cloth_1"),
    MagentaWool("Magent Wool", "cloth", 35, 2, "cloth_2"),
    LightBlueWool("Light Blue Wool", "cloth", 35, 3, "cloth_3"),
    YellowWool("Yellow Wool", "cloth", 35, 4, "cloth_4"),
    LightGreenWool("Light Green Wool", "cloth", 35, 5, "cloth_5"),
    PinkWool("Pink Wool", "cloth", 35, 6, "cloth_6"),
    GrayWool("Gray Wool", "cloth", 35, 7, "cloth_7"),
    LightGrayWool("LightGray Wool", "cloth", 35, 8, "cloth_8"),
    CyanWool("Cyan Wool", "cloth", 35, 9, "cloth_9"),
    PurpleWool("Purple Wool", "cloth", 35, 10, "cloth_10"),
    BlueWool("Blue Wool", "cloth", 35, 11, "cloth_11"),
    BrownWool("Brown Wool", "cloth", 35, 12, "cloth_12"),
    DarkGreenWool("Dark Green Wool", "cloth", 35, 13, "cloth_13"),
    RedWool("Red Wool", "cloth", 35, 14, "cloth_14"),
    BlackWool("Black Wool", "cloth", 35, 15, "cloth_15"),
    Dandelion("Dandelion", "plantYellow", 37, "flower"),
    Rose("Rose", "plantRed", 38, "rose"),
    BrownMushroom("Brown Mushroom", "mushroomBrown", 39, "mushroom_brown"),
    RedMushroom("Red Mushroom", "mushroomRed", 40, "mushroom_red"),
    Goldblock("Gold Block", "blockGold", 41, "blockGold"),
    IronBlock("Iron Block", "blockIron", 42, "blockIron"),
    DoubleStoneSlab("Double Stone Slab", "stoneDoubleSlab", 43, "stoneslab_side"),
    DoubleSandStoneSlab("Double Sandstone Slab", "stoneDoubleSlab", 43, 1, "sandstone_side"),
    DoubleWoodenSlab("Double Wooden Slab", "stoneDoubleSlab", 43, 2, "wood"),
    DoubleCobbleSlab("Double Cobblestone Slab", "stoneDoubleSlab", 43, 3, "stonebrick"),
    DoubleBrickSlab("Double Brick Slab", "stoneDoubleSlab", 43, 4, "brick"),
    DoubleStonebrickSlab("Double Stonebrick Slab", "stoneDoubleSlab", 43, 5, "stonebricksmooth"),
    DoubleNetherBrickSlab("Double Netherbrick Slab", "stoneDoubleSlab", 43, 6, "netherBrick"),
    DoubleQuartzSlab("Double Quartz Slab", "stoneDoubleSlab", 43, 7, "quartzblock_side"),
    SingleStoneSlab("Stone Slab", "stoneSingleSlab", 44, "stoneslab_side[half]"),
    SingleSandStoneSlab("Sandstone Slab", "stoneSingleSlab", 44, 1, "sandstone_side[half]"),
    SingleWoodenSlab("Wooden Slab", "stoneSingleSlab", 44, 2, "wood[half]"),
    SingleCobbleSlab("Cobblestone Slab", "stoneSingleSlab", 44, 3, "stonebrick[half]"),
    SingleBrickSlab("Brick Slab", "stoneSingleSlab", 44, 4, "brick[half]"),
    SingleStonebrickSlab("Stonebrick Slab", "stoneSingleSlab", 44, 5, "stonebricksmooth[half]"),
    SingleNetherBrickSlab("Netherbrick Slab", "stoneSingleSlab", 44, 6, "netherBrick[half]"),
    SingleQuartzSlab("Quartz Slab", "stoneSingleSlab", 44, 7, "quartzblock_side[half]"),
    brick("brick", "brick", 45, "brick"),
    tnt("tnt", "tnt", 46, "tnt_side"),
    bookShelf("bookShelf", "bookShelf", 47, "bookshelf"),
    cobblestoneMossy("CobblestoneMossy", "cobblestoneMossy", 48, "stoneMoss"),
    obsidian("Obsidian", "obsidian", 49, "obsidian"),
    torchWood("TorchWood", "torchWood", 50, "torch"),
    fire("Fire", "fire", 51, "fire_0"),
    mobSpawner("MobSpawner", "mobSpawner", 52, "mobSpawner"),
    stairCompactPlanks("StairCompactPlanks", "stairCompactPlanks", 53, "wood"),
    chest("Chest", "chest", 54, "wood"),
    redstoneWire("RedstoneWire", "redstoneWire", 55, "redstoneDust_cross"),
    oreDiamond("OreDiamond", "oreDiamond", 56, "oreDiamond"),
    blockDiamond("BlockDiamond", "blockDiamond", 57, "blockDiamond"),
    workbench("Workbench", "workbench", 58, "workbench_top"),
    crops("Crops", "crops", 59, "crops_7"),
    tilledField("TilledField", "tilledField", 60, "farmland_dry"),
    stoneOvenIdle("Furnace", "stoneOvenIdle", 61, "furnace_front"),
    stoneOvenActive("Furnace Active", "stoneOvenActive", 62, "furnace_front_lit"),
    signPost("signPost", "signPost", 63, "wood"),
    doorWood("doorWood", "doorWood", 64, "doorWood_upper"),
    ladder("ladder", "ladder", 65, "ladder"),
    rail("rail", "rail", 66, "rail"),
    stairCompactCobblestone("stairCompactCobblestone", "stairCompactCobblestone", 67, "stonebrick[stairs]"),
    signWall("signWall", "signWall", 68, "wood"),
    lever("lever", "lever", 69, "lever"),
    pressurePlateStone("pressurePlateStone", "pressurePlateStone", 70, "stone"),
    doorSteel("doorSteel", "doorSteel", 71, "doorIron_upper"),
    pressurePlatePlanks("pressurePlatePlanks", "pressurePlatePlanks", 72, "wood"),
    oreRedstone("oreRedstone", "oreRedstone", 73, "oreRedstone"),
    oreRedstoneGlowing("oreRedstoneGlowing", "oreRedstoneGlowing", 74, "oreRedstone"),
    torchRedstoneIdle("torchRedstoneIdle", "torchRedstoneIdle", 75, "redstoneLight_lit"),
    torchRedstoneActive("torchRedstoneActive", "torchRedstoneActive", 76, "redstoneLight"),
    button("button", "button", 77, "stone"),
    snow("snow", "snow", 78, "snow"),
    ice("ice", "ice", 79, "ice"),
    blockSnow("blockSnow", "blockSnow", 80, "snow"),
    cactus("cactus", "cactus", 81, "cactus_side"),
    blockClay("blockClay", "blockClay", 82, "clay"),
    reed("reed", "reed", 83, "reeds"),
    jukebox("jukebox", "jukebox", 84, "jukebox_top"),
    fence("fence", "fence", 85, "wood"),
    pumpkin("pumpkin", "pumpkin", 86, "pumkin_face"),
    netherrack("netherrack", "netherrack", 87, "hellrock"),
    slowSand("slowSand", "slowSand", 88, "hellsand"),
    glowStone("glowStone", "glowStone", 89, "lightgem"),
    portal("portal", "portal", 90, "portal"),
    pumpkinLantern("pumpkinLantern", "pumpkinLantern", 91, "pumpkin_jack"),
    cake("cake", "cake", 92, "cake_side"),
    redstoneRepeaterIdle("redstoneRepeaterIdle", "redstoneRepeaterIdle", 93, "repeater"),
    redstoneRepeaterActive("redstoneRepeaterActive", "redstoneRepeaterActive", 94, "repeater_lit"),
    lockedChest("lockedChest", "lockedChest", 95, "wood"),
    trapdoor("trapdoor", "trapdoor", 96, "trapdoor"),
    silverfish("silverfish", "silverfish", 97, "monsterStoneEgg"),
    stoneBrick("stoneBrick", "stoneBrick", 98, "stonebricksmooth"),
    mushroomCapBrown("mushroomCapBrown", "mushroomCapBrown", 99, "mushroom"),
    mushroomCapRed("mushroomCapRed", "mushroomCapRed", 100, "mushroom"),
    fenceIron("fenceIron", "fenceIron", 101, "fenceIron"),
    thinGlass("thinGlass", "thinGlass", 102, "thinGlass"),
    melon("melon", "melon", 103, "melon"),
    pumpkinStem("pumpkinStem", "pumpkinStem", 104, "pumpkinStem"),
    melonStem("melonStem", "melonStem", 105, "pumkinStem"),
    vine("vine", "vine", 106, "vine"),
    fenceGate("fenceGate", "fenceGate", 107, "fenceGate"),
    stairsBrick("stairsBrick", "stairsBrick", 108, "stairsBrick"),
    stairsStoneBrickSmooth("stairsStoneBrickSmooth", "stairsStoneBrickSmooth", 109, "stairsStoneBrickSmooth"),
    mycelium("mycelium", "mycelium", 110, "mycel"),
    waterlily("waterlily", "waterlily", 111, "waterlily"),
    netherBrick("netherBrick", "netherBrick", 112, "netherBrick"),
    netherFence("netherFence", "netherFence", 113, "netherFence"),
    stairsNetherBrick("stairsNetherBrick", "stairsNetherBrick", 114, "stairsNetherBrick"),
    netherStalk("netherStalk", "netherStalk", 115, "netherStalk"),
    enchantmentTable("enchantmentTable", "enchantmentTable", 116, "enchantmentTable"),
    brewingStand("brewingStand", "brewingStand", 117, "brewingStand"),
    cauldron("cauldron", "cauldron", 118, "cauldron"),
    endPortal("endPortal", "endPortal", 119, "portal"),
    endPortalFrame("endPortalFrame", "endPortalFrame", 120, "endPortalFrame"),
    whiteStone("whiteStone", "whiteStone", 121, "whiteStone"),
    dragonEgg("dragonEgg", "dragonEgg", 122, "dragonEgg"),
    redstoneLampIdle("redstoneLampIdle", "redstoneLampIdle", 123, "redstoneLight"),
    redstoneLampActive("redstoneLampActive", "redstoneLampActive", 124, "restoneLight"),
    woodDoubleSlab("woodDoubleSlab", "woodDoubleSlab", 125, "woodSlab"),
    woodSingleSlab("woodSingleSlab", "woodSingleSlab", 126, "woodSlab"),
    cocoa("cocoa", "cocoa", 127, "cacoa"),
    stairsSandStone("stairsSandStone", "stairsSandStone", 128, "stairsSandStone"),
    oreEmerald("oreEmerald", "oreEmerald", 129, "oreEmerald"),
    enderChest("enderChest", "enderChest", 130, "enderChest"),
    tripWireSource("tripWireSource", "tripWireSource", 131, "tripWireSource"),
    tripWire("tripWire", "tripWire", 132, "tripWire"),
    blockEmerald("blockEmerald", "blockEmerald", 133, "blockEmerald"),
    stairsWoodSpruce("stairsWoodSpruce", "stairsWoodSpruce", 134, "stairsWoodSpruce"),
    stairsWoodBirch("stairsWoodBirch", "stairsWoodBirch", 135, "stairsWoodBirch"),
    stairsWoodJungle("stairsWoodJungle", "stairsWoodJungle", 136, "stairsWoodJungle"),
    commandBlock("commandBlock", "commandBlock", 137, "commandBlock"),
    beacon("beacon", "beacon", 138, "beacon"),
    cobbleWall("cobbleWall", "cobblestoneWall", 139, "cobbleWall"),
    flowerPot("flowerPot", "flowerPot", 140, "flowerPot"),
    carrots("carrots", "carrot", 141, "carrots"),
    potatoes("potato", "potato", 142, "potatoes"),
    woodenButton("button", "woodenButton", 143, "button"),
    skull("skull", "skull", 144, "skull"),
    anvil("anvil", "anvil", 145, "anvil"),
    chestTrapped("ChestTrapped", "chestTrapped", 146, "chestTrap"),
    pressurePlateGold("Pressure Plate Gold", "pressurePlateGold", 147, "weightedPlate_light"),
    pressurePlateIron("Pressure Plate Iron", "pressurePlateIron", 148, "weightedPlate_heavy"),
    redstoneComparatorIdle("redstoneComparatorIdle", "redstoneComparatorIdle", 149, "comparator"),
    redstoneComparatorActive("redstoneComparatorActive", "redstoneComparatorActive", 150, "comparator"),
    daylightSensor("daylightSensor", "daylightSensor", 151, "daylightDetector"),
    blockRedstone("blockRedstone", "blockRedstone", 152, "blockRedstone"),
    oreNetherQuartz("oreNetherQuartz", "oreNetherQuartz", 153, "netherquartz"),
    hopperBlock("hopperBlock", "hopperBlock", 154, "hopper"),
    blockNetherQuartz("blockNetherQuartz", "blockNetherQuartz", 155, "quartzBlock"),
    stairCompactNetherQuartz("stairCompactNetherQuartz", "stairCompactNetherQuartz", 156, "stairsQuartz"),
    railActivator("railActivator", "railActivator", 157, "activatorRail"),
    dropper("dropper", "dropper", 158, "dropper"),
    BlockColoredBlack("Black Clay", "field_111039_cA", 159, 0x1E1B1B),
    BlockColoredRed("Red Clay", "field_111039_cA", 159, 1, 11743532),
    BlockColoredGreen("Green Clay", "field_111039_cA", 159, 2, 3887386),
    BlockColoredBrown("Brown Clay", "field_111039_cA", 159, 3, 3887386),
    BlockColoredBlue("Blue Clay", "field_111039_cA", 159, 4, 2437522),
    BlockColoredPurple("Purple Clay", "field_111039_cA", 159, 5, 8073150),
    BlockColoredCyan("Cyan Clay", "field_111039_cA", 159, 6, 2651799),
    BlockColoredSilver("Silver Clay", "field_111039_cA", 159, 7, 0xABABAB),
    BlockColoredGray("Gray Clay", "field_111039_cA", 159, 8, 0x434343),
    BlockColoredPink("Pink Clay", "field_111039_cA", 159, 9, 14188952),
    BlockColoredLime("Lime Clay", "field_111039_cA", 159, 10, 4312372),
    BlockColoredYellow("Yellow Clay", "field_111039_cA", 159, 11, 14602026),
    BlockColoredLightBlue("Light Blue Clay", "field_111039_cA", 159, 12, 6719955),
    BlockColoredMagenta("Magenta Clay", "field_111039_cA", 159, 13, 12801229),
    BlockColoredOrange("Orange Clay", "field_111039_cA", 159, 14, 15435844),
    BlockColoredWhite("White Clay", "field_111039_cA", 159, 15, 0xF0F0F0),
    BlockHay("Hay Bale", "field_111038_cB", 170, "hayBlock_side"),
    BlockCarpetBlack("Black Carpet", "field_111031_cC", 171, 0x1E1B1B),
    BlockCarpetRed("Red Carpet", "field_111031_cC", 171, 1, 11743532),
    BlockCarpetGreen("Green Carpet", "field_111031_cC", 171, 2, 3887386),
    BlockCarpetBrown("Brown Carpet", "field_111031_cC", 171, 3, 3887386),
    BlockCarpetBlue("Blue Carpet", "field_111031_cC", 171, 4, 2437522),
    BlockCarpetPurple("Purple Carpet", "field_111031_cC", 171, 5, 8073150),
    BlockCarpetCyan("Cyan Carpet", "field_111031_cC", 171, 6, 2651799),
    BlockCarpetSilver("Silver Carpet", "field_111031_cC", 171, 7, 0xABABAB),
    BlockCarpetGray("Gray Carpet", "field_111031_cC", 171, 8, 0x434343),
    BlockCarpetPink("Pink Carpet", "field_111031_cC", 171, 9, 14188952),
    BlockCarpetLime("Lime Carpet", "field_111031_cC", 171, 10, 4312372),
    BlockCarpetYellow("Yellow Carpet", "field_111031_cC", 171, 11, 14602026),
    BlockCarpetLightBlue("Light Blue Carpet", "field_111031_cC", 171, 12, 6719955),
    BlockCarpetMagenta("Magenta Carpet", "field_111031_cC", 171, 13, 12801229),
    BlockCarpetOrange("Orange Carpet", "field_111031_cC", 171, 14, 15435844),
    BlockCarpetWhite("White Carpet", "field_111031_cC", 171, 15, 0xF0F0F0),
    HardenedClay("Hardened Clay", "field_111032_cD", 172, "clayHardened"),
    CoalBlock("Block of Coal", "field_111034_cE", 173, "blockCoal"),
    shovelSteel(0, 82, "shovelSteel", "shovelSteel"),
    pickaxeSteel(1, 98, "pickaxeSteel", "pickaxeSteel"),
    axeSteel(2, 114, "axeSteel", "axeSteel"),
    flintAndSteel(3, 5, "flintAndSteel", "flintAndSteel"),
    appleRed(4, 10, "appleRed", "appleRed"),
    bow(5, 21, "bow", "bow"),
    arrow(6, 37, "arrow", "arrow"),
    coal(7, 7, "coal", "coal"),
    charcoal(7, 1, 7, "charcoal", "coal"),
    diamond(8, 55, "diamond", "diamond"),
    ingotIron(9, 23, "ingotIron", "ingotIron"),
    ingotGold(10, 39, "ingotGold", "ingotGold"),
    swordSteel(11, 66, "swordSteel", "swordSteel"),
    swordWood(12, 64, "swordWood", "swordWood"),
    shovelWood(13, 80, "shovelWood", "shovelWood"),
    pickaxeWood(14, 96, "pickaxeWood", "pickaxeWood"),
    axeWood(15, 112, "axeWood", "axeWood"),
    swordStone(16, 65, "swordStone", "swordStone"),
    shovelStone(17, 81, "shovelStone", "shovelStone"),
    pickaxeStone(18, 97, "pickaxeStone", "pickaxeStone"),
    axeStone(19, 113, "axeStone", "axeStone"),
    swordDiamond(20, 67, "swordDiamond", "swordDiamond"),
    shovelDiamond(21, 83, "shovelDiamond", "shovelDiamond"),
    pickaxeDiamond(22, 99, "pickaxeDiamond", "pickaxeDiamond"),
    axeDiamond(23, 115, "axeDiamond", "axeDiamond"),
    stick(24, 53, "stick", "stick"),
    bowlEmpty(25, 71, "bowlEmpty", "bowlEmpty"),
    bowlSoup(26, 72, "bowlSoup", "bowlSoup"),
    swordGold(27, 68, "swordGold", "swordGold"),
    shovelGold(28, 84, "shovelGold", "shovelGold"),
    pickaxeGold(29, 100, "pickaxeGold", "pickaxeGold"),
    axeGold(30, 116, "axeGold", "axeGold"),
    silk(31, 8, "string", "silk"),
    feather(32, 24, "feather", "feather"),
    gunpowder(33, 40, "gunpowder", "gunpowder"),
    hoeWood(34, 128, "hoeWood", "hoeWood"),
    hoeStone(35, 129, "hoeStone", "hoeStone"),
    hoeSteel(36, 130, "hoeSteel", "hoeSteel"),
    hoeDiamond(37, 131, "hoeDiamond", "hoeDiamond"),
    hoeGold(38, 132, "hoeGold", "hoeGold"),
    seeds(39, 9, "seeds", "seeds"),
    wheat(40, 25, "wheat", "wheat"),
    bread(41, 41, "bread", "bread"),
    helmetLeather(42, 0, "helmetLeather", "helmetLeather"),
    plateLeather(43, 16, "plateLeather", "plateLeather"),
    legsLeather(44, 32, "legsLeather", "legsLeather"),
    bootsLeather(45, 48, "bootsLeather", "bootsLeather"),
    helmetChain(46, 1, "helmetChain", "helmetChain"),
    plateChain(47, 17, "plateChain", "plateChain"),
    legsChain(48, 33, "legsChain", "legsChain"),
    bootsChain(49, 49, "bootsChain", "bootsChain"),
    helmetSteel(50, 2, "helmetSteel", "helmetSteel"),
    plateSteel(51, 18, "plateSteel", "plateSteel"),
    legsSteel(52, 34, "legsSteel", "legsSteel"),
    bootsSteel(53, 50, "bootsSteel", "bootsSteel"),
    helmetDiamond(54, 3, "helmetDiamond", "helmetDiamond"),
    plateDiamond(55, 19, "plateDiamond", "plateDiamond"),
    legsDiamond(56, 35, "legsDiamond", "legsDiamond"),
    bootsDiamond(57, 51, "bootsDiamond", "bootsDiamond"),
    helmetGold(58, 4, "helmetGold", "helmetGold"),
    plateGold(59, 20, "plateGold", "plateGold"),
    legsGold(60, 36, "legsGold", "legsGold"),
    bootsGold(61, 52, "bootsGold", "bootsGold"),
    flint(62, 6, "flint", "flint"),
    porkRaw(63, 87, "porkRaw", "porkRaw"),
    porkCooked(64, 88, "porkCooked", "porkCooked"),
    painting(65, 26, "painting", "painting"),
    appleGold(66, 11, "appleGold", "appleGold"),
    sign(67, 42, "sign", "sign"),
    ItemdoorWood(68, 43, "doorWood", "doorWood"),
    bucketEmpty(69, 74, "bucketEmpty", "bucketEmpty"),
    bucketWater(70, 75, "bucketWater", "bucketWater"),
    bucketLava(71, 76, "bucketLava", "bucketLava"),
    minecartEmpty(72, 135, "minecartEmpty", "minecartEmpty"),
    saddle(73, 104, "saddle", "saddle"),
    ItemdoorSteel(74, 44, "doorSteel", "doorSteel"),
    redstone(75, 56, "redstone", "redstone"),
    snowball(76, 153, "snowball", "snowball"),
    boat(77, 136, "boat", "boat"),
    leather(78, 103, "leather", "leather"),
    bucketMilk(79, 77, "bucketMilk", "bucketMilk"),
    Itembrick(80, 22, "brick", "brick"),
    clay(81, 57, "clay", "clay"),
    Itemreed(82, 27, "Sugar Cane", "reed"),
    paper(83, 57, "paper", "paper"),
    book(84, 58, "book", "book"),
    slimeBall(85, 30, "slimeBall", "slimeBall"),
    minecartCrate(86, 151, "minecartCrate", "minecartCrate"),
    minecartPowered(87, 167, "minecartPowered", "minecartPowered"),
    egg(88, 12, "egg", "egg"),
    compass(89, 54, "compass", "compass"),
    fishingRod(90, 69, "fishingRod", "fishingRod"),
    pocketSundial(91, 70, "Clock", "pocketSundial"),
    lightStoneDust(92, 73, "lightStoneDust", "lightStoneDust"),
    fishRaw(93, 89, "fishRaw", "fishRaw"),
    fishCooked(94, 90, "fishCooked", "fishCooked"),
    InkSack(95, 0, 78, "Ink Sack", "dyePowder"),
    RoseRed(95, 1, 94, "Rose Red", "dyePowder"),
    CactusGreen(95, 2, 110, "Cactus Green", "dyePowder"),
    CocoBeans(95, 3, 126, "Coco Beans", "dyePowder"),
    LapisLazuli(95, 4, 142, "Lapis Lazuli", "dyePowder"),
    PurpleDye(95, 5, 158, "Purple Dye", "dyePowder"),
    CyanDye(95, 6, 174, "Cyan Dye", "dyePowder"),
    LightGrayDye(95, 7, 190, "Light Gray Dye", "dyePowder"),
    GrayDye(95, 8, 79, "Gray Dye", "dyePowder"),
    PinkDye(95, 9, 95, "Pink Dye", "dyePowder"),
    LimeDye(95, 10, 111, "Lime Dye", "dyePowder"),
    DandelionYellow(95, 11, 127, "Dandelion Yellow", "dyePowder"),
    LightBlueDye(95, 12, 143, "Light Blue Dye", "dyePowder"),
    MagentaDye(95, 13, 159, "Magenta Dye", "dyePowder"),
    OrangeDye(95, 14, 175, "Orange Dye", "dyePowder"),
    BoneMeal(95, 15, 191, "Bone Meal", "dyePowder"),
    bone(96, 28, "bone", "bone"),
    sugar(97, 13, "sugar", "sugar"),
    Itemcake(98, 29, "cake", "cake"),
    bed(99, 45, "bed", "bed"),
    redstoneRepeater(100, 86, "redstoneRepeater", "redstoneRepeater"),
    cookie(101, 92, "cookie", "cookie"),
    map(102, 60, "map", "map"),
    shears(103, 93, "shears", "shears"),
    Itemmelon(104, 109, "melon", "melon"),
    pumpkinSeeds(105, 60, "pumpkinSeeds", "pumpkinSeeds"),
    melonSeeds(106, 61, "melonSeeds", "melonSeeds"),
    beefRaw(107, 105, "beefRaw", "beefRaw"),
    beefCooked(108, 106, "beefCooked", "beefCooked"),
    chickenRaw(109, 121, "chickenRaw", "chickenRaw"),
    chickenCooked(110, 122, "chickenCooked", "chickenCooked"),
    rottenFlesh(111, 91, "rottenFlesh", "rottenFlesh"),
    enderPearl(112, 107, "enderPearl", "enderPearl"),
    blazeRod(113, 108, "blazeRod", "blazeRod"),
    ghastTear(114, 123, "ghastTear", "ghastTear"),
    goldNugget(115, 124, "goldNugget", "goldNugget"),
    netherStalkSeeds(116, 125, "netherStalkSeeds", "netherStalkSeeds"),
    potion(117, 140, "potion", "potion"),
    glassBottle(118, 140, "glassBottle", "glassBottle"),
    spiderEye(119, 139, "spiderEye", "spiderEye"),
    fermentedSpiderEye(120, 138, "fermentedSpiderEye", "fermentedSpiderEye"),
    blazePowder(121, 157, "blazePowder", "blazePowder"),
    magmaCream(122, 173, "magmaCream", "magmaCream"),
    ItembrewingStand(123, 172, "brewingStand", "brewingStand"),
    Itemcauldron(124, 156, "cauldron", "cauldron"),
    eyeOfEnder(125, 155, "eyeOfEnder", "eyeOfEnder"),
    speckledMelon(126, 137, "speckledMelon", "speckledMelon"),
    monsterPlacer(127, 153, "monsterPlacer", "monsterPlacer"),
    expBottle(128, 171, "expBottle", "expBottle"),
    fireballCharge(129, 46, "fireballCharge", "fireballCharge"),
    writableBook(130, 187, "writableBook", "writableBook"),
    writtenBook(131, 188, "writtenBook", "writtenBook"),
    emerald(133, 186, "emerald", "emerald"),
    frame(133, 206, "frame", "itemFrame"),
    flowerPotItem(134, 189, "flowerPot", "flowerPot"),
    carrotsItem(135, 120, "carrots", "carrot"),
    potato(136, 119, "potato", "potatoe"),
    potatoBaked(137, 118, "potatoBaked", "bakedPotato"),
    potatoPoisonous(138, 134, "potatoPoisonous", "poisonousPotato"),
    emptyMap(139, 205, "emptyMap", "emptyMap"),
    carrotGolden(140, 150, "carrotGolden", "goldenCarrot"),
    skullItem(141, 0, 224, "skull", "skull"),
    endermanItem(141, 1, 225, "enderman", "skull"),
    zombieItem(141, 2, 226, "zombie", "skull"),
    humanItem(141, 3, 227, "human", "skull"),
    creeperItem(141, 4, 228, "creeper", "skull"),
    carrotOnAStick(142, 102, "carrotOnAStick", "carrotOnAStick"),
    netherStar(143, 185, "netherStar", "netherStar"),
    pumpkinPie(144, 152, "pumpkinPie", "pumpkinPie"),
    fireWork("fireworks", "fireworks", 145, "fireworks"),
    fireworksCharge("fireworksCharge", "fireworksCharge", 146, "fireworksCharge"),
    enchantedBook(147, 58, "enchantedBook", "enchantedBook"),
    ironHorseArmorMetal(161, 147, "Iron Horse Armor", "field_111215_ce"),
    goldHorseArmorMetal(162, 146, "Gold Horse Armor", "field_111216_cf"),
    diamondHorseArmorMetal(163, 145, "Diamond Horse Armor", "field_111213_cg"),
    Leash(164, 148, "Lead", "field_111213_ch"),
    nameTag(165, 160, "Name Tag", "field_111212_ci"),
    record13(2000, 240, "record13", "record13"),
    recordCat(2001, 241, "recordCat", "recordCat"),
    recordBlocks(2002, 242, "recordBlocks", "recordBlocks"),
    recordChirp(2003, 243, "recordChirp", "recordChirp"),
    recordFar(2004, 244, "recordFar", "recordFar"),
    recordMall(2005, 245, "recordMall", "recordMall"),
    recordMellohi(2006, 246, "recordMellohi", "recordMellohi"),
    recordStal(2007, 247, "recordStal", "recordStal"),
    recordStrad(2008, 248, "recordStrad", "recordStrad"),
    recordWard(2009, 249, "recordWard", "recordWard"),
    record11(2010, 250, "record11", "record11");

    public static EnumBlock[] blocks;
    public static EnumBlock[] items;
    private BufferedImageSeri texture;
    private final String key;
    private final int id;
    private final String name;
    private final String javaName;
    private final byte metaData;
    private final int color;

    public static EnumBlock getById(String id) {
        for (EnumBlock block : blocks) {
            if (!block.getId().equals(id)) continue;
            return block;
        }
        for (EnumBlock item : items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    private EnumBlock(int id, int tex, String name, String javaName) {
        this(id, 0, tex, name, javaName);
    }

    private EnumBlock(int id, int metaData, int tex, String name, String javaName) {
        this.texture = Textures.getTexture(tex + 256);
        this.key = null;
        this.id = id += 256;
        this.name = name;
        this.javaName = javaName;
        this.metaData = (byte)metaData;
        this.color = -1;
    }

    private EnumBlock(String name, String javaName, int id, String key) {
        this(name, javaName, id, 0, key);
    }

    private EnumBlock(String name, String javaName, int id, byte metaData, String key) {
        this.name = name;
        this.javaName = javaName;
        this.id = id;
        this.metaData = metaData;
        this.key = key;
        this.color = -1;
    }

    private EnumBlock(String name, String javaName, int id, int color) {
        this(name, javaName, id, 0, color);
    }

    private EnumBlock(String name, String javaName, int id, byte metaData, int color) {
        this.name = name;
        this.javaName = javaName;
        this.id = id;
        this.metaData = metaData;
        this.key = null;
        this.color = color;
    }

    public BufferedImageSeri getTexture() {
        if (this.texture == null) {
            if (this.color > -1) {
                BufferedImage i = Textures.getBlankImage(new Color(this.color));
                if (i == null) {
                    return null;
                }
                this.texture = new BufferedImageSeri(i);
            } else {
                BufferedImage i = this.loadImage(this.isBlock() ? "blocks" : "items", this.key);
                if (i == null) {
                    return null;
                }
                this.texture = new BufferedImageSeri(i);
            }
        }
        return this.texture;
    }

    public String getName() {
        if (this.name.equals("")) {
            return this.javaName;
        }
        return this.name;
    }

    public String getId() {
        if (this.metaData != 0) {
            return String.valueOf(this.id) + ":" + String.valueOf(this.metaData);
        }
        return String.valueOf(this.id);
    }

    public String getJavaName() {
        if (this.id < 256) {
            return "Block." + this.javaName;
        }
        return "Item." + this.javaName;
    }

    public boolean isBlock() {
        return this.id < 256;
    }

    public BufferedImage loadImage(String type, String key) {
        File mcJar;
        if (key == null) {
            return Textures.getBlankImage(new Color(0, 0, 0, 0));
        }
        boolean half = false;
        if (key.endsWith("[half]")) {
            half = true;
            key = key.substring(0, key.length() - "[half]".length());
        }
        if ((mcJar = new File(Settings.getRoot() + "/MCP/jars/versions/1.6.2/1.6.2.jar")).exists() && key != null && !"".equals(key)) {
            try {
                URL url = new URL("jar:file:/" + mcJar.getPath() + "!/assets/minecrafttextures/" + type + "/" + key + ".png");
                BufferedImage image = ImageIO.read(url);
                if (half) {
                    BufferedImage preImage = image.getSubimage(0, 0, 16, 8);
                    image = new BufferedImage(16, 16, 2);
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 8; ++y) {
                            image.setRGB(x, y + 4, preImage.getRGB(x, y));
                        }
                    }
                } else {
                    image = image.getSubimage(0, 0, 16, 16);
                }
                return image;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return Textures.getNoTexture();
    }

    static {
        blocks = new EnumBlock[]{Air, Stone, Grass, Dirt, CobbleStone, Wood0, Wood1, Wood2, Wood3, Sapling0, Sapling1, Sapling1, Sapling2, Sapling3, BedRock, Water, StationaryWater, Lava, StationaryLava, Sand, Gravel, GoldOre, IronOre, CoalOre, Logs0, Logs1, Logs2, Logs3, Sponge, Glass, LapisLazuliOre, LapisLazuliBlock, Dispencer, SandStone0, SandStone1, SandStone2, NoteBlock, Bed, PoweredRail, DetectorRail, StickyPiston, Web, DeadShrub, TailGrass, LiveShrub, DeadShrub2, Piston, PistonHead, WhiteWool, OrangeWool, MagentaWool, LightBlueWool, YellowWool, LightGreenWool, PinkWool, GrayWool, LightGrayWool, CyanWool, PurpleWool, BlueWool, BrownWool, DarkGreenWool, RedWool, BlackWool, Dandelion, Rose, BrownMushroom, RedMushroom, Goldblock, IronBlock, DoubleStoneSlab, DoubleSandStoneSlab, DoubleWoodenSlab, DoubleCobbleSlab, DoubleBrickSlab, DoubleStonebrickSlab, DoubleNetherBrickSlab, DoubleQuartzSlab, SingleStoneSlab, SingleSandStoneSlab, SingleWoodenSlab, SingleCobbleSlab, SingleBrickSlab, SingleStonebrickSlab, SingleNetherBrickSlab, SingleQuartzSlab, brick, tnt, bookShelf, cobblestoneMossy, obsidian, torchWood, fire, mobSpawner, stairCompactPlanks, chest, redstoneWire, oreDiamond, blockDiamond, workbench, crops, tilledField, stoneOvenIdle, stoneOvenActive, signPost, doorWood, ladder, rail, stairCompactCobblestone, signWall, lever, pressurePlateStone, doorSteel, pressurePlatePlanks, oreRedstone, oreRedstoneGlowing, torchRedstoneIdle, torchRedstoneActive, button, snow, ice, blockSnow, cactus, blockClay, reed, jukebox, fence, pumpkin, netherrack, slowSand, glowStone, portal, pumpkinLantern, cake, redstoneRepeaterIdle, redstoneRepeaterActive, lockedChest, trapdoor, silverfish, stoneBrick, mushroomCapBrown, mushroomCapRed, fenceIron, thinGlass, melon, pumpkinStem, melonStem, vine, fenceGate, stairsBrick, stairsStoneBrickSmooth, mycelium, waterlily, netherBrick, netherFence, stairsNetherBrick, netherStalk, enchantmentTable, brewingStand, cauldron, endPortal, endPortalFrame, woodDoubleSlab, woodSingleSlab, cocoa, stairsSandStone, oreEmerald, enderChest, tripWireSource, tripWire, blockEmerald, stairsWoodSpruce, stairsWoodBirch, stairsWoodJungle, commandBlock, beacon, cobbleWall, flowerPot, carrots, potatoes, woodenButton, skull, anvil, chestTrapped, pressurePlateIron, pressurePlateGold, redstoneComparatorIdle, redstoneComparatorActive, daylightSensor, blockRedstone, oreNetherQuartz, blockNetherQuartz, railActivator, dropper, BlockColoredBlack, BlockColoredRed, BlockColoredGreen, BlockColoredBrown, BlockColoredBlue, BlockColoredPurple, BlockColoredCyan, BlockColoredSilver, BlockColoredGray, BlockColoredPink, BlockColoredLime, BlockColoredYellow, BlockColoredLightBlue, BlockColoredMagenta, BlockColoredOrange, BlockColoredWhite, BlockHay, BlockCarpetBlack, BlockCarpetRed, BlockCarpetGreen, BlockCarpetBrown, BlockCarpetBlue, BlockCarpetPurple, BlockCarpetCyan, BlockCarpetSilver, BlockCarpetGray, BlockCarpetLime, BlockCarpetYellow, BlockCarpetLightBlue, BlockCarpetMagenta, BlockCarpetOrange, BlockCarpetWhite, HardenedClay, CoalBlock};
        items = new EnumBlock[]{shovelSteel, pickaxeSteel, axeSteel, flintAndSteel, appleRed, bow, arrow, coal, charcoal, diamond, ingotIron, ingotGold, swordSteel, swordWood, shovelWood, pickaxeWood, axeWood, swordStone, shovelStone, pickaxeStone, axeStone, swordDiamond, shovelDiamond, pickaxeDiamond, axeDiamond, stick, bowlEmpty, bowlSoup, swordGold, shovelGold, pickaxeGold, axeGold, silk, feather, gunpowder, hoeWood, hoeStone, hoeSteel, hoeDiamond, hoeGold, seeds, wheat, bread, helmetLeather, plateLeather, legsLeather, bootsLeather, helmetChain, plateChain, legsChain, bootsChain, helmetSteel, plateSteel, legsSteel, bootsSteel, helmetDiamond, plateDiamond, legsDiamond, bootsDiamond, helmetGold, plateGold, legsGold, bootsGold, flint, porkRaw, porkCooked, painting, appleGold, sign, ItemdoorWood, bucketEmpty, bucketWater, bucketLava, minecartEmpty, saddle, ItemdoorSteel, redstone, snowball, boat, leather, bucketMilk, Itembrick, clay, Itemreed, paper, book, slimeBall, minecartCrate, minecartPowered, egg, compass, fishingRod, pocketSundial, lightStoneDust, fishRaw, fishCooked, InkSack, RoseRed, CactusGreen, CocoBeans, LapisLazuli, PurpleDye, CyanDye, LightGrayDye, GrayDye, PinkDye, PinkDye, LimeDye, DandelionYellow, LightBlueDye, MagentaDye, OrangeDye, BoneMeal, bone, sugar, Itemcake, bed, redstoneRepeater, cookie, map, shears, Itemmelon, pumpkinSeeds, melonSeeds, beefRaw, beefCooked, chickenRaw, chickenCooked, rottenFlesh, enderPearl, blazeRod, ghastTear, goldNugget, netherStalkSeeds, potion, glassBottle, spiderEye, fermentedSpiderEye, blazePowder, magmaCream, ItembrewingStand, Itemcauldron, eyeOfEnder, speckledMelon, monsterPlacer, expBottle, fireballCharge, writableBook, writtenBook, emerald, frame, flowerPotItem, carrotsItem, potato, potatoBaked, potatoPoisonous, emptyMap, carrotGolden, skullItem, endermanItem, zombieItem, humanItem, creeperItem, carrotOnAStick, netherStar, pumpkinPie, fireWork, fireworksCharge, enchantedBook, ironHorseArmorMetal, goldHorseArmorMetal, diamondHorseArmorMetal, Leash, nameTag, record13, recordCat, recordBlocks, recordChirp, recordFar, recordMall, recordMellohi, recordStal, recordStrad, record11};
    }
}

