/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.LogDialog;
import net.modmaker.Gui.Dialogs.Working;
import net.modmaker.Gui.MainPanel;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.customcode.CustomCodeDialog;

public class McpScripts {
    private static Process Start(String file) throws IOException {
        Console.Info("Run Mcp Script: " + file);
        Settings.put("modmaker.reobf", "false");
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            File dir = new File(Settings.getRoot() + "/MCP");
            dir.getParentFile().mkdirs();
            pb.directory(dir);
            ArrayList<String> args = new ArrayList<String>();
            args.add(dir.getCanonicalPath() + "\\runtime\\bin\\python\\python_mcp.exe");
            args.add("runtime\\" + file);
            pb.command(args);
            return pb.start();
        }
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            File dir = new File(Settings.getRoot() + "/MCP/runtime");
            dir.getParentFile().mkdirs();
            pb.directory(dir);
            ArrayList<String> args = new ArrayList<String>();
            args.add("python");
            args.add(file);
            pb.command(args);
            return pb.start();
        }
        return null;
    }

    public static Process Cleanup() throws IOException {
        Process cleanup = McpScripts.Start("cleanup.py");
        return cleanup;
    }

    public static Process Decompile() throws IOException {
        Process decompile = McpScripts.Start("decompile.py");
        return decompile;
    }

    public static Process getChangedSrc() throws IOException {
        Process getchangedsrc = McpScripts.Start("getchangedsrc.py");
        return getchangedsrc;
    }

    public static void Recompile(ModManager mm) throws Exception {
        final Working w = new Working("Recompiling");
        try {
            String line;
            new Thread(){

                @Override
                public void run() {
                    w.setVisible(true);
                }
            }.start();
            MainPanel.setIndeterminate(true);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setIndeterminate(true);
            }
            Process p = McpScripts.Start("recompile.py");
            ThreadManager.addProcess(p, "Recompiling");
            BufferedReader bf = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            ArrayList<String> log = new ArrayList<String>();
            boolean error = false;
            while ((line = bf.readLine()) != null) {
                Console.Script(line);
                log.add(line);
                MainPanel.setProgress(line, 0);
                if (CustomCodeDialog.getCustomCode() != null) {
                    CustomCodeDialog.getCustomCode().setProgress(line, 0);
                }
                if (!line.equalsIgnoreCase("== ERRORS FOUND in JAVA CODE ==")) continue;
                error = true;
            }
            ThreadManager.removeProcess("Recompiling");
            if (error) {
                MainPanel.setProgress("Recompiling Failed!", 0);
                if (CustomCodeDialog.getCustomCode() != null) {
                    CustomCodeDialog.getCustomCode().setProgress("Recompiling Failed!", 0);
                }
                String text = "";
                for (String str : log) {
                    if (text.equals("")) {
                        text = str;
                        continue;
                    }
                    text = text + "\n" + str;
                }
                w.setVisible(false);
                w.dispose();
                LogDialog ld = new LogDialog(text, true, mm);
                ld.setVisible(true);
                throw new IOException("Recompile Error");
            }
            MainPanel.setProgress("Recompiling Done!", 100);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setProgress("Recompiling Done!", 100);
            }
            w.setVisible(false);
            w.dispose();
        }
        catch (Exception e) {
            MainPanel.setIndeterminate(false);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setIndeterminate(false);
            }
            w.setVisible(false);
            w.dispose();
            throw e;
        }
    }

    public static Process Reformat() throws IOException {
        return McpScripts.Start("reformat.py");
    }

    public static void ReObfuscate(ModManager mm) throws IOException, Exception {
        final Working w = new Working("ReObfuscating");
        try {
            String line;
            new Thread(){

                @Override
                public void run() {
                    w.setVisible(true);
                }
            }.start();
            MainPanel.setIndeterminate(true);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setIndeterminate(true);
            }
            Process p = McpScripts.Start("reobfuscate.py");
            ThreadManager.addProcess(p, "ReObjfuscating");
            BufferedReader bf = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            ArrayList<String> log = new ArrayList<String>();
            boolean error = false;
            while ((line = bf.readLine()) != null) {
                Console.Script(line);
                MainPanel.setProgress(line, 0);
                if (CustomCodeDialog.getCustomCode() != null) {
                    CustomCodeDialog.getCustomCode().setProgress(line, 0);
                }
                log.add(line);
                if (!line.equalsIgnoreCase("== ERRORS FOUND ==")) continue;
                error = true;
            }
            if (error) {
                MainPanel.setProgress("ReObjfuscating Failed!", 0);
                if (CustomCodeDialog.getCustomCode() != null) {
                    CustomCodeDialog.getCustomCode().setProgress("ReObjfuscating Failed!", 0);
                }
                String text = "";
                for (String str : log) {
                    if (text.equals("")) {
                        text = str;
                        continue;
                    }
                    text = text + "\n" + str;
                }
                w.setVisible(false);
                w.dispose();
                LogDialog ld = new LogDialog(text, true, mm);
                ld.setVisible(true);
                throw new IOException("ReObjuscate Error");
            }
            MainPanel.setProgress("ReObjfuscating Done!", 100);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setProgress("ReObjfuscating Done!", 100);
            }
            MainPanel.setIndeterminate(false);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setIndeterminate(false);
            }
            w.setVisible(false);
            w.dispose();
        }
        catch (Exception ex) {
            MainPanel.setIndeterminate(false);
            if (CustomCodeDialog.getCustomCode() != null) {
                CustomCodeDialog.getCustomCode().setIndeterminate(false);
            }
            w.setVisible(false);
            w.dispose();
            throw ex;
        }
    }

    public static Process StartClient() throws IOException {
        return McpScripts.Start("startclient.py");
    }

    public static Process StartServer() throws IOException {
        return McpScripts.Start("startserver.py");
    }

    public static Process updateMCP() throws IOException {
        return McpScripts.Start("updatemcp.py");
    }

    public static Process updateMd5() throws IOException {
        return McpScripts.Start("updatemd5.py");
    }

    public static Process updateNames() throws IOException {
        return McpScripts.Start("updatenames.py");
    }

    public static Process updateIds() throws IOException {
        return McpScripts.Start("updateids.py");
    }

    public static void PToOut(Process p, String name) throws Exception {
        try {
            String line;
            MainPanel.setIndeterminate(true);
            ThreadManager.addProcess(p, name);
            BufferedReader bf = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            ArrayList<String> log = new ArrayList<String>();
            boolean error = false;
            while ((line = bf.readLine()) != null) {
                Console.Script(line);
                MainPanel.setProgress(line, 0);
                log.add(line);
                if (line.equalsIgnoreCase("== ERRORS FOUND ==")) {
                    error = true;
                }
                if (!line.startsWith("FATAL ERROR")) continue;
                error = true;
            }
            if (error) {
                MainPanel.setProgress(name + " Failed!", 0);
                String text = "";
                for (String str : log) {
                    if (text.equals("")) {
                        text = str;
                        continue;
                    }
                    text = text + "\n" + str;
                }
                LogDialog ld = new LogDialog(text, true, null);
                ld.setVisible(true);
                throw new IOException(name + " Error");
            }
            MainPanel.setProgress(name + " Done!", 100);
            MainPanel.setIndeterminate(false);
            ThreadManager.removeProcess(name);
        }
        catch (Exception ex) {
            throw new Exception("The Editor is already " + name);
        }
    }
}

