/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import net.modmaker.Utils.PotionHealth;

public class Potion {
    public static final Potion[] potionTypes = new Potion[32];
    public static final Potion field_76423_b = null;
    public static final Potion none = new Potion(0, false, 0).setPotionName("potion.<none>");
    public static final Potion moveSpeed = new Potion(1, false, 8171462).setPotionName("potion.moveSpeed").setIconIndex(0, 0);
    public static final Potion moveSlowdown = new Potion(2, true, 5926017).setPotionName("potion.moveSlowdown").setIconIndex(1, 0);
    public static final Potion digSpeed = new Potion(3, false, 14270531).setPotionName("potion.digSpeed").setIconIndex(2, 0).setEffectiveness(1.5);
    public static final Potion digSlowdown = new Potion(4, true, 4866583).setPotionName("potion.digSlowDown").setIconIndex(3, 0);
    public static final Potion damageBoost = new Potion(5, false, 9643043).setPotionName("potion.damageBoost").setIconIndex(4, 0);
    public static final Potion heal = new PotionHealth(6, false, 16262179).setPotionName("potion.heal");
    public static final Potion harm = new PotionHealth(7, true, 4393481).setPotionName("potion.harm");
    public static final Potion jump = new Potion(8, false, 7889559).setPotionName("potion.jump").setIconIndex(2, 1);
    public static final Potion confusion = new Potion(9, true, 5578058).setPotionName("potion.confusion").setIconIndex(3, 1).setEffectiveness(0.25);
    public static final Potion regeneration = new Potion(10, false, 13458603).setPotionName("potion.regeneration").setIconIndex(7, 0).setEffectiveness(0.25);
    public static final Potion resistance = new Potion(11, false, 10044730).setPotionName("potion.resistance").setIconIndex(6, 1);
    public static final Potion fireResistance = new Potion(12, false, 14981690).setPotionName("potion.fireResistance").setIconIndex(7, 1);
    public static final Potion waterBreathing = new Potion(13, false, 3035801).setPotionName("potion.waterBreathing").setIconIndex(0, 2);
    public static final Potion invisibility = new Potion(14, false, 8356754).setPotionName("potion.invisibility").setIconIndex(0, 1);
    public static final Potion blindness = new Potion(15, true, 2039587).setPotionName("potion.blindness").setIconIndex(5, 1).setEffectiveness(0.25);
    public static final Potion nightVision = new Potion(16, false, 0x1F1FA1).setPotionName("potion.nightVision").setIconIndex(4, 1);
    public static final Potion hunger = new Potion(17, true, 5797459).setPotionName("potion.hunger").setIconIndex(1, 1);
    public static final Potion weakness = new Potion(18, true, 0x484D48).setPotionName("potion.weakness").setIconIndex(5, 0);
    public static final Potion poison = new Potion(19, true, 5149489).setPotionName("potion.poison").setIconIndex(6, 0).setEffectiveness(0.25);
    public static final Potion wither = new Potion(20, true, 3484199).setPotionName("potion.wither").setIconIndex(1, 2).setEffectiveness(0.25);
    public static final Potion field_76434_w = null;
    public static final Potion field_76444_x = null;
    public static final Potion field_76443_y = null;
    public static final Potion field_76442_z = null;
    public static final Potion field_76409_A = null;
    public static final Potion field_76410_B = null;
    public static final Potion field_76411_C = null;
    public static final Potion field_76405_D = null;
    public static final Potion field_76406_E = null;
    public static final Potion field_76407_F = null;
    public static final Potion field_76408_G = null;
    public final int id;
    private String name = "";
    private int statusIconIndex = -1;
    private final boolean isBadEffect;
    private double effectiveness;
    private boolean usable;
    private final int liquidColor;

    public static Potion getPotion(String potionName) {
        Potion ret = null;
        for (Potion p : potionTypes) {
            if (p == null || !p.getName().equals(potionName)) continue;
            ret = p;
        }
        return ret;
    }

    protected Potion(int par1, boolean par2, int par3) {
        this.id = par1;
        Potion.potionTypes[par1] = this;
        this.isBadEffect = par2;
        this.effectiveness = par2 ? 0.5 : 1.0;
        this.liquidColor = par3;
    }

    protected Potion setIconIndex(int par1, int par2) {
        this.statusIconIndex = par1 + par2 * 8;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public boolean isInstant() {
        return false;
    }

    public boolean isReady(int par1, int par2) {
        if (this.id != Potion.regeneration.id && this.id != Potion.poison.id) {
            if (this.id == Potion.wither.id) {
                int var3 = 40 >> par2;
                return var3 > 0 ? par1 % var3 == 0 : true;
            }
            return this.id == Potion.hunger.id;
        }
        int var3 = 25 >> par2;
        return var3 > 0 ? par1 % var3 == 0 : true;
    }

    public Potion setPotionName(String par1Str) {
        this.name = par1Str;
        return this;
    }

    public String getName() {
        return this.name;
    }

    protected Potion setEffectiveness(double par1) {
        this.effectiveness = par1;
        return this;
    }

    public boolean hasStatusIcon() {
        return this.statusIconIndex >= 0;
    }

    public int getStatusIconIndex() {
        return this.statusIconIndex;
    }

    public boolean isBadEffect() {
        return this.isBadEffect;
    }

    public double getEffectiveness() {
        return this.effectiveness;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public int getLiquidColor() {
        return this.liquidColor;
    }
}

