/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.awt.Color;
import net.modmaker.Console.Console;

public abstract class SmootColorChanger
extends Thread {
    private Color cc;
    private Color n;
    private Color o;
    private double dr;
    private double dg;
    private double db;

    public SmootColorChanger(Color old, Color n) {
        this.cc = old;
        this.n = n;
        this.o = old;
        this.dr = -(this.o.getRed() - n.getRed()) / 50;
        this.dg = -(this.o.getGreen() - n.getGreen()) / 50;
        this.db = -(this.o.getBlue() - n.getBlue()) / 50;
    }

    @Override
    public void run() {
        try {
            if (this.o == null) {
                this.onColorChange(this.n);
                return;
            }
            for (int a = 1; a < 51; ++a) {
                int r = (int)((double)this.o.getRed() + this.dr * (double)a);
                int g = (int)((double)this.o.getGreen() + this.dg * (double)a);
                int b = (int)((double)this.o.getBlue() + this.db * (double)a);
                try {
                    if (r < 1) {
                        r = 1;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if (g < 1) {
                        g = 1;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    this.cc = new Color(r, g, b);
                    this.onColorChange(this.cc);
                }
                catch (Exception e) {
                    Console.Warning("Error during changing color: r " + r + ",g " + g + ",b " + b);
                    e.printStackTrace();
                }
                Thread.sleep(20L);
            }
            this.onColorChange(this.n);
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    public abstract void onColorChange(Color var1);

    public Color getCurrentColor() {
        return this.cc;
    }
}

