/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Utils;

import java.util.ArrayList;

public class ThreadManager {
    private static ArrayList<Thread> threads = new ArrayList();
    private static ArrayList<processData> processes = new ArrayList();

    public static void addThread(Thread thread, String name) {
        for (int a = 0; a < threads.size(); ++a) {
            Thread t = threads.get(a);
            if (t.getName().equals(name) && t.isAlive()) {
                throw new RuntimeException("Thread is already running");
            }
            if (!t.getName().equals(name)) continue;
            threads.remove(a);
        }
        thread.setName(name);
        threads.add(thread);
    }

    public static void removeThread(String name) {
        for (int a = 0; a < threads.size(); ++a) {
            if (!threads.get(a).getName().equals(name)) continue;
            threads.remove(a);
        }
    }

    public static void clearThreads() {
        threads.clear();
    }

    public static Thread getThread(String name) {
        for (Thread t : threads) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public static void stopCurrentThreads() {
        for (Thread t : threads) {
            t.stop();
        }
    }

    public static void addProcess(Process p, String name) throws Exception {
        for (int a = 0; a < processes.size(); ++a) {
            processData pd = processes.get(a);
            if (pd.getName().equals(name)) {
                try {
                    pd.getProcess().exitValue();
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Process is already running");
                }
            }
            if (!pd.getName().equals(name)) continue;
            processes.remove(a);
        }
        processes.add(new processData(p, name));
    }

    public static void removeProcess(String name) {
        for (int a = 0; a < processes.size(); ++a) {
            if (!processes.get(a).name.equals(name)) continue;
            processes.remove(a);
        }
    }

    public static void clearProcesses() {
        processes.clear();
    }

    public static ArrayList<Thread> getRunningThreads() {
        ArrayList<Thread> t = new ArrayList<Thread>();
        for (Thread th : threads) {
            if (!th.isAlive()) continue;
            t.add(th);
        }
        return t;
    }

    public static Process getProcess(String name) {
        for (processData p : processes) {
            if (!p.name.equals(name)) continue;
            return p.p;
        }
        return null;
    }

    public static void killCurrentProcesses() {
        for (processData pd : processes) {
            pd.p.destroy();
        }
    }

    public static ArrayList<processData> getRunningProcesses() {
        ArrayList<processData> p = new ArrayList<processData>();
        for (processData pr : processes) {
            try {
                pr.p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                p.add(pr);
            }
        }
        return p;
    }

    public static class processData {
        private final Process p;
        private final String name;

        public processData(Process p, String name) {
            this.p = p;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Process getProcess() {
            return this.p;
        }
    }
}

