/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.backup;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.modmaker.Console.Console;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.ModManager;
import net.modmaker.plugin.PluginManager;

public class Backup {
    private final long time;
    private final int type;
    private boolean hasBackup;
    public static final int AUTO_BACKUP = 0;
    public static final int SAVE_BACKUP = 1;
    public static final int LAUNCH_BACKUP = 2;
    public static final int EXIT_BACKUP = 3;
    public static final int RESTORE_BACKUP = 4;

    public Backup(long time, int type) {
        this(time, type, false);
    }

    public Backup(long time, int type, boolean hasBackup) {
        if (time == 0L || time == 1L) {
            throw new RuntimeException("wrong time");
        }
        this.time = time;
        this.type = type;
        this.hasBackup = hasBackup;
    }

    public long getTime() {
        return this.time;
    }

    public int getType() {
        return this.type;
    }

    public String getDate() {
        Date date = new Date(this.time);
        SimpleDateFormat format = new SimpleDateFormat("HH.mm dd-MM-yyyy");
        return format.format(date);
    }

    public String getTimeAgo() {
        long dt = System.currentTimeMillis() - this.time;
        Date date = new Date(dt);
        SimpleDateFormat dFormat = new SimpleDateFormat("DDDD");
        String days = dFormat.format(date);
        int d = Integer.parseInt(days);
        --d;
        SimpleDateFormat hFormat = new SimpleDateFormat("HH");
        String hours = hFormat.format(date);
        int h = Integer.parseInt(hours);
        if (--h < 0) {
            h = 23;
        }
        SimpleDateFormat mFormat = new SimpleDateFormat("mm");
        String mins = mFormat.format(date);
        int m = Integer.parseInt(mins);
        String out = "";
        if (d > 0) {
            out = d + " Days";
        }
        if (h != 0 || d > 0) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + h + " Hours";
        }
        if (!out.equals("")) {
            out = out + ", ";
        }
        out = out + m + " Minutes";
        return out + " Ago";
    }

    public boolean backup() {
        boolean succeed = true;
        try {
            if (this.hasBackup) {
                throw new RuntimeException("Has already made a backup");
            }
            File backupFile = this.getBackupFile();
            backupFile.mkdirs();
            for (ModManager manager : ModManager.mods) {
                try {
                    File saveFile = SaveManager.saveMod(manager);
                    FileManager.Copy(saveFile, new File(backupFile + "/" + saveFile.getName()));
                }
                catch (Throwable e) {
                    Console.Err(e);
                    succeed = false;
                }
            }
            SaveManager.saveConfig(new File(backupFile + "/Config.cfg"));
            FileManager.Zip(backupFile, backupFile.getParentFile());
            FileManager.Delete(backupFile);
            backupFile.delete();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            Console.Err(e);
            return false;
        }
        this.hasBackup = true;
        return succeed;
    }

    public void restore() throws Exception {
        if (!this.hasBackup) {
            throw new RuntimeException("Hasn't made an backup yet");
        }
        ModManager.mods.clear();
        PluginManager.DisablePlugins();
        FileManager.UnZip(new File(Settings.getRoot() + "/backup/" + this.getTime() + ".zip"), this.getBackupFile());
        FileManager.Copy(new File(this.getBackupFile() + "/Config.cfg"), new File(Settings.getRoot() + "/Config.cfg"));
        for (File saveFile : this.getBackupFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals("Config.cfg");
            }
        })) {
            FileManager.Copy(saveFile, new File(Settings.getRoot() + "/Save/" + saveFile.getName()));
        }
        SaveManager.loadConfig();
        PluginManager.EnablePlugins();
        SaveManager.loadAllMods();
        FileManager.Delete(this.getBackupFile());
        this.getBackupFile().delete();
    }

    public File getBackupFile() {
        return new File(Settings.getRoot() + "/backup/" + this.getTime());
    }

    public boolean hasBackup() {
        return this.hasBackup;
    }

    public String getTypeAsString() {
        if (this.type == 0) {
            return "Auto Backup";
        }
        if (this.type == 1) {
            return "Save Backup";
        }
        if (this.type == 2) {
            return "Launch Backup";
        }
        if (this.type == 3) {
            return "Exit Backup";
        }
        if (this.type == 4) {
            return "Restore Backup";
        }
        return "Unknown";
    }
}

