/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.backup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.Main;
import net.modmaker.backup.Backup;
import net.modmaker.events.ExitEvent;
import net.modmaker.events.Listeners.ExitListener;
import net.modmaker.events.Listeners.UpdateListener;
import net.modmaker.events.UpdateEvent;

public class BackupManager {
    private static ArrayList<Backup> backups = new ArrayList();
    private static ArrayList<UpdateListener> listeners = new ArrayList();
    private static Thread backupSystem;
    private static int timeToDeleteBackup;
    private static ExitListener el;
    public static final int DONTBACKUP = 0;
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int MONTH = 3;
    public static final int NEVER = 4;

    public static void setTimeToDeleteBackup(int i) {
        timeToDeleteBackup = i;
    }

    public static int getTimeToDeleteBackup() {
        return timeToDeleteBackup;
    }

    public static void runBackupSystem() {
        if (backupSystem != null) {
            throw new RuntimeException("Backup system already running");
        }
        backupSystem = new Thread(new Runnable(){

            @Override
            public void run() {
                BackupManager.loadBackup();
                if (timeToDeleteBackup == 0) {
                    backupSystem = null;
                    Thread.currentThread().stop();
                }
                Main.addExitListener(el);
                BackupManager.backup(2);
                block4: while (true) {
                    try {
                        while (true) {
                            BackupManager.checkAllBackups();
                            Thread.sleep(600000L);
                            try {
                                BackupManager.backup(0);
                                continue block4;
                            }
                            catch (Throwable e) {
                                Console.Err(e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
        backupSystem.setName("Backup System");
        backupSystem.start();
    }

    public static void checkAllBackups() {
        long ct = System.currentTimeMillis();
        ArrayList<Backup> remove = new ArrayList<Backup>();
        for (Backup b : backups) {
            if (timeToDeleteBackup == 0) {
                remove.add(b);
                continue;
            }
            if (timeToDeleteBackup == 1 && ct - b.getTime() > 86400000L) {
                remove.add(b);
                continue;
            }
            if (timeToDeleteBackup == 2 && ct - b.getTime() > 604800000L) {
                remove.add(b);
                continue;
            }
            if (timeToDeleteBackup != 3 || ct - b.getTime() <= 2678400000L) continue;
            remove.add(b);
        }
        for (Backup r : remove) {
            backups.remove(r);
            new File(r.getBackupFile().getPath() + ".zip").delete();
        }
        if (timeToDeleteBackup == 0) {
            FileManager.Delete(new File(Settings.getRoot() + "/backup"));
        }
        UpdateEvent evt = new UpdateEvent(new BackupManager());
        for (UpdateListener l : listeners) {
            l.onUpdate(evt);
        }
    }

    public static void stopBackupSystem() {
        backupSystem.stop();
        backupSystem = null;
        Main.removeExitListener(el);
    }

    public static void backup() {
        BackupManager.backup(1);
    }

    private static void backup(int type) {
        backupSystem.interrupt();
        Backup backup = new Backup(System.currentTimeMillis(), type);
        if (!backup.backup()) {
            Console.Warning("Backup failed!");
        } else {
            backups.add(backup);
        }
        BackupManager.saveBackup();
        Console.Info("New Backup: " + backup.getDate());
        UpdateEvent evt = new UpdateEvent(new BackupManager());
        for (UpdateListener l : listeners) {
            l.onUpdate(evt);
        }
    }

    public static void restore(Backup backup) {
        try {
            Backup newB = new Backup(System.currentTimeMillis(), 4);
            if (!newB.backup()) {
                throw new RuntimeException("New backup failed!");
            }
            backups.add(newB);
            backup.restore();
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(Settings.getFrame(), "Something went wrong with restoring your backup", "Error!", 0);
        }
    }

    public static void restore(String d) {
        try {
            Backup backup = null;
            for (int a = 0; a < backups.size(); ++a) {
                Backup b = backups.get(a);
                if (!d.equals(b.getTime())) continue;
                backup = b;
                backups.remove(a);
            }
            if (backup == null) {
                throw new RuntimeException("Could not find backup");
            }
            Backup newB = new Backup(System.currentTimeMillis(), 4);
            if (!newB.backup()) {
                throw new RuntimeException("New backup failed!");
            }
            backups.add(newB);
            backup.restore();
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(Settings.getFrame(), "Something went wrong with restoring your backup", "Error!", 0);
        }
    }

    public static void saveBackup() {
        try {
            BufferedWriter bf = new BufferedWriter(new FileWriter(Settings.getRoot() + "/backup.ini"));
            bf.write("TimeToDeleteBackup:" + timeToDeleteBackup);
            bf.newLine();
            for (Backup b : backups) {
                bf.write(b.getType() + ":" + b.getTime() + ":" + b.hasBackup());
                bf.newLine();
            }
            bf.flush();
            bf.close();
            Console.Info("Save backups");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void loadBackup() {
        try {
            String line;
            BufferedReader bf = new BufferedReader(new FileReader(Settings.getRoot() + "/backup.ini"));
            ArrayList<Backup> bk = new ArrayList<Backup>();
            while ((line = bf.readLine()) != null) {
                try {
                    if (!line.contains(":")) continue;
                    String[] sp = line.split(":");
                    if (sp.length == 3) {
                        boolean hb;
                        int type = Integer.parseInt(sp[0]);
                        long time = Long.parseLong(sp[1]);
                        Backup b = new Backup(time, type, hb = Boolean.parseBoolean(sp[2]));
                        if (!b.hasBackup()) {
                            bk.add(b);
                            continue;
                        }
                        File backupFile = new File(b.getBackupFile().getPath() + ".zip");
                        if (!backupFile.exists() || !backupFile.isFile()) continue;
                        bk.add(b);
                        continue;
                    }
                    if (sp.length != 2 || !sp[0].equals("TimeToDeleteBackup")) continue;
                    timeToDeleteBackup = Integer.parseInt(sp[1]);
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
            backups = bk;
            Console.Info("Load backups");
            bf.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void addUpdateListener(UpdateListener l) {
        listeners.add(l);
    }

    public static void removeUpdateListener(UpdateListener l) {
        listeners.remove(l);
    }

    public static ArrayList<Backup> getBackups() {
        return backups;
    }

    static {
        timeToDeleteBackup = 2;
        el = new ExitListener(){

            @Override
            public void onExit(ExitEvent event) {
                BackupManager.backup(3);
            }
        };
    }
}

