/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.DownloadDialog;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.IO.WorkingDirectory;
import net.modmaker.plugin.PluginManager;

public class RepairWorkspace {
    private static boolean isRepairing = false;

    public static boolean isRepairing() {
        return isRepairing;
    }

    public static void repairWorkspace() {
        isRepairing = true;
        ArrayList<PluginManager.UpdateData> ud = new ArrayList<PluginManager.UpdateData>();
        RepairWorkspace.repairPlugins(ud);
        RepairWorkspace.repairLibs(ud);
        if (!ud.isEmpty()) {
            Settings.getDialog().setVisible(false);
            Settings.getDialog().dispose();
            Settings.setDialog(null);
            DownloadDialog dd = new DownloadDialog("Updating Workspace", ud);
            try {
                dd.Download(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            dd.setVisible(true);
            if (dd.getError() != null) {
                if (dd.getError().getMessage().equals("Stopped by user")) {
                    Console.Warning("Repairing Stopped!");
                } else {
                    Console.Err(dd.getError());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    dd.getError().printStackTrace(pw);
                    OptionPane.showMessageDialog(null, "Downloading failed:\n\n" + sw.toString(), "Repair failed!", 2);
                }
            } else if (dd.getState() != 3) {
                Console.Warning("Wrong download state " + dd.getState());
            }
        }
        isRepairing = false;
    }

    public static void repairLibs() {
        isRepairing = true;
        ArrayList<PluginManager.UpdateData> ud = new ArrayList<PluginManager.UpdateData>();
        RepairWorkspace.repairLibs(ud);
        if (!ud.isEmpty()) {
            DownloadDialog dd = new DownloadDialog("Updating Librarys", ud);
            try {
                dd.Download(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            dd.setVisible(true);
            if (dd.getError() != null) {
                if (dd.getError().getMessage().equals("Stopped by user")) {
                    Console.Warning("Repairing Stopped!");
                } else {
                    Console.Err(dd.getError());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    dd.getError().printStackTrace(pw);
                    OptionPane.showMessageDialog(null, "Downloading failed:\n\n" + sw.toString(), "Repair failed!", 2);
                }
            } else if (dd.getState() != 3) {
                Console.Warning("Wrong download state " + dd.getState());
            }
        }
        isRepairing = false;
    }

    private static void repairLibs(ArrayList<PluginManager.UpdateData> ud) {
        try {
            File pu;
            File natDir;
            if (!new File(Settings.getRoot() + "/UpToDate.ini").exists()) {
                return;
            }
            File libDir = new File(Settings.getRoot() + "/lib");
            if (!libDir.exists() || libDir.isFile()) {
                libDir.delete();
                libDir.mkdirs();
            }
            if (!(natDir = new File(Settings.getRoot() + "/lib/native")).exists() || natDir.isFile()) {
                natDir.delete();
                natDir.mkdirs();
            }
            if (!(pu = new File(libDir.getPath() + "/ProgramUpdater.jar")).exists() || pu.isDirectory()) {
                pu.delete();
                FileManager.extractFromResources("/net/modmaker/res/ModMaker_Updater.jar", pu);
            }
            String data = Settings.get("modmaker.uptodate.lib.data");
            boolean skipLibs = false;
            if (data == null) {
                skipLibs = true;
            } else if (!data.contains(";")) {
                skipLibs = true;
            }
            String[] libNames = null;
            if (!skipLibs) {
                libNames = data.split(";");
            }
            data = Settings.get("modmaker.uptodate.lib.native.data");
            boolean skipNat = false;
            if (data == null) {
                skipNat = true;
            } else if (!data.contains(";")) {
                skipNat = true;
            }
            String[] natNames = null;
            if (!skipNat) {
                natNames = data.split(";");
            }
            if (!skipLibs) {
                FileFilter ff = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                };
                File[] libList = libDir.listFiles(ff);
                boolean[] exists = new boolean[libNames.length];
                int[] libSize = new int[libNames.length];
                for (int i = 0; i < libNames.length; ++i) {
                    libSize[i] = Integer.parseInt(Settings.get("modmaker.uptodate.lib." + libNames[i]));
                }
                for (File libFile : libList) {
                    for (int a = 0; a < libNames.length; ++a) {
                        if (!libFile.getName().equals(libNames[a] + ".jar")) continue;
                        if (libFile.length() == (long)libSize[a]) {
                            exists[a] = true;
                            continue;
                        }
                        libFile.delete();
                        exists[a] = false;
                    }
                }
                for (int i = 0; i < exists.length; ++i) {
                    if (exists[i]) continue;
                    try {
                        PluginManager.UpdateData u = new PluginManager.UpdateData(null, libNames[i], 0.0, new URL(Settings.get("modmaker.uptodate.url.lib." + libNames[i])), new File(libDir.getPath() + "/" + libNames[i] + ".jar"));
                        ud.add(u);
                        continue;
                    }
                    catch (MalformedURLException me) {
                        Console.Warning("Unknown URL librarys: " + Settings.get("modmaker.uptodate.url.lib.native." + natNames[i]));
                    }
                }
            }
            if (!skipNat) {
                File[] natList = natDir.listFiles();
                int[] natSize = new int[natNames.length];
                boolean[] natExists = new boolean[natNames.length];
                for (int i = 0; i < natNames.length; ++i) {
                    natSize[i] = Integer.parseInt(Settings.get("modmaker.uptodate.lib.native." + WorkingDirectory.getPlatform().toString().toLowerCase() + "." + natNames[i]));
                }
                for (File natFile : natList) {
                    for (int a = 0; a < natNames.length; ++a) {
                        if (!natFile.getName().equals(natNames[a])) continue;
                        if (natFile.length() == (long)natSize[a]) {
                            natExists[a] = true;
                            continue;
                        }
                        natFile.delete();
                        natExists[a] = false;
                    }
                }
                for (int i = 0; i < natExists.length; ++i) {
                    if (natExists[i]) continue;
                    String key = "modmaker.uptodate.url.lib.native." + WorkingDirectory.getPlatform().toString().toLowerCase() + "." + natNames[i];
                    try {
                        PluginManager.UpdateData u = new PluginManager.UpdateData(null, natNames[i], 0.0, new URL(Settings.get(key)), new File(natDir.getPath() + "/" + natNames[i]));
                        ud.add(u);
                        continue;
                    }
                    catch (MalformedURLException me) {
                        Console.Warning("Unknown URL native librarys: " + key);
                    }
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public static void repairPlugins() {
        isRepairing = true;
        ArrayList<PluginManager.UpdateData> ud = new ArrayList<PluginManager.UpdateData>();
        RepairWorkspace.repairPlugins(ud);
        if (!ud.isEmpty()) {
            DownloadDialog dd = new DownloadDialog("Updating Plugins", ud);
            try {
                dd.Download(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            dd.setVisible(true);
            if (dd.getError() != null) {
                if (dd.getError().getMessage().equals("Stopped by user")) {
                    Console.Warning("Repairing Stopped!");
                } else {
                    Console.Err(dd.getError());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    dd.getError().printStackTrace(pw);
                    OptionPane.showMessageDialog(null, "Downloading failed:\n\n" + sw.toString(), "Repair failed!", 2);
                }
            } else if (dd.getState() != 3) {
                Console.Warning("Wrong download state " + dd.getState());
            } else {
                new File(Settings.getRoot() + "/plugins/plugindata.ini").delete();
            }
        }
        isRepairing = false;
    }

    private static void repairPlugins(ArrayList<PluginManager.UpdateData> updatedats) {
        try {
            String data;
            if (!new File(Settings.getRoot() + "/UpToDate.ini").exists()) {
                return;
            }
            File pluginDir = new File(Settings.getRoot() + "/plugins");
            if (!pluginDir.exists() || pluginDir.isFile()) {
                pluginDir.delete();
                pluginDir.mkdirs();
            }
            if ((data = Settings.get("modmaker.uptodate.plugins.data")) == null || "".equals(data)) {
                throw new RuntimeException("No update data found!");
            }
            if (!data.contains(";")) {
                throw new RuntimeException("No plugins in update data found!");
            }
            String[] pluginNames = data.split(";");
            Double[] versions = new Double[pluginNames.length];
            for (int i = 0; i < pluginNames.length; ++i) {
                versions[i] = Double.parseDouble(Settings.get("modmaker.uptodate.plugins." + pluginNames[i]));
            }
            boolean[] exists = new boolean[pluginNames.length];
            for (File file : pluginDir.listFiles()) {
                String line;
                if (!file.getName().endsWith(".jar")) continue;
                ZipFile zp = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zp.entries();
                InputStream in = null;
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().equalsIgnoreCase("Plugin.dat")) continue;
                    in = zp.getInputStream(entry);
                    break;
                }
                if (in == null) {
                    file.delete();
                }
                BufferedReader bf = new BufferedReader(new InputStreamReader(in));
                String main = null;
                String name = null;
                String author = null;
                double version = 0.0;
                boolean brk = false;
                while ((line = bf.readLine()) != null) {
                    if (line.toLowerCase().startsWith("name:")) {
                        name = line.substring("Name:".length());
                        author = bf.readLine().substring("Author:".length());
                        version = Double.parseDouble(bf.readLine().substring("Version:".length()));
                        main = bf.readLine().substring("mainClass:".length());
                        for (int i = 0; i < pluginNames.length; ++i) {
                            if (!pluginNames[i].equalsIgnoreCase(name)) continue;
                            if (version >= versions[i]) {
                                exists[i] = true;
                                continue;
                            }
                            String url = Settings.get("modmaker.uptodate.url." + name);
                            if (url == null) {
                                Console.Warning("Could not find updatelink of " + name);
                                exists[i] = true;
                                continue;
                            }
                            bf.close();
                            in.close();
                            zp.close();
                            file.delete();
                            brk = true;
                            break;
                        }
                    }
                    if (!brk) continue;
                }
            }
            for (int i = 0; i < pluginNames.length; ++i) {
                if (exists[i]) continue;
                String url = Settings.get("modmaker.uptodate.url." + pluginNames[i]);
                File output = new File(Settings.getRoot() + "/plugins/" + pluginNames[i] + ".jar");
                output.delete();
                updatedats.add(new PluginManager.UpdateData(null, pluginNames[i], versions[i], new URL(url), output));
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }
}

