/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.customcode;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jsyntaxpane.DefaultSyntaxKit;
import net.modmaker.Console.Console;
import net.modmaker.Export.Export;
import net.modmaker.Gui.ConsolePanel;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.IO.WorkingDirectory;
import net.modmaker.Utils.McpScripts;
import net.modmaker.Utils.Textures;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.customcode.CreateClass;
import net.modmaker.customcode.ImageViewer;
import net.modmaker.customcode.TextEditor;
import net.modmaker.report.Mail;
import net.modmaker.report.ReportDialog;

public class CustomCodeDialog
extends JFrame {
    private CustomPaintPanel1 customPaintPanel11;
    private CustomPaintPanel2 customPaintPanel21;
    private CustomPaintPanel2 customPaintPanel22;
    private CustomPaintPanel2 customPaintPanel23;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JTree jTree1;
    private JTree jTree2;
    private ConsolePanel consolePanel;
    private File saveFile;
    private boolean isRunning = false;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem21;
    private JPopupMenu pop;
    private int mouseX = 0;
    private int mouseY = 0;
    private static CustomCodeDialog ccd;

    public CustomCodeDialog() {
        ccd = this;
        this.initComponents();
        this.customInit();
        BasicSplitPaneUI ui = (BasicSplitPaneUI)this.jSplitPane1.getUI();
        ui.getDivider().setBorder(null);
        ui = (BasicSplitPaneUI)this.jSplitPane2.getUI();
        ui.getDivider().setBorder(null);
        ui = (BasicSplitPaneUI)this.jSplitPane3.getUI();
        ui.getDivider().setBorder(null);
        this.jMenuBar1.setUI(new MenuBarUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                for (int i = CustomCodeDialog.this.jMenuBar1.getHeight() - 1; i >= 0; --i) {
                    int v = i * 4;
                    g.setColor(new Color(100 + v, 100 + v, 100 + v));
                    g.fillRect(0, CustomCodeDialog.this.jMenuBar1.getHeight() - i - 1, CustomCodeDialog.this.jMenuBar1.getWidth(), 1);
                }
            }
        });
        this.setExtendedState(6);
        this.updateTree();
        this.updateTree2();
        this.jTree1.setCellRenderer(new CustomIconRenderer(Settings.getRoot() + "/MCP/src/minecraft/"));
        this.jTree2.setCellRenderer(new CustomIconRenderer2(Settings.getRoot() + "/MCP/src/"));
        this.consolePanel = new ConsolePanel();
        this.jSplitPane2.setRightComponent(this.consolePanel);
        this.jSplitPane2.setDividerLocation(300);
        try {
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            list.add(ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/Block16.png")));
            list.add(ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/Block32.png")));
            this.setIconImages(list);
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSplitPane3 = new JSplitPane();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jLabel5 = new JLabel();
        this.jPanel7 = new JPanel();
        this.customPaintPanel23 = new CustomPaintPanel2();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTree2 = new JTree();
        this.customPaintPanel22 = new CustomPaintPanel2();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton6 = new JButton();
        this.jButton2 = new JButton();
        this.jButton7 = new JButton();
        this.jToolBar2 = new JToolBar();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jToolBar3 = new JToolBar();
        this.jButton3 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.setDefaultCloseOperation(2);
        this.setTitle("Custom Code Editor");
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jSplitPane1.setBackground(new Color(100, 100, 100));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane2.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51)));
        this.jSplitPane2.setDividerLocation(300);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.jPanel5.setBackground(new Color(100, 100, 100));
        this.jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jLabel4.setFont(new Font("Tahoma", 0, 36));
        this.jLabel4.setText("Welcome " + Settings.getAuthor() + " to the Custom Code Editor!");
        this.jSeparator1.setBackground(new Color(100, 100, 100));
        this.jSeparator1.setForeground(new Color(51, 51, 51));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 542, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addContainerGap(228, Short.MAX_VALUE)));
        this.jSplitPane2.setTopComponent(this.jPanel5);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.jSplitPane3.setBackground(new Color(100, 100, 100));
        this.jSplitPane3.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51)));
        this.jSplitPane3.setDividerLocation(300);
        this.jSplitPane3.setOrientation(0);
        this.jSplitPane3.setResizeWeight(0.5);
        this.jScrollPane1.setBackground(new Color(51, 51, 51));
        this.jScrollPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.jTree1.setBackground(new Color(100, 100, 100));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.jTree1.setModel(new DefaultTreeModel(treeNode1));
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CustomCodeDialog.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jLabel5.setForeground(new Color(204, 204, 204));
        this.jLabel5.setText("  Project");
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -1, 25, Short.MAX_VALUE));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 298, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.customPaintPanel21, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 274, Short.MAX_VALUE)));
        this.jSplitPane3.setLeftComponent(this.jPanel6);
        this.jLabel6.setForeground(new Color(204, 204, 204));
        this.jLabel6.setText(" Minecraft Source Code");
        GroupLayout customPaintPanel23Layout = new GroupLayout(this.customPaintPanel23);
        this.customPaintPanel23.setLayout(customPaintPanel23Layout);
        customPaintPanel23Layout.setHorizontalGroup(customPaintPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -1, 298, Short.MAX_VALUE));
        customPaintPanel23Layout.setVerticalGroup(customPaintPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -1, 25, Short.MAX_VALUE));
        this.jScrollPane2.setBackground(new Color(51, 51, 51));
        this.jScrollPane2.setBorder(BorderFactory.createBevelBorder(1));
        this.jTree2.setBackground(new Color(100, 100, 100));
        treeNode1 = new DefaultMutableTreeNode("root");
        this.jTree2.setModel(new DefaultTreeModel(treeNode1));
        this.jTree2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CustomCodeDialog.this.jTree2MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTree2);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPaintPanel23, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.customPaintPanel23, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane2, -1, 240, Short.MAX_VALUE)));
        this.jSplitPane3.setRightComponent(this.jPanel7);
        this.jSplitPane1.setLeftComponent(this.jSplitPane3);
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jPanel2.setOpaque(false);
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Minecraft " + Settings.getMinecraftVersion() + ", MCP " + Settings.getMCPVersion() + ", MC Forge " + Settings.getForgeVersion());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jPanel3.setOpaque(false);
        this.jLabel2.setForeground(new Color(204, 204, 204));
        this.jLabel2.setText("Author: Deathlykiller");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel2)));
        this.jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jPanel4.setOpaque(false);
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setHorizontalAlignment(11);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE))));
        GroupLayout customPaintPanel22Layout = new GroupLayout(this.customPaintPanel22);
        this.customPaintPanel22.setLayout(customPaintPanel22Layout);
        customPaintPanel22Layout.setHorizontalGroup(customPaintPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel22Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)));
        customPaintPanel22Layout.setVerticalGroup(customPaintPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel22Layout.createSequentialGroup().addGap(8, 8, 8).addGroup(customPaintPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE))));
        this.customPaintPanel11.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)), BorderFactory.createLineBorder(new Color(51, 51, 51))));
        this.jToolBar1.setBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setOpaque(false);
        this.jButton1.setIcon(new ImageIcon(Textures.NewMod));
        this.jButton1.setToolTipText("New Class");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setOpaque(false);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton6.setIcon(new ImageIcon(Textures.OpenMod));
        this.jButton6.setToolTipText("Open");
        this.jButton6.setFocusable(false);
        this.jButton6.setHorizontalTextPosition(0);
        this.jButton6.setOpaque(false);
        this.jButton6.setVerticalTextPosition(3);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton6ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton6);
        this.jButton2.setIcon(new ImageIcon(Textures.SaveMod));
        this.jButton2.setToolTipText("Save");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setOpaque(false);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton7.setIcon(new ImageIcon(Textures.Clear));
        this.jButton7.setToolTipText("Clear workspace");
        this.jButton7.setFocusable(false);
        this.jButton7.setHorizontalTextPosition(0);
        this.jButton7.setOpaque(false);
        this.jButton7.setVerticalTextPosition(3);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton7ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton7);
        this.jToolBar2.setBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)));
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setOpaque(false);
        this.jButton4.setIcon(new ImageIcon(Textures.Ok));
        this.jButton4.setToolTipText("Apply and return to full editor");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setOpaque(false);
        this.jButton4.setVerticalTextPosition(3);
        this.jToolBar2.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(Textures.Cancel));
        this.jButton5.setToolTipText("Discard and return to full editor");
        this.jButton5.setFocusable(false);
        this.jButton5.setHorizontalTextPosition(0);
        this.jButton5.setOpaque(false);
        this.jButton5.setVerticalTextPosition(3);
        this.jToolBar2.add(this.jButton5);
        this.jToolBar3.setBorder(BorderFactory.createLineBorder(new Color(70, 70, 70)));
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setOpaque(false);
        this.jButton3.setIcon(new ImageIcon(Textures.RunMod));
        this.jButton3.setToolTipText("Test Mod");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setOpaque(false);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButton3);
        this.jButton8.setIcon(new ImageIcon(Textures.Export));
        this.jButton8.setToolTipText("Export Mod");
        this.jButton8.setFocusable(false);
        this.jButton8.setHorizontalTextPosition(0);
        this.jButton8.setOpaque(false);
        this.jButton8.setVerticalTextPosition(3);
        this.jButton8.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CustomCodeDialog.this.jButton8MousePressed(evt);
            }
        });
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton8ActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButton8);
        this.jButton9.setIcon(new ImageIcon(Textures.Report));
        this.jButton9.setToolTipText("Report Error");
        this.jButton9.setFocusable(false);
        this.jButton9.setHorizontalTextPosition(0);
        this.jButton9.setOpaque(false);
        this.jButton9.setVerticalTextPosition(3);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCodeDialog.this.jButton9ActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButton9);
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel11Layout.createSequentialGroup().addComponent(this.jToolBar2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar3, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 1089, Short.MAX_VALUE).addComponent(this.customPaintPanel22, -1, -1, Short.MAX_VALUE).addComponent(this.customPaintPanel11, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.customPaintPanel11, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, 571, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel22, -2, -1, -2)));
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        File sel;
        if (evt.getClickCount() >= 2 && evt.getButton() == 1 && (sel = this.getSelectedFile()).isFile()) {
            this.open(sel);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            this.savePanel();
            final Process p = McpScripts.StartClient();
            Console.Info("----- Start Test Minecraft Mod -----");
            Thread inputStreamReader = new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            Console.Script(line);
                        }
                        reader.close();
                        Console.Info("----- Finish Test Minecraft Mod -----");
                        CustomCodeDialog.this.isRunning = false;
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                    }
                }
            };
            Thread errStreamReader = new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        while ((line = reader.readLine()) != null) {
                            Console.Script(line);
                        }
                        reader.close();
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                    }
                }
            };
            inputStreamReader.setName("InputStreamReader");
            errStreamReader.setName("errStreamReader");
            inputStreamReader.start();
            errStreamReader.start();
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(this, "Something went wrong!", "Error", 64);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.load();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        int ret;
        File[] root = new File(Settings.getRoot() + "/MCP/src/minecraft/mods").listFiles();
        if (root != null && root.length > 0 && (ret = OptionPane.showConfirmDialog(this, "Are you sure you want to remove all classes and images?", "Clear Workspace", 0, 2)) == 0) {
            FileManager.Delete(new File(Settings.getRoot() + "/MCP/src/minecraft/mods"));
            this.updateTree();
            this.setPanel(this.jPanel5);
        }
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.reportError(evt);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        CreateClass cc = new CreateClass("mods");
        cc.setVisible(true);
        if (cc.getNewFile() != null && cc.getReturnState() == 0) {
            this.open(cc.getNewFile());
        }
        this.updateTree();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        try {
            this.pop.show(this.jButton8, this.mouseX, this.mouseY);
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton8MousePressed(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
    }

    private void jTree2MouseClicked(MouseEvent evt) {
        File sel;
        if (evt.getClickCount() >= 2 && evt.getButton() == 1 && (sel = this.getSelectedFile2()).isFile()) {
            this.open(sel, false);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CustomCodeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CustomCodeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CustomCodeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CustomCodeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSyntaxKit.initKit();
                try {
                    Textures.Load();
                    UIManager.put("SplitPane.background", new ColorUIResource(111, 111, 111));
                    UIManager.put("Tree.selectionBackground", new ColorUIResource(100, 100, 100));
                    UIManager.put("Tree.textBackground", new ColorUIResource(100, 100, 100));
                    UIManager.put("List.selectionBackground", new Color(0, 0, 0, 0));
                    UIManager.put("List.selectionForeground", Color.white);
                    UIManager.put("TextPane.selectionBackground", new Color(0, 0, 0, 0));
                    UIManager.put("TextPane.selectionForeground", Color.white);
                    UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
                    UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
                    new CompoundBorder(new LineBorder(new Color(30, 30, 30)), new LineBorder(new Color(51, 51, 51)));
                    UIManager.put("PopupMenu.border", new LineBorder(new Color(51, 51, 51), 2));
                    UIManager.put("Menu.background", new ColorUIResource(51, 51, 51));
                    UIManager.put("Menu.foreground", new ColorUIResource(204, 204, 204));
                    UIManager.put("Menu.opaque", false);
                    UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
                    UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
                    UIManager.put("PopupMenu.opaque", true);
                    UIManager.put("MenuItem.background", new ColorUIResource(51, 51, 51));
                    UIManager.put("MenuItem.foreground", new ColorUIResource(204, 204, 204));
                    UIManager.put("MenuItem.opaque", false);
                    UIManager.put("TabbedPane.contentOpaque", false);
                    UIManager.put("TabbedPane.darkShadow", new Color(70, 70, 70));
                    UIManager.put("TabbedPane.shadow", new Color(51, 51, 51));
                    UIManager.put("TabbedPane.light", new Color(70, 70, 70));
                    UIManager.put("TabbedPane.highlight", new Color(51, 51, 51));
                    UIManager.put("TabbedPane.tabsOpaque", Boolean.FALSE);
                    UIManager.put("TabbedPane.selectedTabPadInsets", new Insets(0, 0, 0, 0));
                }
                catch (Exception ex) {
                    Logger.getLogger(CustomCodeDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
                CustomCodeDialog dialog = new CustomCodeDialog();
                Settings.setFrame(dialog);
                Settings.setAuthor("Deathlykiller");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static CustomCodeDialog getCustomCode() {
        return ccd;
    }

    public void setIndeterminate(boolean i) {
        this.jProgressBar1.setIndeterminate(i);
    }

    public void setProgress(String text, int progress) {
        this.jProgressBar1.setValue(progress);
        this.jLabel3.setText(text);
    }

    private boolean save() {
        if (this.saveFile == null) {
            new File(Settings.getRoot() + "/CCSave").mkdirs();
            this.saveFile = FileChooser.showDialog(Settings.getRoot() + "/CCSave", FileChooser.SAVE_DIALOG, 0, 0, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.getName().endsWith(".ccdme")) {
                        return true;
                    }
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "CustomCode savefile (*.ccdme)";
                }
            });
            if (this.saveFile == null) {
                return false;
            }
            if (!this.saveFile.getName().endsWith(".ccdme")) {
                this.saveFile = new File(this.saveFile.getPath() + ".ccdme");
            }
        }
        try {
            Console.Info("Save");
            this.savePanel();
            File temp = FileManager.getTempFile();
            temp.delete();
            FileManager.Zip(new File(Settings.getRoot() + "/MCP/src/minecraft/mods"), temp);
            new File(temp.getPath() + "/mods.zip").renameTo(this.saveFile);
            temp.delete();
            return true;
        }
        catch (Throwable e) {
            Console.Err(e);
            return false;
        }
    }

    private boolean load() {
        return this.load(null);
    }

    private boolean load(File file) {
        int ret;
        File[] root = new File(Settings.getRoot() + "/MCP/src/minecraft/mods").listFiles();
        if (root != null && root.length > 0 && ((ret = OptionPane.showConfirmDialog(this, "Do you want to save?", "Save", 1, 3)) == 0 ? !this.save() : ret != 1)) {
            return false;
        }
        if (file == null && (file = FileChooser.showDialog(Settings.getRoot() + "/CCSave", FileChooser.OPEN_DIALOG, 0, 0, new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().endsWith(".ccdme")) {
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "CustomCode savefile (*.ccdme)";
            }
        })) == null) {
            return false;
        }
        if (!file.exists()) {
            OptionPane.showMessageDialog(this, "Could not find savefile\n" + file.getPath(), "Could not find savefile", 2);
            return false;
        }
        this.saveFile = file;
        try {
            Console.Info("Load");
            FileManager.Delete(new File(Settings.getRoot() + "/MCP/src/minecraft/mods"));
            FileManager.UnZip(file, new File(Settings.getRoot() + "/MCP/src/minecraft/mods"));
            this.updateTree();
            return true;
        }
        catch (Throwable e) {
            Console.Err(e);
            return false;
        }
    }

    private void open(File file) {
        String path = file.getPath().substring(new File(Settings.getRoot() + "/MCP/src/minecraft/").getPath().length() + 1);
        path = path.substring(0, path.length() - file.getName().length() - 1);
        try {
            BufferedImage image = ImageIO.read(file);
            ImageViewer iv = new ImageViewer(image, file.getName(), path.replace("\\", "."), true);
            this.setPanel(iv);
        }
        catch (Throwable e) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String out = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    out = out + "\n" + line;
                }
                reader.close();
                TextEditor te = new TextEditor(file.getName(), path.replace("\\", "."), true);
                te.setText(out);
                this.setPanel(te);
            }
            catch (Throwable ee) {
                OptionPane.showMessageDialog(this, "Something went wrong with reading this file!", ee.getMessage(), 2);
                Console.Err(ee);
            }
        }
    }

    private void open(File file, boolean editable) {
        String path = file.getPath().substring(new File(Settings.getRoot() + "/MCP/src/").getPath().length() + 1);
        path = path.substring(0, path.length() - file.getName().length() - 1);
        try {
            BufferedImage image = ImageIO.read(file);
            ImageViewer iv = new ImageViewer(image, file.getName(), path.replace("\\", "."), false);
            this.setPanel(iv);
        }
        catch (Throwable e) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String out = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    out = out + "\n" + line;
                }
                reader.close();
                TextEditor te = new TextEditor(file.getName(), path.replace("\\", "."), editable);
                te.setText(out);
                this.setPanel(te);
            }
            catch (Throwable ee) {
                OptionPane.showMessageDialog(this, "Something went wrong with reading this file!", ee.getMessage(), 2);
                Console.Err(ee);
            }
        }
    }

    public void setPanel(JPanel panel) {
        this.savePanel();
        int l = this.jSplitPane2.getDividerLocation();
        panel.setBorder(new CompoundBorder(new LineBorder(new Color(51, 51, 51)), new LineBorder(new Color(70, 70, 70))));
        this.jSplitPane2.setLeftComponent(panel);
        this.jSplitPane2.setDividerLocation(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void savePanel() {
        Component old = this.jSplitPane2.getLeftComponent();
        if (old instanceof TextEditor) {
            BufferedWriter writer = null;
            try {
                TextEditor te = (TextEditor)old;
                if (!te.isEditable()) return;
                String text = te.getText();
                File out = te.getFile();
                writer = new BufferedWriter(new FileWriter(out));
                writer.write(text);
                return;
            }
            catch (IOException ex) {
                Console.Err(ex);
                return;
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    Console.Err(ex);
                }
            }
        }
        if (!(old instanceof ImageViewer)) return;
        try {
            ImageViewer iv = (ImageViewer)old;
            if (!iv.isEditable()) return;
            ImageIO.write((RenderedImage)iv.getImage(), "PNG", iv.getFile());
            return;
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void updateTree() {
        File root = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/");
        this.jTree1.setModel(new DefaultTreeModel(this.getNode(root)));
    }

    private DefaultMutableTreeNode getNode(File path) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(path.getName());
        File[] list = path.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!file.isDirectory()) continue;
                parent.add(this.getNode(file));
            }
            for (File file : list) {
                if (!file.isFile()) continue;
                parent.add(this.getNode(file));
            }
        }
        return parent;
    }

    private void updateTree2() {
        File root = new File(Settings.getRoot() + "/MCP/src/minecraft/");
        DefaultMutableTreeNode rn = new DefaultMutableTreeNode("minecraft");
        File[] list = root.listFiles();
        if (list != null) {
            for (File file : list) {
                if (file.getName().equals("mods") || !file.isDirectory()) continue;
                this.getNode2(file, rn);
            }
            for (File file : list) {
                if (file.getName().equals("mods") || !file.isFile()) continue;
                this.getNode2(file, rn);
            }
        }
        this.jTree2.setModel(new DefaultTreeModel(rn));
    }

    private void getNode2(File path, DefaultMutableTreeNode root) {
        String name = path.getPath().substring(new File(Settings.getRoot() + "/MCP/src/minecraft/").getPath().length() + 1).replace("\\", ".");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(name);
        File[] list = path.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!file.isDirectory()) continue;
                this.getNode2(file, root);
            }
            boolean hasChilds = false;
            for (File file : list) {
                if (!file.isFile()) continue;
                hasChilds = true;
                parent.add(new DefaultMutableTreeNode(file.getName()));
            }
            if (hasChilds) {
                root.add(parent);
            }
        }
        if (path.isFile()) {
            root.add(parent);
        }
    }

    private File getSelectedFile() {
        File out = null;
        TreeNode[] path = new DefaultMutableTreeNode(this.jTree1.getSelectionPath()).getPath();
        String str = "";
        for (TreeNode tn : path) {
            str = str + "/" + tn.toString();
        }
        str = str.substring(2, str.length() - 1).replace(", ", "/");
        out = new File(Settings.getRoot() + "/MCP/src/minecraft/" + str);
        return out;
    }

    private File getSelectedFile2() {
        File out = null;
        TreeNode[] path = new DefaultMutableTreeNode(this.jTree2.getSelectionPath()).getPath();
        String str = "";
        for (int i = 0; i < path.length; ++i) {
            if (i != path.length - 1) continue;
            str = str + "/" + path[i].toString().replace(".", "/");
        }
        StringBuilder b = new StringBuilder(str);
        b.replace(str.lastIndexOf("/"), str.lastIndexOf("/") + 1, ".");
        str = b.toString();
        str = str.substring(2, str.length() - 1).replace(", ", "/");
        out = new File(Settings.getRoot() + "/MCP/src/" + str);
        return out;
    }

    public void reportError(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReportDialog rd = new ReportDialog(null);
                    rd.setVisible(true);
                    if (rd.getReturnStatus() == 1) {
                        String desc = "Custom Report [no mods]\n\nDescription:\n" + rd.getDiscription();
                        String mail = rd.getEmailAddress();
                        Mail.mail(mail, "[REPORT] " + mail, desc);
                    }
                }
                catch (Throwable e) {
                    Console.Err(e);
                }
            }
        }).start();
    }

    private void customInit() {
        this.jMenuItem20 = new JMenuItem("Final Mod"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + i, 51 + i, 51 + i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.jMenuItem21 = new JMenuItem("Executable Installation"){

            @Override
            public void paintComponent(Graphics g) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    g.setColor(new Color(51 + this.getHeight() - i, 51 + this.getHeight() - i, 51 + this.getHeight() - i));
                    g.drawRect(0, i, this.getWidth(), 1);
                }
                super.paintComponent(g);
            }
        };
        this.pop = new JPopupMenu();
        this.pop.add(this.jMenuItem20);
        this.pop.add(this.jMenuItem21);
        for (Component comp : this.pop.getComponents()) {
            comp.setForeground(new Color(204, 204, 204));
        }
        this.jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Thread export = new Thread(){

                        @Override
                        public void run() {
                            try {
                                CustomCodeDialog.this.savePanel();
                                File out = Export.ExportCustomToClasses();
                                if (out != null) {
                                    WorkingDirectory.getPlatform().openDirInExplorer(out.getParentFile());
                                }
                            }
                            catch (Throwable e) {
                                Console.Err(e);
                            }
                            ThreadManager.removeThread("Export to classes");
                        }
                    };
                    ThreadManager.addThread(export, "Export to classes");
                    export.start();
                }
                catch (Throwable ee) {
                    Console.Err(ee);
                }
            }
        });
        this.jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Thread export = new Thread(){

                        @Override
                        public void run() {
                            try {
                                CustomCodeDialog.this.savePanel();
                                File out = Export.ExportCustomToInstaller();
                                if (out != null) {
                                    WorkingDirectory.getPlatform().openDirInExplorer(out.getParentFile());
                                }
                            }
                            catch (Throwable e) {
                                Console.Err(e);
                            }
                            ThreadManager.removeThread("Export to classes");
                        }
                    };
                    ThreadManager.addThread(export, "Export to classes");
                    export.start();
                }
                catch (Throwable ee) {
                    Console.Err(ee);
                }
            }
        });
    }

    private class CustomIconRenderer2
    extends DefaultTreeCellRenderer {
        private ImageIcon file;
        private String root;

        public CustomIconRenderer2(String root) {
            this.root = root;
            try {
                this.file = new ImageIcon(Textures.Transparent(Color.black, ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/File.png"))));
            }
            catch (IOException e) {
                Console.Err(e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setOpaque(false);
            TreeNode[] path = node.getPath();
            String str = "";
            for (int i = 0; i < path.length; ++i) {
                str = i == path.length - 1 ? str + "/" + path[i].toString() : str + "/" + path[i].toString().replace(".", "\\");
            }
            File file = new File(this.root + str);
            if (file.isFile()) {
                this.setIcon(this.file);
            } else {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            }
            return this;
        }
    }

    private class CustomIconRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon file;
        private String root;

        public CustomIconRenderer(String root) {
            this.root = root;
            try {
                this.file = new ImageIcon(Textures.Transparent(Color.black, ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/File.png"))));
            }
            catch (IOException e) {
                Console.Err(e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setOpaque(false);
            TreeNode[] path = node.getPath();
            String str = "";
            for (TreeNode tn : path) {
                str = str + "/" + tn.toString();
            }
            File file = new File(this.root + str);
            if (file.isFile()) {
                this.setIcon(this.file);
            } else {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            }
            return this;
        }
    }
}

