/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.customcode;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.CustomButton;
import net.modmaker.Gui.CustomPaintPanel1;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;

public class ImageViewer
extends JPanel {
    private CustomButton customButton1;
    private CustomButton customButton2;
    private CustomPaintPanel1 customPaintPanel11;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private int zoom = 5;
    private BufferedImage image;
    private String className;
    private String pack;
    private boolean editable;

    public ImageViewer(BufferedImage image, String className, String pack, boolean editable) {
        this.initComponents();
        this.editable = editable;
        this.jScrollPane1.getViewport().setBackground(new Color(100, 100, 100));
        this.image = image;
        this.updateImage();
        this.jLabel2.setText("File: " + className + "    Package: " + pack);
        this.className = className;
        this.pack = pack;
    }

    private void initComponents() {
        this.customPaintPanel11 = new CustomPaintPanel1();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.customButton1 = new CustomButton();
        this.customButton2 = new CustomButton();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.customPaintPanel11.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51)));
        this.jSlider1.setMaximum(11);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.setValue(6);
        this.jSlider1.setOpaque(false);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImageViewer.this.jSlider1StateChanged(evt);
            }
        });
        this.customButton1.setText("-");
        this.customButton1.setFont(new Font("Tahoma", 0, 13));
        this.customButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImageViewer.this.customButton1MouseClicked(evt);
            }
        });
        this.customButton2.setText("+");
        this.customButton2.setFont(new Font("Tahoma", 0, 13));
        this.customButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImageViewer.this.customButton2MouseClicked(evt);
            }
        });
        GroupLayout customPaintPanel11Layout = new GroupLayout(this.customPaintPanel11);
        this.customPaintPanel11.setLayout(customPaintPanel11Layout);
        customPaintPanel11Layout.setHorizontalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE).addComponent(this.customButton1, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customButton2, -2, 41, -2).addGap(2, 2, 2)));
        customPaintPanel11Layout.setVerticalGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 29, -2)).addGroup(GroupLayout.Alignment.TRAILING, customPaintPanel11Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(customPaintPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customButton1, -2, 25, -2).addComponent(this.customButton2, -2, 25, -2).addComponent(this.jSlider1, -2, 25, -2)).addGap(2, 2, 2)));
        this.jScrollPane1.setBorder(null);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ImageViewer.this.jLabel1MouseWheelMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLabel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.customPaintPanel11, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 353, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.customPaintPanel11, -2, -1, -2)));
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        try {
            this.zoom = this.jSlider1.getValue();
            this.updateImage();
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void customButton1MouseClicked(MouseEvent evt) {
        --this.zoom;
        if (this.zoom < 1) {
            this.zoom = 1;
        }
        this.jSlider1.setValue(this.zoom);
    }

    private void customButton2MouseClicked(MouseEvent evt) {
        ++this.zoom;
        if (this.zoom > 11) {
            this.zoom = 11;
        }
        this.jSlider1.setValue(this.zoom);
    }

    private void jLabel1MouseWheelMoved(MouseWheelEvent evt) {
        this.zoom -= evt.getWheelRotation();
        if (this.zoom > 11) {
            this.zoom = 11;
        }
        if (this.zoom < 1) {
            this.zoom = 1;
        }
        this.jSlider1.setValue(this.zoom);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public File getFile() {
        return new File(Settings.getRoot() + "/MCP/src/minecraft/" + this.pack.replace(".", "\\") + "/" + this.className);
    }

    private void updateImage() {
        double z = this.zoom - 5;
        z = z >= 0.0 ? z * 0.5 + 1.0 : z * 0.1 + 1.0;
        BufferedImage i = Textures.Resize(this.image.getWidth() * this.zoom, this.image.getHeight() * this.zoom, this.image, RenderingHints.VALUE_ANTIALIAS_OFF);
        BufferedImage fi = new BufferedImage(i.getWidth(), i.getHeight(), 2);
        Graphics2D g = fi.createGraphics();
        boolean c = false;
        boolean d = false;
        for (int x = 0; x < i.getWidth(); x += 10) {
            c = d = !d;
            for (int y = 0; y < i.getHeight(); y += 10) {
                boolean bl = c = !c;
                if (c) {
                    g.setColor(Color.gray);
                } else {
                    g.setColor(Color.DARK_GRAY);
                }
                g.fillRect(x, y, 10, 10);
            }
        }
        g.drawImage((Image)i, 0, 0, this.jLabel1);
        g.dispose();
        this.jLabel1.setIcon(new ImageIcon(fi));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public static void main(String[] args) {
        for (int x = 0; x < 1000; x += 10) {
            Console.Out(x);
        }
    }
}

