/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JProgressBar;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.Gui.Tree;
import net.modmaker.IO.DownloadManager;
import net.modmaker.IO.SaveManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModManager;
import net.modmaker.events.Listeners.PluginChangeListener;
import net.modmaker.events.PluginChangeEvent;
import net.modmaker.events.Priority;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.PluginPolicy;

public class PluginManager {
    private static ArrayList<PluginData> plugins = new ArrayList();
    private static ArrayList<UpdateData> updates = new ArrayList();
    private static ArrayList<UpdateData> available = new ArrayList();
    private static ArrayList<File> add = new ArrayList();
    private static ArrayList<File> ignore = new ArrayList();
    private static ArrayList<PluginChangeListener> listeners = new ArrayList();

    public static void EnablePlugins() {
        Policy.setPolicy(new PluginPolicy());
        System.setSecurityManager(new SecurityManager());
        ArrayList<File> saveFiles = new ArrayList<File>();
        try {
            SaveManager.saveAllMods();
            for (ModManager mods : ModManager.mods) {
                saveFiles.add(mods.getMod().saveFile);
            }
            ModManager.mods.clear();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        PluginManager.loadAdd();
        PluginManager.loadIgnore();
        File f = new File(Settings.getRoot() + "/plugins");
        if (f.isFile()) {
            f.delete();
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        ArrayList<File> loadPlugins = new ArrayList<File>();
        for (File file : files) {
            loadPlugins.add(file);
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        for (int a = 0; a < add.size(); ++a) {
            File file = add.get(a);
            if (file.getParent().equals(new File(Settings.getRoot() + "/plugins").getPath())) {
                remove.add(a);
                continue;
            }
            loadPlugins.add(file);
        }
        for (Integer i : remove) {
            add.remove(i);
        }
        remove.clear();
        for (int i = 0; i < ignore.size(); ++i) {
            File file = ignore.get(i);
            if (!file.getParent().equals(new File(Settings.getRoot() + "/plugins").getPath()) || !file.delete()) continue;
            remove.add(i);
        }
        for (Integer i : remove) {
            ignore.remove(i);
        }
        for (File file : loadPlugins) {
            Console.Info("Enable: " + file.getPath());
            ClassLoader loader = null;
            try {
                String line;
                ZipFile zp = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zp.entries();
                InputStream in = null;
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().equalsIgnoreCase("Plugin.dat")) continue;
                    in = zp.getInputStream(entry);
                    break;
                }
                if (in == null) {
                    throw new Exception("Plugin.dat not found");
                }
                BufferedReader bf = new BufferedReader(new InputStreamReader(in));
                String main = null;
                String name = null;
                String author = null;
                double version = 0.0;
                while ((line = bf.readLine()) != null) {
                    if (!line.toLowerCase().startsWith("name:")) continue;
                    name = line.substring("Name:".length());
                    author = bf.readLine().substring("Author:".length());
                    version = Double.parseDouble(bf.readLine().substring("Version:".length()));
                    main = bf.readLine().substring("mainClass:".length());
                    for (int i = 0; i < plugins.size(); ++i) {
                        PluginData p = plugins.get(i);
                        if (!p.getPlugin().getName().equals(name)) continue;
                        if (version > p.getPlugin().getVersion()) {
                            PluginManager.DisablePlugin(p.getPlugin().getName());
                            ignore.add(p.file);
                            continue;
                        }
                        Console.Warning("Plugin: " + name + " already enabled!");
                        ignore.add(file);
                        throw new RuntimeException("Plugin Already Enabled: " + name);
                    }
                    loader = URLClassLoader.newInstance(new URL[]{file.toURL()});
                    Plugin base = (Plugin)loader.loadClass(main).newInstance();
                    base.setData(new Object[]{name, author, version, file});
                    try {
                        base.Enable();
                        plugins.add(new PluginData(base, loader, file));
                    }
                    catch (Throwable ee) {
                        Console.Warning("Error while enabling plugin: " + base.getName());
                        Console.Err(ee);
                    }
                }
            }
            catch (Throwable e) {
                for (int a = 0; a < add.size(); ++a) {
                    if (!add.get(a).getPath().equals(f.getPath())) continue;
                    add.remove(a);
                }
                e.printStackTrace();
                Console.Warning("Failed to load plugin:" + file.getName());
                if (loader == null) continue;
                loader.clearAssertionStatus();
            }
        }
        PluginManager.saveAdd();
        PluginManager.saveIgnore();
        for (File file : saveFiles) {
            try {
                Mod mod = SaveManager.loadMod(file);
                new ModManager(mod);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (Tree.getTree() != null) {
            Tree.getTree().UpdateTree();
        }
        PluginManager.triggerPluginChangeEvent();
    }

    public static void EnablePlugin(File file) {
        ArrayList<File> saveFiles;
        block16: {
            Policy.setPolicy(new PluginPolicy());
            System.setSecurityManager(new SecurityManager());
            saveFiles = new ArrayList<File>();
            try {
                SaveManager.saveAllMods();
                for (ModManager mods : ModManager.mods) {
                    saveFiles.add(mods.getMod().saveFile);
                }
                ModManager.mods.clear();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            PluginManager.loadAdd();
            PluginManager.loadIgnore();
            ClassLoader loader = null;
            try {
                String line;
                ZipFile zp = new ZipFile(file);
                Enumeration<? extends ZipEntry> e = zp.entries();
                InputStream in = null;
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().equalsIgnoreCase("Plugin.dat")) continue;
                    in = zp.getInputStream(entry);
                    break;
                }
                if (in == null) {
                    throw new Exception("Plugin.dat not found");
                }
                BufferedReader bf = new BufferedReader(new InputStreamReader(in));
                String main = null;
                String name = null;
                String author = null;
                double version = 0.0;
                while ((line = bf.readLine()) != null) {
                    if (!line.toLowerCase().startsWith("name:")) continue;
                    name = line.substring("Name:".length());
                    author = bf.readLine().substring("Author:".length());
                    version = Double.parseDouble(bf.readLine().substring("Version:".length()));
                    main = bf.readLine().substring("mainClass:".length());
                    for (int a = 0; a < plugins.size(); ++a) {
                        PluginData p = plugins.get(a);
                        if (!p.getPlugin().getName().equals(name)) continue;
                        if (version > p.getPlugin().getVersion()) {
                            PluginManager.DisablePlugin(p.getPlugin().getName());
                            ignore.add(p.file);
                            --a;
                            continue;
                        }
                        Console.Warning("Plugin: " + name + " already enabled!");
                        ignore.add(file);
                        throw new RuntimeException("Plugin Already Enabled: " + name);
                    }
                    loader = URLClassLoader.newInstance(new URL[]{file.toURL()});
                    Plugin base = (Plugin)loader.loadClass(main).newInstance();
                    base.setData(new Object[]{name, author, version, file});
                    try {
                        base.Enable();
                        plugins.add(new PluginData(base, loader, file));
                        add.add(file);
                    }
                    catch (Throwable ee) {
                        Console.Warning("Error while enabling plugin: " + base.getName());
                        Console.Err(ee);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                Console.Warning("Failed to load plugin:" + file.getName());
                if (loader == null) break block16;
                loader.clearAssertionStatus();
            }
        }
        PluginManager.saveAdd();
        PluginManager.saveIgnore();
        for (File f : saveFiles) {
            try {
                Mod mod = SaveManager.loadMod(f);
                new ModManager(mod);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (Tree.getTree() != null) {
            Tree.getTree().UpdateTree();
        }
        PluginManager.triggerPluginChangeEvent();
    }

    public static void DisablePlugins() {
        PluginManager.loadAdd();
        for (PluginData plugin : plugins) {
            try {
                ModManager.Save();
                plugin.plugin.Disable();
                plugin.loader.clearAssertionStatus();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                OptionPane.showMessageDialog(Settings.getFrame(), "Error while disabling plugin:" + plugin.plugin.getName() + "\n\n" + sw.toString(), "Plugin Error", 0);
            }
        }
        plugins.clear();
        PluginManager.saveAdd();
        if (Tree.getTree() != null) {
            Tree.getTree().UpdateTree();
        }
        PluginManager.triggerPluginChangeEvent();
    }

    public static void DisablePlugin(String name) {
        int a;
        ArrayList<File> saveFiles = new ArrayList<File>();
        try {
            SaveManager.saveAllMods();
            for (ModManager mods : ModManager.mods) {
                saveFiles.add(mods.getMod().saveFile);
            }
            ModManager.mods.clear();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        PluginManager.loadAdd();
        PluginData pd = null;
        int b = 0;
        for (a = 0; a < plugins.size(); ++a) {
            PluginData p = plugins.get(a);
            if (!p.plugin.getName().equals(name)) continue;
            pd = p;
            b = a;
        }
        if (pd == null) {
            Console.Warning("Can't find plugin: " + name);
            return;
        }
        for (a = 0; a < add.size(); ++a) {
            File file = add.get(a);
            if (!file.equals(pd.getFile())) continue;
            add.remove(a);
        }
        try {
            ModManager.Save();
            pd.plugin.Disable();
            pd.loader.clearAssertionStatus();
            plugins.remove(pd);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            OptionPane.showMessageDialog(Settings.getFrame(), "Error while disabling plugin:" + name + "\n\n" + sw.toString(), "Plugin Error", 0);
        }
        PluginManager.saveAdd();
        for (File f : saveFiles) {
            try {
                Mod mod = SaveManager.loadMod(f);
                new ModManager(mod);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (Tree.getTree() != null) {
            Tree.getTree().UpdateTree();
        }
        PluginManager.triggerPluginChangeEvent();
    }

    public static ArrayList<Plugin> getPlugins() {
        ArrayList<Plugin> ps = new ArrayList<Plugin>();
        for (PluginData pd : plugins) {
            ps.add(pd.plugin);
        }
        return ps;
    }

    public static Plugin getPlugin(String name) {
        for (PluginData plugin : plugins) {
            if (!plugin.plugin.getName().equalsIgnoreCase(name)) continue;
            return plugin.plugin;
        }
        return null;
    }

    public static boolean checkForUpdates() {
        return false;
    }

    public static ArrayList<UpdateData> getUpdates() {
        return updates;
    }

    public static void setUpdates(ArrayList<UpdateData> u) {
    }

    public static ArrayList<UpdateData> getAvailable() {
        return available;
    }

    public static void setAvailable(ArrayList<UpdateData> a) {
    }

    public static void UpdatePlugin(UpdateData data) throws Exception {
        for (ModManager manager : ModManager.mods) {
            SaveManager.saveMod(manager);
        }
        ModManager.mods.clear();
        Console.Info("update plugin: " + data.getName());
        if (data.getPlugin() != null) {
            Console.Info("Disable plugin: " + data.getName());
            PluginManager.DisablePlugin(data.getPlugin().getName());
        }
        Console.Info("Download plugin: " + data.getName());
        DownloadManager.DownloadtoFile(new File(Settings.getRoot() + "/temp/plugins/" + data.getName() + ".temp"), data);
        new File(Settings.getRoot() + "/temp/plugins/" + data.getName() + ".temp").renameTo(new File(Settings.getRoot() + "/plugins/" + data.getPlugin().getName() + " " + data.getNewVersion() + ".jar"));
        Console.Info("Enable plugin: " + data.getName());
        PluginManager.EnablePlugin(new File(Settings.getRoot() + "/plugins/" + data.getPlugin().getName() + " " + data.getNewVersion() + ".jar"));
        SaveManager.loadAllMods();
    }

    public static void DownloadPlugin(UpdateData data) throws Exception {
        Console.Info("Download plugin: " + data.getName());
        DownloadManager.DownloadtoFile(new File(Settings.getRoot() + "/plugins/" + data.getName() + ".jar"), data);
        Console.Info("Enable plugin: " + data.getName());
        PluginManager.EnablePlugin(new File(Settings.getRoot() + "/plugins/" + data.getName() + ".jar"));
    }

    public static void addPluginChangeListener(PluginChangeListener pcl) {
        listeners.add(pcl);
    }

    public static void removePluginChangeListener(PluginChangeListener pcl) {
        listeners.remove(pcl);
    }

    private static void triggerPluginChangeEvent() {
        PluginChangeEvent pce = new PluginChangeEvent(new PluginManager());
        for (PluginChangeListener pcl : listeners) {
            if (!pcl.getPriority().equals((Object)Priority.HIGH)) continue;
            pcl.onPluginChange(pce);
        }
        for (PluginChangeListener pcl : listeners) {
            if (!pcl.getPriority().equals((Object)Priority.NORMAL)) continue;
            pcl.onPluginChange(pce);
        }
        for (PluginChangeListener pcl : listeners) {
            if (!pcl.getPriority().equals((Object)Priority.LOW)) continue;
            pcl.onPluginChange(pce);
        }
    }

    public static void loadAdd() {
        String str = Settings.get("modmaker.plugins.add");
        add.clear();
        if (str != null) {
            if (str.contains("<//>")) {
                String[] split;
                for (String fileName : split = str.split("<//>")) {
                    add.add(new File(fileName));
                }
            } else {
                add.add(new File(str));
            }
        }
    }

    public static void saveAdd() {
        if (!add.isEmpty()) {
            String out = add.get(0).getPath();
            if (add.size() > 1) {
                for (int a = 1; a < add.size(); ++a) {
                    out = out + "<//>" + add.get(a).getPath();
                }
            }
            Settings.put("modmaker.plugins.add", out);
        }
    }

    private static void loadIgnore() {
    }

    private static void saveIgnore() {
    }

    private static class PluginData {
        private final Plugin plugin;
        private final ClassLoader loader;
        private final File file;

        public PluginData(Plugin plugin, ClassLoader loader, File file) {
            this.plugin = plugin;
            this.loader = loader;
            this.file = file;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class UpdateData {
        private final Plugin plugin;
        private final double version;
        private final URL link;
        private final String name;
        private final JProgressBar pb;
        private final File of;
        private int state = 0;
        private ArrayList<ValueChangeListener> listeners = new ArrayList();
        public static final int NEED_UPDATE = 0;
        public static final int UPDATING = 1;
        public static final int FAILED = 2;
        public static final int DONE = 3;

        public UpdateData(Plugin plugin, String name, double newVersion, URL link, File outputFile) {
            this.plugin = plugin;
            this.version = newVersion;
            this.link = link;
            this.name = name;
            this.of = outputFile;
            this.pb = new JProgressBar();
            this.pb.setStringPainted(true);
        }

        public void addValueChangedListener(ValueChangeListener l) {
            this.listeners.add(l);
        }

        public File getOutputFile() {
            return this.of;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public double getNewVersion() {
            return this.version;
        }

        public URL getLink() {
            return this.link;
        }

        public String getName() {
            return this.name;
        }

        public void setProgress(int progress) {
            this.pb.setValue(progress);
            for (ValueChangeListener l : this.listeners) {
                l.onValueChange(progress);
            }
        }

        public JProgressBar getProgressBar() {
            return this.pb;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public String getStateAsString() {
            if (this.state == 0) {
                return "Need Update";
            }
            if (this.state == 1) {
                return "Updating";
            }
            if (this.state == 2) {
                return "Failed";
            }
            if (this.state == 3) {
                return "Done";
            }
            return "";
        }
    }

    public static interface ValueChangeListener {
        public void onValueChange(int var1);
    }
}

