/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Recipes;

import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.IO.SaveManager;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class Recipes
extends SaveBase {
    public BlockItemHolder[] items = new BlockItemHolder[10];
    public boolean isShapeless = false;
    public boolean is3x3 = true;
    public int amount = 1;

    public Recipes(Plugin plugin, Mod mod) {
        super(plugin, mod);
    }

    @Override
    public void Load(String line) {
        if (line.startsWith("Name:")) {
            this.setName(line.substring("Name:".length()));
        } else if (line.startsWith("Shapeless:")) {
            this.isShapeless = Boolean.parseBoolean(line.substring("Shapeless:".length()));
        } else if (line.startsWith("Size3x3:")) {
            this.is3x3 = Boolean.parseBoolean(line.substring("Size3x3:".length()));
        } else if (line.startsWith("Size:")) {
            this.is3x3 = Integer.parseInt(line.substring("Size:".length())) == 3;
        } else if (line.startsWith("Amount:")) {
            this.amount = Integer.parseInt(line.substring("Amount:".length()));
        } else if (line.startsWith("Item_")) {
            int index = Integer.parseInt(line.substring("item_".length(), "item_".length() + 1));
            this.items[index] = new BlockItemHolder(line.substring("item_a:".length()), this.getMod());
        }
    }

    @Override
    public void Save(SaveManager.BufWriter bf) throws IOException {
        bf.writeLine("Name:" + this.getName());
        bf.writeLine("Shapeless:" + this.isShapeless);
        bf.writeLine("Size3x3:" + this.is3x3);
        bf.writeLine("Amount:" + this.amount);
        for (int a = 0; a < this.items.length; ++a) {
            if (this.items[a] == null) continue;
            bf.writeLine("Item_" + a + ":" + this.items[a].getData());
        }
    }

    @Override
    public void Check(ArrayList<String> log) {
        String error;
        Recipes r = this;
        if (r.amount < 1) {
            log.add("Recipe " + r.getName() + ": Invallid Amount: " + r.amount);
        }
        if (r.items[9] == null) {
            log.add("Recipe " + r.getName() + ": No Out Item");
        } else {
            error = Export.ContainsError(r.items[9].getJavaName());
            if (error != null) {
                log.add("Recipe " + r.getName() + ": Out " + error);
            }
        }
        boolean items = false;
        for (int b = 0; b < r.items.length; ++b) {
            if (r.items[b] == null) continue;
            items = true;
            error = Export.ContainsError(r.items[b].getJavaName());
            if (error == null) continue;
            log.add("Recipe " + r.getName() + ": Item" + b + " " + error);
        }
        if (!items) {
            log.add("Recipe " + r.getName() + ": No In Items");
        }
    }

    @Override
    public SaveBase getNewChild() {
        return null;
    }

    @Override
    public PanelBase getNewChildPanel(SaveBase child) {
        return null;
    }
}

