/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.textureeditor.Texture;

public class AddTexture
extends JDialog {
    public static final int RET_OK = 0;
    public static final int RET_CANCEL = 1;
    private Texture tex;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private int returnStatus;

    public AddTexture(Window parent, boolean modal, File root) {
        super(parent);
        this.setModal(modal);
        this.initComponents();
        this.jTextField2.setText(root.getPath());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel3 = new JPanel();
        this.jTextField2 = new JTextField();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("New Texture");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddTexture.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Texture Name"));
        this.jTextField1.setText("New Texture");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -2, -1, -2));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.jLabel1.setText("Width: ");
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)16, Integer.valueOf(1), null, (Number)1));
        this.jLabel2.setText("Height:");
        this.jSpinner2.setModel(new SpinnerNumberModel((Number)16, Integer.valueOf(1), null, (Number)1));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinner1, -1, 70, Short.MAX_VALUE).addComponent(this.jSpinner2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner2, -2, -1, -2)).addGap(0, 89, Short.MAX_VALUE)));
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddTexture.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddTexture.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Directory"));
        this.jButton3.setText("...");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddTexture.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField2, -1, 284, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jButton3)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 70, -2)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            File dir = new File(this.jTextField2.getText());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (dir.isFile()) {
                OptionPane.showMessageDialog(this, "Directory is a file!", "Dir exists", 2);
            } else {
                File file = new File(dir.getPath() + "/" + this.jTextField1.getText() + ".dmet");
                if (file.exists()) {
                    OptionPane.showMessageDialog(this, "File already exists!", "File exists", 2);
                } else {
                    int w = this.jSpinner1.getValue().hashCode();
                    int h = this.jSpinner2.getValue().hashCode();
                    if (w > 0 && h > 0) {
                        this.tex = new Texture(w, h);
                        this.tex.setSaveFile(file);
                        this.doClose(0);
                    } else {
                        OptionPane.showMessageDialog(this, "Wrong value for width and height", "Wrong width and height!", 2);
                    }
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose(1);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            File file = FileChooser.showDialog(this.jTextField2.getText(), FileChooser.OPEN_DIALOG, 0, 0, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Folders";
                }
            });
            if (file != null) {
                this.jTextField2.setText(file.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void doClose(int ret) {
        this.returnStatus = ret;
        this.setVisible(false);
        this.dispose();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Texture getTexture() {
        return this.tex;
    }
}

