/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.ColorChooser;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;
import net.modmaker.textureeditor.DrawingPanel;

public class ColorPanel
extends JPanel {
    private static Color[] colors = new Color[]{Color.BLACK, Color.WHITE, Color.DARK_GRAY, Color.gray, Color.LIGHT_GRAY, Color.GREEN, Color.BLUE, Color.CYAN, Color.PINK, Color.MAGENTA, Color.ORANGE, Color.RED, Color.YELLOW};
    private JButton addButton;
    private ArrayList<Color> cls = new ArrayList();
    private ArrayList<JButton> buttons = new ArrayList();
    private DrawingPanel panel;
    private int count;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JToggleButton leftButton;
    private JToggleButton rightButton;

    public ColorPanel(DrawingPanel p) {
        this.panel = p;
        this.initComponents();
        this.leftButton.setIcon(new ImageIcon(Textures.getBlankImage(Color.BLACK, 45, 25)));
        this.rightButton.setIcon(new ImageIcon(Textures.getBlankImage(Color.WHITE, 45, 25)));
        this.cls.addAll(Arrays.asList(colors));
        String value = Settings.get("modmaker.textureeditor.colors");
        if (value != null) {
            try {
                String[] values;
                for (String data : values = value.split(":")) {
                    try {
                        Color color;
                        if (!data.contains(",")) continue;
                        String[] dat = data.split(",");
                        if (dat.length == 4) {
                            color = new Color(Integer.parseInt(dat[0]), Integer.parseInt(dat[1]), Integer.parseInt(dat[2]), Integer.parseInt(dat[3]));
                            this.cls.add(color);
                            continue;
                        }
                        if (dat.length != 3) continue;
                        color = new Color(Integer.parseInt(dat[0]), Integer.parseInt(dat[1]), Integer.parseInt(dat[2]));
                        this.cls.add(color);
                    }
                    catch (Throwable e) {
                        Console.Err(e);
                    }
                }
            }
            catch (Throwable e) {
                Console.Err(e);
            }
        }
        this.init();
        this.addButton = new JButton();
        this.addButton.setSize(25, 25);
        this.addButton.setBorder(BorderFactory.createBevelBorder(1));
        this.add(this.addButton);
        if (this.buttons.size() % 2 == 0) {
            this.addButton.setLocation(130 + 25 * (this.buttons.size() / 2), 20);
        } else {
            this.addButton.setLocation(130 + 25 * (this.buttons.size() / 2), 45);
        }
        this.addButton.setContentAreaFilled(false);
        this.addButton.setIcon(new ImageIcon(Textures.Plus));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooser cc = new ColorChooser((Window)ColorPanel.this.panel.getTextureEditor(), Color.black);
                cc.setVisible(true);
                if (cc.getReturnStatus() == 1) {
                    Color c;
                    JButton button = new JButton();
                    button.setOpaque(false);
                    ColorPanel.this.add(button);
                    button.setSize(25, 25);
                    button.setBorder(BorderFactory.createBevelBorder(1));
                    button.setIcon(new ImageIcon(Textures.getBlankImage(cc.getColorChooser().getColor(), 25, 25)));
                    if (ColorPanel.this.leftButton.isSelected()) {
                        c = cc.getColorChooser().getColor();
                        ColorPanel.this.leftButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                        ColorPanel.this.panel.setSelectedColorLeft(c);
                    } else if (ColorPanel.this.rightButton.isSelected()) {
                        c = cc.getColorChooser().getColor();
                        ColorPanel.this.rightButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                        ColorPanel.this.panel.setSelectedColorRight(c);
                    }
                    int i = 0;
                    if (ColorPanel.this.cls.size() > 28) {
                        int rem = colors.length + ColorPanel.this.count;
                        ColorPanel.this.count++;
                        if (ColorPanel.this.count + colors.length >= ColorPanel.this.cls.size()) {
                            ColorPanel.this.count = 0;
                        }
                        ColorPanel.this.cls.remove(rem);
                        ColorPanel.this.cls.add(rem, cc.getColorChooser().getColor());
                        ColorPanel.this.remove((Component)ColorPanel.this.buttons.get(rem));
                        i = rem;
                        ColorPanel.this.buttons.remove(i);
                        ColorPanel.this.buttons.add(i, button);
                        if ((i + 3) % 2 == 0) {
                            button.setLocation(130 + 25 * ((i + 3) / 2), 20);
                        } else {
                            button.setLocation(130 + 25 * ((i + 3) / 2), 45);
                        }
                    } else {
                        int id;
                        i = id = ColorPanel.this.buttons.size();
                        if ((id + 3) % 2 == 0) {
                            button.setLocation(130 + 25 * ((id + 3) / 2), 20);
                        } else {
                            button.setLocation(130 + 25 * ((id + 3) / 2), 45);
                        }
                        ColorPanel.this.buttons.add(button);
                        ColorPanel.this.cls.add(cc.getColorChooser().getColor());
                    }
                    final int b = i;
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (ColorPanel.this.leftButton.isSelected()) {
                                Color c = (Color)ColorPanel.this.cls.get(b);
                                ColorPanel.this.leftButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                                ColorPanel.this.panel.setSelectedColorLeft(c);
                            } else if (ColorPanel.this.rightButton.isSelected()) {
                                Color c = (Color)ColorPanel.this.cls.get(b);
                                ColorPanel.this.rightButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                                ColorPanel.this.panel.setSelectedColorRight(c);
                            }
                        }
                    });
                    String value = "";
                    for (int a = colors.length; a < ColorPanel.this.cls.size(); ++a) {
                        Color col = (Color)ColorPanel.this.cls.get(a);
                        value = value + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "," + col.getAlpha() + ";";
                    }
                    if (!value.equals("")) {
                        Settings.put("modmaker.textureeditor.colors", value);
                    }
                }
            }
        });
    }

    public void init() {
        int i = 0;
        while (i < this.cls.size()) {
            JButton button = new JButton();
            this.buttons.add(button);
            this.add(button);
            button.setSize(25, 25);
            button.setBorder(BorderFactory.createBevelBorder(1));
            button.setIcon(new ImageIcon(Textures.getBlankImage(this.cls.get(i), 25, 25)));
            int loc = i;
            if (loc >= colors.length) {
                loc += 3;
            }
            if (loc % 2 == 0) {
                button.setLocation(130 + 25 * (loc / 2), 20);
            } else {
                button.setLocation(130 + 25 * (loc / 2), 45);
            }
            final int b = i++;
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ColorPanel.this.leftButton.isSelected()) {
                        Color c = (Color)ColorPanel.this.cls.get(b);
                        ColorPanel.this.leftButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                        ColorPanel.this.panel.setSelectedColorLeft(c);
                    } else if (ColorPanel.this.rightButton.isSelected()) {
                        Color c = (Color)ColorPanel.this.cls.get(b);
                        ColorPanel.this.rightButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
                        ColorPanel.this.panel.setSelectedColorRight(c);
                    }
                }
            });
        }
    }

    public void setSelectedColor(Color c) {
        if (this.leftButton.isSelected()) {
            this.leftButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
            this.panel.setSelectedColorLeft(c);
        } else if (this.rightButton.isSelected()) {
            this.rightButton.setIcon(new ImageIcon(Textures.getBlankImage(c, 45, 25)));
            this.panel.setSelectedColorRight(c);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.leftButton = new JToggleButton();
        this.rightButton = new JToggleButton();
        this.jButton1 = new JButton();
        this.setBackground(new Color(51, 51, 51));
        this.setBorder(BorderFactory.createTitledBorder(null, "Color Properties", 0, 0, new Font("Tahoma", 0, 11), new Color(204, 204, 204)));
        this.setLayout(null);
        this.buttonGroup1.add(this.leftButton);
        this.leftButton.setSelected(true);
        this.add(this.leftButton);
        this.leftButton.setBounds(10, 20, 50, 30);
        this.buttonGroup1.add(this.rightButton);
        this.add(this.rightButton);
        this.rightButton.setBounds(40, 40, 50, 30);
        this.jButton1.setIcon(new ImageIcon(Textures.Switch));
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.add(this.jButton1);
        this.jButton1.setBounds(60, 20, 30, 20);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Icon icon = this.leftButton.getIcon();
        Icon icon2 = this.rightButton.getIcon();
        this.leftButton.setIcon(icon2);
        this.rightButton.setIcon(icon);
        Color c = this.panel.getSelectedColorLeft();
        Color c2 = this.panel.getSelectedColorRight();
        this.panel.setSelectedColorLeft(c2);
        this.panel.setSelectedColorRight(c);
    }

    public static void main(String[] args) {
        System.out.println(0);
    }
}

