/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.modmaker.events.ColorUpdateEvent;
import net.modmaker.events.Listeners.ColorChangeListener;
import net.modmaker.events.Listeners.ToolChangeListener;
import net.modmaker.events.ToolChangeEvent;
import net.modmaker.textureeditor.Texture;
import net.modmaker.textureeditor.TextureEditor;
import net.modmaker.textureeditor.layers.Layer;
import net.modmaker.textureeditor.tools.Tool;

public class DrawingPanel
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener {
    private final TextureEditor te;
    private ArrayList<Layer> layers = new ArrayList();
    private Layer bottomLayer;
    private ArrayList<ColorChangeListener> colorListeners = new ArrayList();
    private ArrayList<ToolChangeListener> toolListeners = new ArrayList();
    private int w;
    private int h;
    private Dimension preferredSize = new Dimension();
    private Tool selectedTool;
    private Tool lastTool;
    private Color selectedColorL = Color.black;
    private Color selectedColorR = Color.white;
    private boolean isDownR = false;
    private boolean isDownL = false;
    private Texture texture;

    public DrawingPanel(Texture tex, TextureEditor te) {
        this.te = te;
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setTexture(tex);
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double aspect = (double)this.w / (double)this.h;
        Rectangle paintDim = new Rectangle();
        paintDim.setSize((int)((double)(this.getHeight() / 3) * aspect), this.getHeight() / 3);
        paintDim.setLocation((int)((double)(this.getWidth() / 2) - paintDim.getWidth() / 2.0), this.getHeight() / 3);
        if (this.bottomLayer != null) {
            g.drawImage(this.bottomLayer, (int)paintDim.getX(), (int)paintDim.getY(), (int)paintDim.getWidth(), (int)paintDim.getHeight(), this);
        }
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            g.drawImage(layer, (int)paintDim.getX(), (int)paintDim.getY(), (int)paintDim.getWidth(), (int)paintDim.getHeight(), this);
        }
    }

    public TextureEditor getTextureEditor() {
        return this.te;
    }

    public void addToolChangeListener(ToolChangeListener l) {
        this.toolListeners.add(l);
    }

    public void removeToolChangeListener(ToolChangeListener l) {
        this.toolListeners.remove(l);
    }

    public void addColorChangeListener(ColorChangeListener l) {
        this.colorListeners.add(l);
    }

    public void removeColorChangeListener(ColorChangeListener l) {
        this.colorListeners.remove(l);
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool selectedTool) {
        this.lastTool = this.selectedTool;
        this.selectedTool = selectedTool;
        this.setCursor(selectedTool.getCursor());
        ToolChangeEvent evt = new ToolChangeEvent(this, this.lastTool, this.selectedTool);
        for (ToolChangeListener l : this.toolListeners) {
            if (evt.isCanceled()) continue;
            l.onToolChange(evt);
        }
    }

    public Tool getLastTool() {
        return this.lastTool;
    }

    public void setSelectedColorLeft(Color color) {
        Color last = this.selectedColorL;
        this.selectedColorL = color;
        ColorUpdateEvent evt = new ColorUpdateEvent(this, last, color);
        for (ColorChangeListener l : this.colorListeners) {
            if (evt.isCanceled()) continue;
            l.onColorLeftChange(evt);
        }
    }

    public Color getSelectedColorLeft() {
        return this.selectedColorL;
    }

    public void setSelectedColorRight(Color color) {
        Color last = this.selectedColorR;
        this.selectedColorR = color;
        ColorUpdateEvent evt = new ColorUpdateEvent(this, last, color);
        for (ColorChangeListener l : this.colorListeners) {
            if (evt.isCanceled()) continue;
            l.onColorRightChange(evt);
        }
    }

    public Color getSelectedColorRight() {
        return this.selectedColorR;
    }

    public void setSelectedColor(Color color) {
        this.te.colorPanel.setSelectedColor(color);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this.preferredSize = d;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void updateCursor() {
        if (this.selectedTool == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.selectedTool.getCursor());
        }
    }

    public Layer getTopLayer() {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!this.layers.get(i).isVisible()) continue;
            return this.layers.get(i);
        }
        return null;
    }

    private Point getPixelPoint(int x, int y) {
        Point point = new Point();
        double aspect = (double)this.w / (double)this.h;
        Rectangle paintDim = new Rectangle();
        paintDim.setSize((int)((double)(this.getHeight() / 3) * aspect), this.getHeight() / 3);
        paintDim.setLocation((int)((double)(this.getWidth() / 2) - paintDim.getWidth() / 2.0), this.getHeight() / 3);
        if ((double)x > paintDim.getX() + paintDim.getWidth() || (double)x < paintDim.getX() || (double)y > paintDim.getY() + paintDim.getHeight() || (double)y < paintDim.getY()) {
            return null;
        }
        x = (int)((double)x - paintDim.getX() - paintDim.getWidth() / (double)this.w * 0.5);
        y = (int)((double)y - paintDim.getY() - paintDim.getHeight() / (double)this.w * 0.5);
        double px = (double)x / paintDim.getWidth();
        double py = (double)y / paintDim.getHeight();
        point.setLocation(px * (double)this.w, py * (double)this.h);
        if (point.getX() == 16.0) {
            point.setLocation(15.0, point.getY());
        }
        if (point.getY() == 16.0) {
            point.setLocation(point.getX(), 15.0);
        }
        return point;
    }

    public ArrayList<Layer> getLayers() {
        return this.layers;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public void addLayer(Layer layer, int i) {
        this.layers.add(i, layer);
    }

    public void removeLayer(Layer layer) {
        this.layers.remove(layer);
    }

    public void removeLayer(int i) {
        this.layers.remove(i);
    }

    public Layer getLayer(int i) {
        return this.layers.get(i);
    }

    public int getPixWidth() {
        return this.w;
    }

    public void setPixWidth(int w) {
        this.w = w;
    }

    public int getPixHeight() {
        return this.h;
    }

    public void setPixHeight(int h) {
        this.h = h;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            return null;
        }
        this.texture.clearLayers();
        for (Layer layer : this.layers) {
            Layer l = new Layer(layer.getName(), layer.getWidth(), layer.getHeight());
            Graphics2D g = l.createGraphics();
            g.drawImage(layer, 0, 0, this.w, this.h, null);
            g.dispose();
            this.texture.addLayer(l);
        }
        return this.texture;
    }

    public void setTexture(Texture tex) {
        this.layers.clear();
        if (tex == null) {
            this.w = 0;
            this.h = 0;
            this.texture = null;
        } else {
            this.w = tex.getWidth();
            this.h = tex.getHeight();
            this.texture = tex;
            for (Layer layer : tex.getLayers()) {
                Layer l = new Layer(layer.getName(), layer.getWidth(), layer.getHeight());
                Graphics2D g = l.createGraphics();
                g.drawImage(layer, 0, 0, this.w, this.h, null);
                g.dispose();
                this.addLayer(l);
            }
            if (this.layers.isEmpty()) {
                this.layers.add(new Layer("Layer 1", this.w, this.h));
            }
            this.bottomLayer = new Layer("Bottom Layer", this.w, this.h);
            Graphics2D g = this.bottomLayer.createGraphics();
            boolean draw = false;
            for (int x = 0; x < this.w; ++x) {
                for (int y = 0; y < this.h; ++y) {
                    if (draw) {
                        g.setColor(new Color(150, 150, 150));
                    } else {
                        g.setColor(new Color(80, 80, 80));
                    }
                    draw = !draw;
                    g.fillRect(x, y, 1, 1);
                }
                draw = !draw;
            }
            g.dispose();
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int n = e.getWheelRotation();
        Point p = e.getPoint();
        double d = (double)n * 1.08;
        d = n > 0 ? 1.0 / d : -d;
        int w = (int)((double)this.getWidth() * d);
        int h = (int)((double)this.getHeight() * d);
        this.preferredSize.setSize(w, h);
        int offX = (int)((double)p.x * d) - p.x;
        int offY = (int)((double)p.y * d) - p.y;
        this.setLocation(this.getLocation().x - offX, this.getLocation().y - offY);
        this.getParent().doLayout();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedTool != null) {
            Point point;
            if (this.isDownL) {
                Point point2 = this.getPixelPoint(e.getX(), e.getY());
                if (point2 != null && this.getTopLayer() != null) {
                    this.selectedTool.onLeftClick(this, this.selectedColorL, this.getTopLayer(), (int)point2.getX(), (int)point2.getY());
                    this.repaint();
                    this.te.layerPanel.update();
                }
            } else if (this.isDownR && (point = this.getPixelPoint(e.getX(), e.getY())) != null && this.getTopLayer() != null) {
                this.selectedTool.onRightClick(this, this.selectedColorR, this.getTopLayer(), (int)point.getX(), (int)point.getY());
                this.repaint();
                this.te.layerPanel.update();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.isDownL = true;
        } else if (e.getButton() == 3) {
            this.isDownR = true;
        }
        if (this.selectedTool != null) {
            Point point;
            if (this.isDownL) {
                Point point2 = this.getPixelPoint(e.getX(), e.getY());
                if (point2 != null && this.getTopLayer() != null) {
                    this.selectedTool.onLeftClick(this, this.selectedColorL, this.getTopLayer(), (int)point2.getX(), (int)point2.getY());
                    this.repaint();
                    this.te.layerPanel.update();
                }
            } else if (this.isDownR && (point = this.getPixelPoint(e.getX(), e.getY())) != null && this.getTopLayer() != null) {
                this.selectedTool.onRightClick(this, this.selectedColorR, this.getTopLayer(), (int)point.getX(), (int)point.getY());
                this.repaint();
                this.te.layerPanel.update();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.isDownL = false;
        } else if (e.getButton() == 3) {
            this.isDownR = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

