/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import net.modmaker.textureeditor.DrawingPanel;

public class HandScrollListener
extends JScrollPane
implements MouseListener,
MouseMotionListener {
    private final Cursor hndCursor = Cursor.getPredefinedCursor(12);
    private final Point pp = new Point();
    private final DrawingPanel panel;
    private boolean isDown = false;

    public HandScrollListener(DrawingPanel panel) {
        super(panel);
        this.panel = panel;
        panel.addMouseListener(this);
        panel.addMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 2) {
            this.panel.setCursor(this.hndCursor);
            this.pp.setLocation(e.getPoint());
            this.isDown = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 2) {
            this.panel.updateCursor();
            this.panel.repaint();
            this.isDown = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isDown) {
            JViewport vport = this.getViewport();
            Point cp = e.getPoint();
            Point vp = vport.getViewPosition();
            vp.translate(this.pp.x - cp.x, this.pp.y - cp.y);
            this.panel.scrollRectToVisible(new Rectangle(vp, vport.getSize()));
            this.pp.setLocation(cp);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

