/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.textureeditor.DrawingPanel;
import net.modmaker.textureeditor.LayerChooser;
import net.modmaker.textureeditor.layers.Layer;

public class LayerPanel
extends JPanel {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton5;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private DrawingPanel drawingPanel;

    public LayerPanel(DrawingPanel panel) {
        this.initComponents();
        this.drawingPanel = panel;
        this.jList2.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return LayerPanel.this.drawingPanel.getLayers().size();
            }

            @Override
            public Object getElementAt(int i) {
                return LayerPanel.this.drawingPanel.getLayer(i);
            }
        });
        this.jList2.setCellRenderer(new customListRenderer());
        this.jList2.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jButton5 = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Layers"));
        this.jList2.setSelectionMode(0);
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayerPanel.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.jButton5.setText("Remove  Layer");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Add Layer");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Move Up");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Move Down");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 314, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton5).addComponent(this.jButton3)).addGap(0, 0, 0)));
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Layer Properties"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 190, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        try {
            int row = this.jList2.getSelectedIndex();
            if (row > -1) {
                Layer layer = this.drawingPanel.getLayer(row);
                JPanel panel = layer.getPropPanel(this.drawingPanel);
                if (panel == null) {
                    panel = this.jPanel2;
                }
                this.jSplitPane1.setRightComponent(panel);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            int row = this.jList2.getSelectedIndex();
            if (row > 0 && row < this.drawingPanel.getLayers().size()) {
                Layer layer = this.drawingPanel.getLayer(row);
                this.drawingPanel.removeLayer(row);
                this.drawingPanel.addLayer(layer, row - 1);
                this.update();
                this.jList2.setSelectedIndex(row - 1);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            int row = this.jList2.getSelectedIndex();
            if (row > -1 && row < this.drawingPanel.getLayers().size() - 1) {
                Layer layer = this.drawingPanel.getLayer(row);
                this.drawingPanel.removeLayer(row);
                this.drawingPanel.addLayer(layer, row + 1);
                this.update();
                this.jList2.setSelectedIndex(row + 1);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            LayerChooser lc = new LayerChooser(this.drawingPanel);
            lc.setVisible(true);
            if (lc.getReturnStatus() == 0) {
                Layer layer = lc.getSelectedLayer();
                this.drawingPanel.addLayer(layer);
                this.update();
                this.jList2.setSelectedIndex(this.drawingPanel.getLayers().size() - 1);
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        try {
            int row = this.jList2.getSelectedIndex();
            if (row > -1) {
                Layer layer = this.drawingPanel.getLayer(row);
                int ret = OptionPane.showConfirmDialog(this, "Are you sure you want to remove this layer?", "Remove layer", 0, 3);
                if (ret == 0) {
                    this.drawingPanel.removeLayer(row);
                    this.update();
                    this.drawingPanel.repaint();
                    this.jSplitPane1.setRightComponent(this.jPanel2);
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public void update() {
        this.jList2.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return LayerPanel.this.drawingPanel.getLayers().size();
            }

            @Override
            public Object getElementAt(int i) {
                return LayerPanel.this.drawingPanel.getLayer(i);
            }
        });
    }

    public class customListRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = LayerPanel.this.drawingPanel.getLayer(index);
            if (layer.getName() == null) {
                this.setText("Layer " + (index + 1));
            } else {
                this.setText(layer.getName());
            }
            this.setIcon(new ImageIcon(layer));
            if (isSelected) {
                this.setOpaque(true);
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setOpaque(false);
                this.setBackground(list.getBackground());
                if (layer.isVisible()) {
                    this.setForeground(list.getForeground());
                } else {
                    this.setForeground(Color.gray);
                }
            }
            return this;
        }
    }
}

