/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.textureeditor.layers.Layer;

public class Texture {
    private int w;
    private int h;
    private ArrayList<Layer> layers = new ArrayList();
    private File saveFile;

    public Texture(File saveFile) {
        this.saveFile = saveFile;
    }

    public Texture() {
    }

    public Texture(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public int getWidth() {
        return this.w;
    }

    public void setWidth(int w) {
        this.w = w;
    }

    public int getHeight() {
        return this.h;
    }

    public void setHeight(int h) {
        this.h = h;
    }

    public ArrayList<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(ArrayList<Layer> layers) {
        this.layers = layers;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public void addLayer(int i, Layer layer) {
        this.layers.add(i, layer);
    }

    public void removeLayer(Layer layer) {
        this.layers.remove(layer);
    }

    public void removeLayer(int i) {
        this.layers.remove(i);
    }

    public Layer getLayer(int i) {
        return this.layers.get(i);
    }

    public void clearLayers() {
        this.layers.clear();
    }

    public BufferedImage getImage() {
        BufferedImage out = new BufferedImage(this.w, this.h, 2);
        Graphics2D g = out.createGraphics();
        for (Layer layer : this.layers) {
            g.drawImage(layer, 0, 0, this.w, this.h, null);
        }
        g.dispose();
        return out;
    }

    public void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.saveFile));
        writer.write("w:" + this.w);
        writer.newLine();
        writer.write("h:" + this.h);
        writer.newLine();
        for (Layer layer : this.layers) {
            writer.write("<layer>");
            writer.newLine();
            writer.write("visible:" + layer.isVisible());
            writer.newLine();
            if (layer.getName() != null) {
                writer.write("name:" + layer.getName());
                writer.newLine();
            }
            BufferedImageSeri seri = new BufferedImageSeri(layer);
            writer.write("data:" + seri.toString());
            writer.newLine();
            writer.write("</layer>");
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }

    public static Texture load(File file) throws IOException {
        try {
            Texture tex = new Texture(file);
            if (file.getName().endsWith(".dmet")) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("w:")) {
                        tex.setWidth(Integer.parseInt(line.substring(2)));
                        continue;
                    }
                    if (line.startsWith("h:")) {
                        tex.setHeight(Integer.parseInt(line.substring(2)));
                        continue;
                    }
                    if (!line.startsWith("<layer>")) continue;
                    Layer layer = new Layer(null, tex.getWidth(), tex.getHeight());
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("visible:")) {
                            layer.setVisible(Boolean.parseBoolean(line.substring("visible:".length())));
                            continue;
                        }
                        if (line.startsWith("name:")) {
                            layer.setName(line.substring("name:".length()));
                            continue;
                        }
                        if (line.startsWith("data:")) {
                            BufferedImageSeri seri = new BufferedImageSeri(line.substring("data:".length()));
                            boolean v = layer.isVisible();
                            String name = layer.getName();
                            layer = seri.getLayer();
                            layer.setVisible(v);
                            layer.setName(name);
                            continue;
                        }
                        if (!line.startsWith("</layer>")) continue;
                    }
                    tex.addLayer(layer);
                }
                reader.close();
                if (tex.getWidth() <= 0 || tex.getHeight() <= 0) {
                    Console.Warning("Wrong size: " + tex.getWidth() + "," + tex.getHeight());
                    return null;
                }
            } else if (file.getName().endsWith(".png") || file.getName().endsWith(".jpeg") || file.getName().endsWith(".jpg") || file.getName().endsWith(".bmp") || file.getName().endsWith(".dip") || file.getName().endsWith(".jpe") || file.getName().endsWith(".jfif") || file.getName().endsWith(".gif")) {
                BufferedImage image = ImageIO.read(new FileInputStream(file));
                tex.setWidth(image.getWidth());
                tex.setHeight(image.getHeight());
                Layer layer = new Layer("Layer 0", tex.getWidth(), tex.getHeight());
                for (int x = 0; x < tex.getWidth(); ++x) {
                    for (int y = 0; y < tex.getHeight(); ++y) {
                        layer.setRGB(x, y, image.getRGB(x, y));
                    }
                }
                tex.addLayer(layer);
            } else {
                String[] ext = file.getName().split(".");
                Console.Warning("Unknown extention: " + ext[ext.length - 1]);
                return null;
            }
            return tex;
        }
        catch (Throwable e) {
            Console.Err(e);
            return null;
        }
    }
}

