/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.MenuBarUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;
import net.modmaker.textureeditor.AddTexture;
import net.modmaker.textureeditor.ColorPanel;
import net.modmaker.textureeditor.DrawingPanel;
import net.modmaker.textureeditor.HandScrollListener;
import net.modmaker.textureeditor.LayerPanel;
import net.modmaker.textureeditor.Texture;
import net.modmaker.textureeditor.ToolPanel;
import net.modmaker.textureeditor.layers.Layer;

public class TextureEditor
extends JDialog {
    private DrawingPanel drawingPanel;
    private ToolPanel toolPanel;
    public ColorPanel colorPanel;
    public LayerPanel layerPanel;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane4;
    private JTree jTree1;

    public TextureEditor(Frame parent, Texture tex) {
        super(parent, true);
        this.initComponents();
        this.drawingPanel = new DrawingPanel(tex, this);
        HandScrollListener scroll = new HandScrollListener(this.drawingPanel);
        this.toolPanel = new ToolPanel(this.drawingPanel);
        this.colorPanel = new ColorPanel(this.drawingPanel);
        this.layerPanel = new LayerPanel(this.drawingPanel);
        this.jSplitPane4.setRightComponent(scroll);
        this.jSplitPane4.setLeftComponent(this.toolPanel);
        this.jPanel2.add((Component)this.colorPanel, "Center");
        this.jSplitPane1.setRightComponent(this.layerPanel);
        this.jTree1.setCellRenderer(new CustomIconRenderer());
        this.refreshTree();
        if (tex == null) {
            this.jSplitPane2.setRightComponent(new JLabel("No Textures Loaded"));
        }
        this.jMenuBar1.setUI(new MenuBarUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                for (int i = 0; i < c.getHeight(); ++i) {
                    int v = i * 5;
                    if (v > 200) {
                        v = 200;
                    }
                    g.setColor(new Color(200 - v, 200 - v, 200 - v));
                    g.fillRect(0, i, TextureEditor.this.getWidth(), 1);
                }
            }
        });
        this.jMenu1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jMenu2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jMenu1.setBackground(new Color(51, 51, 51));
        this.jMenu2.setBackground(new Color(51, 51, 51));
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jSplitPane4 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jSplitPane2.setDividerLocation(150);
        this.jScrollPane1.setBackground(new Color(100, 100, 100));
        this.jScrollPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.jTree1.setBackground(new Color(100, 100, 100));
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TextureEditor.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane2.setLeftComponent(this.jScrollPane1);
        this.jSplitPane1.setBackground(new Color(100, 100, 100));
        this.jSplitPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.jSplitPane1.setResizeWeight(1.0);
        this.jPanel2.setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane4, -1, 661, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSplitPane4, -1, 493, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jPanel2, -2, 80, -2)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane2.setRightComponent(this.jSplitPane1);
        this.jMenu1.setForeground(new Color(204, 204, 204));
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem1.setForeground(new Color(204, 204, 204));
        this.jMenuItem1.setText("New Texture");
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem2.setForeground(new Color(204, 204, 204));
        this.jMenuItem2.setText("Open");
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem3.setForeground(new Color(204, 204, 204));
        this.jMenuItem3.setText("Save");
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        this.jMenuItem4.setForeground(new Color(204, 204, 204));
        this.jMenuItem4.setText("Save As...");
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItem5.setForeground(new Color(204, 204, 204));
        this.jMenuItem5.setText("Export");
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.jMenuItem6.setForeground(new Color(204, 204, 204));
        this.jMenuItem6.setText("Import");
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuItem7.setForeground(new Color(204, 204, 204));
        this.jMenuItem7.setText("Close");
        this.jMenu1.add(this.jMenuItem7);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setForeground(new Color(204, 204, 204));
        this.jMenu2.setText("Edit");
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuItem8.setForeground(new Color(204, 204, 204));
        this.jMenuItem8.setText("Undo");
        this.jMenu2.add(this.jMenuItem8);
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuItem9.setForeground(new Color(204, 204, 204));
        this.jMenuItem9.setText("Redo");
        this.jMenu2.add(this.jMenuItem9);
        this.jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem10.setForeground(new Color(204, 204, 204));
        this.jMenuItem10.setText("Copy");
        this.jMenu2.add(this.jMenuItem10);
        this.jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem11.setForeground(new Color(204, 204, 204));
        this.jMenuItem11.setText("Paste");
        this.jMenu2.add(this.jMenuItem11);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 915, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 915, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 579, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2)));
        this.pack();
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        try {
            if (evt.getButton() == 3) {
                TreePath path = this.jTree1.getSelectionPath();
                TreeNode[] node = new DefaultMutableTreeNode(path).getPath();
                String str = "";
                for (TreeNode tn : node) {
                    if (tn.toString() == null) {
                        return;
                    }
                    str = str + "/" + tn.toString().substring(1, tn.toString().length() - 1).replace(", ", "/");
                }
                final File file = new File(Settings.getRoot() + str);
                if (file.isFile()) {
                    JPopupMenu pop = new JPopupMenu();
                    JMenuItem item1 = new JMenuItem("Open");
                    pop.add(item1);
                    item1.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.open(file);
                        }
                    });
                    JMenuItem item2 = new JMenuItem("Refresh");
                    pop.add(item2);
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.refreshTree();
                        }
                    });
                    JMenuItem item3 = new JMenuItem("Delete");
                    pop.add(item3);
                    item3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.deleteFile(file);
                        }
                    });
                    pop.show(this, evt.getX(), evt.getY());
                } else if (file.isDirectory()) {
                    JPopupMenu pop = new JPopupMenu();
                    JMenuItem item0 = new JMenuItem("New Texture");
                    pop.add(item0);
                    item0.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.newTexture(file);
                        }
                    });
                    JMenuItem item1 = new JMenuItem("New Folder");
                    pop.add(item1);
                    item1.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.newFolder(file);
                        }
                    });
                    JMenuItem item2 = new JMenuItem("Refresh");
                    pop.add(item2);
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TextureEditor.this.refreshTree();
                        }
                    });
                    if (!file.getPath().equals(new File(Settings.getRoot() + "/textures").getPath())) {
                        JMenuItem item3 = new JMenuItem("Delete");
                        pop.add(item3);
                        item3.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TextureEditor.this.deleteFolder(file);
                            }
                        });
                    }
                    pop.show(this, evt.getX(), evt.getY());
                } else {
                    System.out.println(Settings.getRoot() + str);
                }
            } else if (evt.getClickCount() == 2 && evt.getButton() == 1) {
                TreePath path = this.jTree1.getSelectionPath();
                TreeNode[] node = new DefaultMutableTreeNode(path).getPath();
                String str = "";
                for (TreeNode tn : node) {
                    if (tn.toString() == null) {
                        return;
                    }
                    str = str + "/" + tn.toString().substring(1, tn.toString().length() - 1).replace(", ", "/");
                }
                File file = new File(Settings.getRoot() + str);
                if (file.isFile()) {
                    this.open(file);
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public boolean open(File file) {
        if (this.save()) {
            try {
                Texture texture = Texture.load(file);
                if (texture != null) {
                    this.drawingPanel.setTexture(texture);
                    int i = this.jSplitPane2.getDividerLocation();
                    this.jSplitPane2.setRightComponent(this.jSplitPane1);
                    this.jSplitPane2.setDividerLocation(i);
                    return true;
                }
            }
            catch (IOException ex) {
                Console.Err(ex);
                OptionPane.showMessageDialog(this, "Something went wrong with saving!", "Error", 0);
                return false;
            }
        }
        return false;
    }

    public boolean save() {
        Texture texture = this.drawingPanel.getTexture();
        if (texture == null) {
            return true;
        }
        try {
            if (texture.getSaveFile() != null) {
                texture.save();
                return true;
            }
            File file = FileChooser.showDialog(Settings.getRoot() + "/textures", FileChooser.OPEN_DIALOG);
            if (file != null) {
                if (file.isDirectory()) {
                    OptionPane.showMessageDialog(this, "Selected file is a directory!", "Is Directory", 2);
                    return false;
                }
                if (file.exists()) {
                    int ret = OptionPane.showConfirmDialog(this, "File already exists\n\nDo you want to override it?", "File exists", 0, 3);
                    if (ret == 0) {
                        texture.setSaveFile(file);
                        texture.save();
                        return true;
                    }
                    return false;
                }
                texture.setSaveFile(file);
                texture.save();
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(this, "Something went wrong with saving!", "Error", 0);
            return false;
        }
    }

    public boolean saveAss() {
        try {
            Texture texture = this.drawingPanel.getTexture();
            if (texture == null) {
                return true;
            }
            File file = FileChooser.showDialog(Settings.getRoot() + "/textures", FileChooser.OPEN_DIALOG);
            if (file != null) {
                if (file.isDirectory()) {
                    OptionPane.showMessageDialog(this, "Selected file is a directory!", "Is Directory", 2);
                    return false;
                }
                if (file.exists()) {
                    int ret = OptionPane.showConfirmDialog(this, "File already exists\n\nDo you want to override it?", "File exists", 0, 3);
                    if (ret == 0) {
                        texture.setSaveFile(file);
                        texture.save();
                        return true;
                    }
                    return false;
                }
                texture.setSaveFile(file);
                texture.save();
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(this, "Something went wrong with saving!", "Error", 0);
            return false;
        }
    }

    public void deleteFolder(File file) {
        int ret = OptionPane.showConfirmDialog(this, "Are you sure you want to delete this folder?", "Delete", 0, 2);
        if (ret == 0) {
            FileManager.Delete(file);
            this.refreshTree();
        }
    }

    public void deleteFile(File file) {
        int ret = OptionPane.showConfirmDialog(this, "Are you sure you want to delete this file?", "Delete", 0, 2);
        if (ret == 0) {
            file.delete();
            this.refreshTree();
        }
    }

    public void newTexture(File file) {
        try {
            AddTexture at = new AddTexture((Window)this, true, file);
            at.setVisible(true);
            if (at.getReturnStatus() == 0) {
                Texture tex = at.getTexture();
                this.drawingPanel.setTexture(tex);
                int i = this.jSplitPane2.getDividerLocation();
                this.jSplitPane2.setRightComponent(this.jSplitPane1);
                this.jSplitPane2.setDividerLocation(i);
                this.save();
                this.refreshTree();
            }
        }
        catch (Throwable e) {
            Console.Err(e);
            OptionPane.showMessageDialog(this, "Something went wrong!", "Error", 0);
        }
    }

    public void newFolder(File file) {
        String name = OptionPane.showInputDialog(this, "Folder name:", "Create new folder", 3);
        if (name != null) {
            new File(file.getPath() + "/" + name).mkdirs();
            this.refreshTree();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TextureEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TextureEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TextureEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TextureEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            UIManager.put("SplitPane.background", new ColorUIResource(51, 51, 51));
            UIManager.put("Tree.selectionBackground", new ColorUIResource(100, 100, 100));
            UIManager.put("Tree.textBackground", new ColorUIResource(100, 100, 100));
            UIManager.put("List.selectionBackground", new Color(0, 0, 0, 0));
            UIManager.put("List.selectionForeground", Color.white);
            UIManager.put("TextPane.selectionBackground", new Color(0, 0, 0, 0));
            UIManager.put("TextPane.selectionForeground", Color.white);
            UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("PopupMenu.border", new LineBorder(new Color(30, 30, 30), 2));
            UIManager.put("Menu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("Menu.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("Menu.opaque", false);
            UIManager.put("PopupMenu.background", new ColorUIResource(51, 51, 51));
            UIManager.put("PopupMenu.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("PopupMenu.opaque", true);
            UIManager.put("MenuItem.background", new ColorUIResource(51, 51, 51));
            UIManager.put("MenuItem.foreground", new ColorUIResource(204, 204, 204));
            UIManager.put("MenuItem.opaque", true);
        }
        catch (Exception e) {
            Console.Err(e);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Settings.setRoot(new File(new File("").getAbsolutePath()));
                    Textures.Load();
                }
                catch (Exception ex) {
                    Logger.getLogger(TextureEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
                Texture tex = new Texture(16, 16);
                tex.addLayer(new Layer("Layer 1", 16, 16));
                TextureEditor dialog = new TextureEditor((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void refreshTree() {
        File file = new File(Settings.getRoot() + "/textures");
        if (!file.exists() || file.isFile()) {
            file.delete();
            file.mkdirs();
        }
        DefaultMutableTreeNode node = this.listDir(file);
        this.jTree1.setModel(new DefaultTreeModel(node));
        for (int row = 0; row < this.jTree1.getRowCount(); ++row) {
            this.jTree1.expandRow(row);
        }
    }

    private DefaultMutableTreeNode listDir(File file) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(file.getName());
        File[] list = file.listFiles();
        if (list != null) {
            for (File child : list) {
                if (child.isFile()) {
                    if (!child.getName().endsWith(".dmet") && !child.getName().endsWith(".png") && !child.getName().endsWith(".jpeg") && !child.getName().endsWith(".jpg") && !child.getName().endsWith(".bmp") && !child.getName().endsWith(".dip") && !child.getName().endsWith(".jpe") && !child.getName().endsWith(".jfif") && !child.getName().endsWith(".gif")) continue;
                    node.add(new DefaultMutableTreeNode(child.getName()));
                    continue;
                }
                if (!child.isDirectory()) continue;
                node.add(this.listDir(child));
            }
        }
        return node;
    }

    private class CustomIconRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon file;

        public CustomIconRenderer() {
            try {
                this.file = new ImageIcon(Textures.Transparent(Color.black, ImageIO.read(this.getClass().getResourceAsStream("/net/modmaker/res/File.png"))));
            }
            catch (IOException e) {
                Console.Err(e);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setOpaque(false);
            TreeNode[] path = node.getPath();
            String str = "";
            for (TreeNode tn : path) {
                str = str + "/" + tn.toString();
            }
            File file = new File(Settings.getRoot() + str);
            if (file.isFile()) {
                this.setIcon(this.file);
            } else {
                this.setIcon(expanded ? this.openIcon : this.closedIcon);
            }
            return this;
        }
    }
}

