/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import net.modmaker.textureeditor.DrawingPanel;
import net.modmaker.textureeditor.tools.Bucket;
import net.modmaker.textureeditor.tools.Gum;
import net.modmaker.textureeditor.tools.Pen;
import net.modmaker.textureeditor.tools.Pipet;
import net.modmaker.textureeditor.tools.Tool;

public class ToolPanel
extends JPanel {
    public Tool[] tools = new Tool[]{new Pen(), new Gum(), new Bucket(), new Pipet()};
    private DrawingPanel panel;
    private ButtonGroup group = new ButtonGroup();
    private JToggleButton[] buttons = new JToggleButton[this.tools.length];

    public ToolPanel(DrawingPanel panel) {
        this();
        this.panel = panel;
        panel.setSelectedTool(this.tools[0]);
    }

    public ToolPanel() {
        for (int i = 0; i < this.tools.length; ++i) {
            JToggleButton button;
            final Tool tool = this.tools[i];
            this.buttons[i] = button = new JToggleButton(tool.getName());
            this.group.add(button);
            button.setIcon(new ImageIcon(tool.getImage()));
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (button.isSelected() && ToolPanel.this.panel != null) {
                        ToolPanel.this.panel.setSelectedTool(tool);
                    }
                }
            });
        }
        this.buttons[0].setSelected(true);
        this.setBorder(BorderFactory.createTitledBorder("Tools"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup horGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup verGroup = layout.createSequentialGroup();
        for (int i = 0; i < this.buttons.length; ++i) {
            horGroup.addComponent(this.buttons[i], -1, 133, Short.MAX_VALUE);
            if (i == 0) {
                verGroup.addContainerGap();
            } else {
                verGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            verGroup.addComponent(this.buttons[i]);
        }
        verGroup.addContainerGap(158, Short.MAX_VALUE);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(horGroup).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(verGroup));
    }
}

