/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor.layers;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.modmaker.textureeditor.DrawingPanel;

public class Layer
extends BufferedImage {
    private boolean visible = true;
    private JPanel propPanel;
    private DrawingPanel panel;
    private String name;
    private JCheckBox jCheckBox1;

    public Layer(String name, int w, int h, boolean init) {
        super(w, h, 2);
        this.name = name;
        if (init) {
            this.init();
        }
    }

    public Layer(int w, int h, boolean init) {
        super(w, h, 2);
        if (init) {
            this.init();
        }
    }

    public Layer(String name, int w, int h) {
        this(w, h);
        this.name = name;
    }

    private Layer(int w, int h) {
        super(w, h, 2);
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Color getColor(int x, int y) {
        return new Color(this.getRGB(x, y), true);
    }

    public void setColor(int x, int y, Color color) {
        this.setRGB(x, y, color.getRGB());
    }

    public JPanel getPropPanel(DrawingPanel panel) {
        this.panel = panel;
        return this.propPanel;
    }

    private void init() {
        this.propPanel = new JPanel();
        this.propPanel.setBorder(BorderFactory.createTitledBorder("Layer Properties"));
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox1.setSelected(this.visible);
        this.jCheckBox1.setText("Visible");
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Layer.this.setVisible(Layer.this.jCheckBox1.isSelected());
                if (Layer.this.panel != null) {
                    Layer.this.panel.repaint();
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.propPanel);
        this.propPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addContainerGap(154, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox1).addGap(0, 237, Short.MAX_VALUE)));
    }
}

