/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.textureeditor.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import net.modmaker.Utils.Textures;
import net.modmaker.textureeditor.DrawingPanel;
import net.modmaker.textureeditor.layers.Layer;
import net.modmaker.textureeditor.tools.Tool;

public class Bucket
implements Tool {
    private Cursor cursor;
    private ArrayList<Point> done = new ArrayList();

    public Bucket() {
        this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(Textures.cursorBucket, new Point(1, 30), "cursorBucket");
    }

    @Override
    public void onRightClick(DrawingPanel panel, Color color, Layer layer, int x, int y) {
        this.fill(layer.getColor(x, y), color, layer, x, y);
        this.done.clear();
    }

    @Override
    public void onLeftClick(DrawingPanel panel, Color color, Layer layer, int x, int y) {
        this.fill(layer.getColor(x, y), color, layer, x, y);
        this.done.clear();
    }

    public void fill(Color old, Color color, Layer layer, int x, int y) {
        Point z;
        Point n;
        Point e;
        layer.setColor(x, y, color);
        Point point = new Point(x, y);
        this.done.add(point);
        Point w = new Point(x - 1, y);
        if (!this.exists(w, layer) && layer.getColor(x - 1, y).getRGB() == old.getRGB()) {
            this.fill(old, color, layer, x - 1, y);
        }
        if (!this.exists(e = new Point(x + 1, y), layer) && layer.getColor(x + 1, y).getRGB() == old.getRGB()) {
            this.fill(old, color, layer, x + 1, y);
        }
        if (!this.exists(n = new Point(x, y - 1), layer) && layer.getColor(x, y - 1).getRGB() == old.getRGB()) {
            this.fill(old, color, layer, x, y - 1);
        }
        if (!this.exists(z = new Point(x, y + 1), layer) && layer.getColor(x, y + 1).getRGB() == old.getRGB()) {
            this.fill(old, color, layer, x, y + 1);
        }
    }

    private boolean exists(Point point, Layer layer) {
        for (Point p : this.done) {
            if (point.x != p.x || point.y != p.y) continue;
            return true;
        }
        return point.x <= -1 || point.x >= layer.getWidth() || point.y <= -1 || point.y >= layer.getHeight();
    }

    @Override
    public String getName() {
        return "Bucket";
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public Image getImage() {
        return Textures.cursorBucket;
    }
}

